/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.widget.AbsListView;
import com.hpplay.glide.GenericRequestBuilder;
import com.hpplay.glide.Glide;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.target.BaseTarget;
import com.hpplay.glide.request.target.SizeReadyCallback;
import com.hpplay.glide.util.Util;
import java.util.List;
import java.util.Queue;

public class ListPreloader<T>
implements AbsListView.OnScrollListener {
    private final int maxPreload;
    private final PreloadTargetQueue preloadTargetQueue;
    private final PreloadModelProvider<T> preloadModelProvider;
    private final PreloadSizeProvider<T> preloadDimensionProvider;
    private int lastEnd;
    private int lastStart;
    private int lastFirstVisible;
    private int totalItemCount;
    private boolean isIncreasing = true;

    @Deprecated
    public ListPreloader(int n2) {
        this.preloadModelProvider = new PreloadModelProvider<T>(){

            @Override
            public List<T> getPreloadItems(int n2) {
                return ListPreloader.this.getItems(n2, n2 + 1);
            }

            @Override
            public GenericRequestBuilder getPreloadRequestBuilder(T t2) {
                return ListPreloader.this.getRequestBuilder(t2);
            }
        };
        this.preloadDimensionProvider = new PreloadSizeProvider<T>(){

            @Override
            public int[] getPreloadSize(T t2, int n2, int n3) {
                return ListPreloader.this.getDimensions(t2);
            }
        };
        this.maxPreload = n2;
        this.preloadTargetQueue = new PreloadTargetQueue(n2 + 1);
    }

    public ListPreloader(PreloadModelProvider<T> preloadModelProvider, PreloadSizeProvider<T> preloadSizeProvider, int n2) {
        this.preloadModelProvider = preloadModelProvider;
        this.preloadDimensionProvider = preloadSizeProvider;
        this.maxPreload = n2;
        this.preloadTargetQueue = new PreloadTargetQueue(n2 + 1);
    }

    public void onScrollStateChanged(AbsListView absListView, int n2) {
    }

    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        this.totalItemCount = n4;
        if (n2 > this.lastFirstVisible) {
            this.preload(n2 + n3, true);
        } else if (n2 < this.lastFirstVisible) {
            this.preload(n2, false);
        }
        this.lastFirstVisible = n2;
    }

    @Deprecated
    protected int[] getDimensions(T t2) {
        throw new IllegalStateException("You must either provide a PreloadDimensionProvider or override getDimensions()");
    }

    @Deprecated
    protected List<T> getItems(int n2, int n3) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider or override getItems()");
    }

    @Deprecated
    protected GenericRequestBuilder getRequestBuilder(T t2) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider, or override getRequestBuilder()");
    }

    private void preload(int n2, boolean bl) {
        if (this.isIncreasing != bl) {
            this.isIncreasing = bl;
            this.cancelAll();
        }
        this.preload(n2, n2 + (bl ? this.maxPreload : -this.maxPreload));
    }

    private void preload(int n2, int n3) {
        int n4;
        int n5;
        if (n2 < n3) {
            n5 = Math.max(this.lastEnd, n2);
            n4 = n3;
        } else {
            n5 = n3;
            n4 = Math.min(this.lastStart, n2);
        }
        n4 = Math.min(this.totalItemCount, n4);
        n5 = Math.min(this.totalItemCount, Math.max(0, n5));
        if (n2 < n3) {
            for (int i2 = n5; i2 < n4; ++i2) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i2), i2, true);
            }
        } else {
            for (int i3 = n4 - 1; i3 >= n5; --i3) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i3), i3, false);
            }
        }
        this.lastStart = n5;
        this.lastEnd = n4;
    }

    private void preloadAdapterPosition(List<T> list, int n2, boolean bl) {
        int n3 = list.size();
        if (bl) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.preloadItem(list.get(i2), n2, i2);
            }
        } else {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                this.preloadItem(list.get(i3), n2, i3);
            }
        }
    }

    private void preloadItem(T t2, int n2, int n3) {
        int[] nArray = this.preloadDimensionProvider.getPreloadSize(t2, n2, n3);
        if (nArray != null) {
            GenericRequestBuilder genericRequestBuilder = this.preloadModelProvider.getPreloadRequestBuilder(t2);
            genericRequestBuilder.into(this.preloadTargetQueue.next(nArray[0], nArray[1]));
        }
    }

    private void cancelAll() {
        for (int i2 = 0; i2 < this.maxPreload; ++i2) {
            Glide.clear(this.preloadTargetQueue.next(0, 0));
        }
    }

    private static class PreloadTarget
    extends BaseTarget<Object> {
        private int photoHeight;
        private int photoWidth;

        private PreloadTarget() {
        }

        @Override
        public void onResourceReady(Object object, GlideAnimation<? super Object> glideAnimation) {
        }

        @Override
        public void getSize(SizeReadyCallback sizeReadyCallback) {
            sizeReadyCallback.onSizeReady(this.photoWidth, this.photoHeight);
        }
    }

    private static final class PreloadTargetQueue {
        private final Queue<PreloadTarget> queue;

        public PreloadTargetQueue(int n2) {
            this.queue = Util.createQueue(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.queue.offer(new PreloadTarget());
            }
        }

        public PreloadTarget next(int n2, int n3) {
            PreloadTarget preloadTarget = this.queue.poll();
            this.queue.offer(preloadTarget);
            preloadTarget.photoWidth = n2;
            preloadTarget.photoHeight = n3;
            return preloadTarget;
        }
    }

    public static interface PreloadSizeProvider<T> {
        public int[] getPreloadSize(T var1, int var2, int var3);
    }

    public static interface PreloadModelProvider<U> {
        public List<U> getPreloadItems(int var1);

        public GenericRequestBuilder getPreloadRequestBuilder(U var1);
    }
}

