/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6.cli;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;

public abstract class SRP6Tool {
    protected BufferedReader console;

    public SRP6Tool() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        this.console = new BufferedReader(inputStreamReader);
    }

    public String readInput(String string) {
        String string2 = this.console.readLine();
        if (string2 == null || string2.isEmpty()) {
            if (string != null) {
                return string;
            }
            throw new IOException("Missing input");
        }
        return string2.trim();
    }

    public String readInput() {
        return this.readInput(null);
    }

    public BigInteger readBigInteger() {
        BigInteger bigInteger = BigIntegerUtils.fromHex(this.readInput());
        if (bigInteger == null) {
            throw new IOException("Bad hex encoding");
        }
        return bigInteger;
    }

    public SRP6CryptoParams getConfig(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        this.println(string + "Enter prime 'N' (hex): ");
        this.println(string + "\t1 = select precomputed 256-bit");
        this.println(string + "\t2 = select precomputed 512-bit");
        this.println(string + "\t3 = select precomputed 768-bit");
        this.println(string + "\t4 = select precomputed 1024-bit");
        this.println(string + "\t5 = select precomputed 2048-bit");
        this.println(string + "\t6 = enter prime 'N' and generator 'g'");
        this.println();
        this.print(string + "Your choice [1]: ");
        String string2 = this.readInput("1");
        boolean bl = true;
        switch (string2) {
            case "1": {
                bigInteger2 = SRP6CryptoParams.N_256;
                bigInteger = SRP6CryptoParams.g_common;
                break;
            }
            case "2": {
                bigInteger2 = SRP6CryptoParams.N_512;
                bigInteger = SRP6CryptoParams.g_common;
                break;
            }
            case "3": {
                bigInteger2 = SRP6CryptoParams.N_768;
                bigInteger = SRP6CryptoParams.g_common;
                break;
            }
            case "4": {
                bigInteger2 = SRP6CryptoParams.N_1024;
                bigInteger = SRP6CryptoParams.g_common;
                break;
            }
            case "5": {
                bigInteger2 = SRP6CryptoParams.N_2048;
                bigInteger = SRP6CryptoParams.g_common;
                break;
            }
            case "6": {
                this.println();
                this.print(string + "Enter prime 'N' (hex): ");
                bigInteger2 = this.readBigInteger();
                this.print(string + "Enter generator 'g' (hex): ");
                bigInteger = this.readBigInteger();
                bl = false;
                break;
            }
            default: {
                throw new IOException("Unknown choice");
            }
        }
        this.println();
        if (bl) {
            this.println(string + "Selected prime 'N' (hex): " + BigIntegerUtils.toHex(bigInteger2));
            this.println(string + "Selected generator 'g' (hex): " + BigIntegerUtils.toHex(bigInteger));
            this.println();
        }
        this.print(string + "Enter hash algorithm 'H' [SHA-1]: ");
        String string3 = this.readInput("SHA-1");
        this.println();
        return new SRP6CryptoParams(bigInteger2, bigInteger, string3);
    }

    protected void println() {
        System.out.println();
    }

    protected void print(String string) {
        System.out.print(string);
    }

    protected void println(String string) {
    }

    void logShash(byte[] byArray) {
    }

    void logS(String string) {
        this.println("\tComputed shared key 'S' (hex): " + string);
    }

    public abstract void run();
}

