/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import android.os.ParcelFileDescriptor;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolSender;

public class DisconnectionMonitor
extends Thread {
    private static final String TAG = "DisconnectionMonitor";
    private ProtocolSender mProtocolSender;
    private boolean isRunning;
    private ProtocolListener mProtocolListener;

    public DisconnectionMonitor(ProtocolSender protocolSender, ProtocolListener protocolListener) {
        this.mProtocolSender = protocolSender;
        this.mProtocolListener = protocolListener;
        this.setName(TAG);
    }

    @Override
    public void run() {
        super.run();
        try {
            ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = this.mProtocolSender.getInputStream();
            byte[] byArray = new byte[128];
            if (autoCloseInputStream != null) {
                this.isRunning = true;
            }
            CLog.i(TAG, "DisconnectionMonitor start running");
            while (this.isRunning) {
                int n2 = autoCloseInputStream.read(byArray);
                CLog.i(TAG, "read keep alive data " + n2);
                if (n2 == -1) {
                    this.onDisconnect();
                    break;
                }
                CLog.i(TAG, "read keep alive data " + n2);
            }
        }
        catch (Exception exception) {
            this.onDisconnect();
            CLog.w(TAG, exception);
        }
    }

    synchronized void onDisconnect() {
        try {
            if (this.isRunning && this.mProtocolListener != null) {
                CLog.i(TAG, "disconnect callback");
                this.mProtocolListener.onResult(11, "connection_disconnect");
            }
            this.release();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public synchronized void release() {
        CLog.i(TAG, "DisconnectionMonitor release");
        this.isRunning = false;
        if (this.mProtocolSender != null) {
            this.mProtocolSender.release();
            this.mProtocolSender = null;
        }
        this.mProtocolListener = null;
        this.interrupt();
    }
}

