/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.util.Log;

public class UVCControl {
    private static final String TAG = UVCControl.class.getSimpleName();
    public static final int CT_SCANNING_MODE_CONTROL = 1;
    public static final int CT_AE_MODE_CONTROL = 2;
    public static final int CT_AE_PRIORITY_CONTROL = 4;
    public static final int CT_EXPOSURE_TIME_ABSOLUTE_CONTROL = 8;
    public static final int CT_EXPOSURE_TIME_RELATIVE_CONTROL = 16;
    public static final int CT_FOCUS_ABSOLUTE_CONTROL = 32;
    public static final int CT_FOCUS_RELATIVE_CONTROL = 64;
    public static final int CT_IRIS_ABSOLUTE_CONTROL = 128;
    public static final int CT_IRIS_RELATIVE_CONTROL = 256;
    public static final int CT_ZOOM_ABSOLUTE_CONTROL = 512;
    public static final int CT_ZOOM_RELATIVE_CONTROL = 1024;
    public static final int CT_PANTILT_ABSOLUTE_CONTROL = 2048;
    public static final int CT_PANTILT_RELATIVE_CONTROL = 4096;
    public static final int CT_ROLL_ABSOLUTE_CONTROL = 8192;
    public static final int CT_ROLL_RELATIVE_CONTROL = 16384;
    public static final int CT_FOCUS_AUTO_CONTROL = 131072;
    public static final int CT_PRIVACY_CONTROL = 262144;
    public static final int CT_FOCUS_SIMPLE_CONTROL = 524288;
    public static final int CT_WINDOW_CONTROL = 0x100000;
    public static final int PU_BRIGHTNESS_CONTROL = -2147483647;
    public static final int PU_CONTRAST_CONTROL = -2147483646;
    public static final int PU_HUE_CONTROL = -2147483644;
    public static final int PU_SATURATION_CONTROL = -2147483640;
    public static final int PU_SHARPNESS_CONTROL = -2147483632;
    public static final int PU_GAMMA_CONTROL = -2147483616;
    public static final int PU_WHITE_BALANCE_TEMPERATURE_CONTROL = -2147483584;
    public static final int PU_WHITE_BALANCE_COMPONENT_CONTROL = -2147483520;
    public static final int PU_BACKLIGHT_COMPENSATION_CONTROL = -2147483392;
    public static final int PU_GAIN_CONTROL = -2147483136;
    public static final int PU_POWER_LINE_FREQUENCY_CONTROL = -2147482624;
    public static final int PU_HUE_AUTO_CONTROL = -2147481600;
    public static final int PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL = -2147479552;
    public static final int PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL = -2147475456;
    public static final int PU_DIGITAL_MULTIPLIER_CONTROL = -2147467264;
    public static final int PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL = -2147450880;
    public static final int PU_ANALOG_VIDEO_STANDARD_CONTROL = -2147418112;
    public static final int PU_ANALOG_LOCK_STATUS_CONTROL = -2147352576;
    public static final int PU_CONTRAST_AUTO_CONTROL = -2147221504;
    public static final int UVC_AUTO_EXPOSURE_MODE_MANUAL = 1;
    public static final int UVC_AUTO_EXPOSURE_MODE_AUTO = 2;
    public static final int UVC_AUTO_EXPOSURE_MODE_SHUTTER_PRIORITY = 4;
    public static final int UVC_AUTO_EXPOSURE_MODE_APERTURE_PRIORITY = 8;
    private static final String[] CAMERA_TERMINAL_DESCS = new String[]{"D0:  Scanning Mode", "D1:  Auto-Exposure Mode", "D2:  Auto-Exposure Priority", "D3:  Exposure Time (Absolute)", "D4:  Exposure Time (Relative)", "D5:  Focus (Absolute)", "D6:  Focus (Relative)", "D7:  Iris (Absolute)", "D8:  Iris (Relative)", "D9:  Zoom (Absolute)", "D10: Zoom (Relative)", "D11: PanTilt (Absolute)", "D12: PanTilt (Relative)", "D13: Roll (Absolute)", "D14: Roll (Relative)", "D15: Reserved", "D16: Reserved", "D17: Focus, Auto", "D18: Privacy", "D19: Focus, Simple", "D20: Window", "D21: Region of Interest", "D22: Reserved, set to zero", "D23: Reserved, set to zero"};
    private static final String[] PROCESSING_UNIT_DESCS = new String[]{"D0: Brightness", "D1: Contrast", "D2: Hue", "D3: Saturation", "D4: Sharpness", "D5: Gamma", "D6: White Balance Temperature", "D7: White Balance Component", "D8: Backlight Compensation", "D9: Gain", "D10: Power Line Frequency", "D11: Hue, Auto", "D12: White Balance Temperature, Auto", "D13: White Balance Component, Auto", "D14: Digital Multiplier", "D15: Digital Multiplier Limit", "D16: Analog Video Standard", "D17: Analog Video Lock Status", "D18: Contrast, Auto", "D19: Reserved. Set to zero", "D20: Reserved. Set to zero", "D21: Reserved. Set to zero", "D22: Reserved. Set to zero", "D23: Reserved. Set to zero"};
    protected long mNativePtr;
    protected long mCameraTerminalControls;
    protected long mProcessingUnitControls;
    protected int mScanningModeMin;
    protected int mScanningModeMax;
    protected int mScanningModeDef;
    protected int mAutoExposureModeMin;
    protected int mAutoExposureModeMax;
    protected int mAutoExposureModeDef;
    protected int mAutoExposurePriorityMin;
    protected int mAutoExposurePriorityMax;
    protected int mAutoExposurePriorityDef;
    protected int mExposureTimeMin;
    protected int mExposureTimeMax;
    protected int mExposureTimeDef;
    protected int mExposureTimeRelativeMin;
    protected int mExposureTimeRelativeMax;
    protected int mExposureTimeRelativeDef;
    protected int mFocusAbsoluteMin;
    protected int mFocusAbsoluteMax;
    protected int mFocusAbsoluteDef;
    protected int mFocusRelativeMin;
    protected int mFocusRelativeMax;
    protected int mFocusRelativeDef;
    protected int mIrisAbsoluteMin;
    protected int mIrisAbsoluteMax;
    protected int mIrisAbsoluteDef;
    protected int mIrisRelativeMin;
    protected int mIrisRelativeMax;
    protected int mIrisRelativeDef;
    protected int mZoomAbsoluteMin;
    protected int mZoomAbsoluteMax;
    protected int mZoomAbsoluteDef;
    protected int mZoomRelativeMin;
    protected int mZoomRelativeMax;
    protected int mZoomRelativeDef;
    protected int mPanAbsoluteMin;
    protected int mPanAbsoluteMax;
    protected int mPanAbsoluteDef;
    protected int mTiltAbsoluteMin;
    protected int mTiltAbsoluteMax;
    protected int mTiltAbsoluteDef;
    protected int mPanRelativeMin;
    protected int mPanRelativeMax;
    protected int mPanRelativeDef;
    protected int mTiltRelativeMin;
    protected int mTiltRelativeMax;
    protected int mTiltRelativeDef;
    protected int mRollMin;
    protected int mRollMax;
    protected int mRollDef;
    protected int mRollRelativeMin;
    protected int mRollRelativeMax;
    protected int mRollRelativeDef;
    protected int mFocusAutoMin;
    protected int mFocusAutoMax;
    protected int mFocusAutoDef;
    protected int mPrivacyMin;
    protected int mPrivacyMax;
    protected int mPrivacyDef;
    protected int mFocusSimpleMin;
    protected int mFocusSimpleMax;
    protected int mFocusSimpleDef;
    protected int mBrightnessMin;
    protected int mBrightnessMax;
    protected int mBrightnessDef;
    protected int mContrastMin;
    protected int mContrastMax;
    protected int mContrastDef;
    protected int mHueMin;
    protected int mHueMax;
    protected int mHueDef;
    protected int mSaturationMin;
    protected int mSaturationMax;
    protected int mSaturationDef;
    protected int mSharpnessMin;
    protected int mSharpnessMax;
    protected int mSharpnessDef;
    protected int mGammaMin;
    protected int mGammaMax;
    protected int mGammaDef;
    protected int mWhiteBalanceMin;
    protected int mWhiteBalanceMax;
    protected int mWhiteBalanceDef;
    protected int mWhiteBalanceCompoMin;
    protected int mWhiteBalanceCompoMax;
    protected int mWhiteBalanceCompoDef;
    protected int mBacklightCompMin;
    protected int mBacklightCompMax;
    protected int mBacklightCompDef;
    protected int mGainMin;
    protected int mGainMax;
    protected int mGainDef;
    protected int mPowerlineFrequencyMin;
    protected int mPowerlineFrequencyMax;
    protected int mPowerlineFrequencyDef;
    protected int mHueAutoMin;
    protected int mHueAutoMax;
    protected int mHueAutoDef;
    protected int mWhiteBalanceAutoMin;
    protected int mWhiteBalanceAutoMax;
    protected int mWhiteBalanceAutoDef;
    protected int mWhiteBalanceCompoAutoMin;
    protected int mWhiteBalanceCompoAutoMax;
    protected int mWhiteBalanceCompoAutoDef;
    protected int mDigitalMultiplierMin;
    protected int mDigitalMultiplierMax;
    protected int mDigitalMultiplierDef;
    protected int mDigitalMultiplierLimitMin;
    protected int mDigitalMultiplierLimitMax;
    protected int mDigitalMultiplierLimitDef;
    protected int mAnalogVideoStandardMin;
    protected int mAnalogVideoStandardMax;
    protected int mAnalogVideoStandardDef;
    protected int mAnalogVideoLockStateMin;
    protected int mAnalogVideoLockStateMax;
    protected int mAnalogVideoLockStateDef;
    protected int mContrastAutoMin;
    protected int mContrastAutoMax;
    protected int mContrastAutoDef;

    public UVCControl(long ptr) {
        this.mNativePtr = ptr;
        this.updateCameraParams();
    }

    public boolean checkSupportFlag(long flag) {
        this.updateCameraParams();
        if ((flag & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return (this.mProcessingUnitControls & flag) == (flag & Integer.MAX_VALUE);
        }
        return (this.mCameraTerminalControls & flag) == flag;
    }

    public synchronized int[] updateScanningModeLimit() {
        int[] ints = this.nativeObtainScanningModeLimit(this.mNativePtr);
        if (ints != null) {
            this.mScanningModeMin = ints[0];
            this.mScanningModeMax = ints[1];
            this.mScanningModeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isScanningModeEnable() {
        return this.checkSupportFlag(1L);
    }

    public synchronized void setScanningMode(int mode) {
        this.nativeSetScanningMode(this.mNativePtr, mode);
    }

    public synchronized int getScanningMode() {
        return this.nativeGetScanningMode(this.mNativePtr);
    }

    public synchronized void resetScanningMode() {
        this.nativeSetScanningMode(this.mNativePtr, this.mScanningModeDef);
    }

    public synchronized int[] updateAutoExposureModeLimit() {
        int[] ints = this.nativeObtainAutoExposureModeLimit(this.mNativePtr);
        if (ints != null) {
            this.mAutoExposureModeMin = ints[0];
            this.mAutoExposureModeMax = ints[1];
            this.mAutoExposureModeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isAutoExposureModeEnable() {
        return this.checkSupportFlag(2L);
    }

    public synchronized void setAutoExposureMode(int mode) {
        this.nativeSetAutoExposureMode(this.mNativePtr, mode);
    }

    public synchronized int getAutoExposureMode() {
        return this.nativeGetAutoExposureMode(this.mNativePtr);
    }

    public synchronized void resetAutoExposureMode() {
        this.nativeSetAutoExposureMode(this.mNativePtr, this.mAutoExposureModeDef);
    }

    public synchronized void setExposureTimeAuto(boolean auto) {
        int mode = this.getAutoExposureMode();
        if (auto) {
            if (mode == 1) {
                mode = 8;
            } else if (mode == 4) {
                mode = 2;
            }
        } else if (mode == 2) {
            mode = 4;
        } else if (mode == 8) {
            mode = 1;
        }
        this.nativeSetAutoExposureMode(this.mNativePtr, mode);
    }

    public synchronized boolean isExposureTimeAuto() {
        int mode = this.getAutoExposureMode();
        return mode == 2 || mode == 8;
    }

    public synchronized int[] updateAutoExposurePriorityLimit() {
        int[] ints = this.nativeObtainAutoExposurePriorityLimit(this.mNativePtr);
        if (ints != null) {
            this.mAutoExposurePriorityMin = ints[0];
            this.mAutoExposurePriorityMax = ints[1];
            this.mAutoExposurePriorityDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isAutoExposurePriorityEnable() {
        return this.checkSupportFlag(4L);
    }

    public synchronized void setAutoExposurePriority(int priority) {
        this.nativeSetAutoExposurePriority(this.mNativePtr, priority);
    }

    public synchronized int getAutoExposurePriority() {
        return this.nativeGetAutoExposurePriority(this.mNativePtr);
    }

    public synchronized void resetAutoExposurePriority() {
        this.nativeSetAutoExposurePriority(this.mNativePtr, this.mAutoExposurePriorityDef);
    }

    public synchronized int[] updateExposureTimeAbsoluteLimit() {
        int[] ints = this.nativeObtainExposureTimeAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mExposureTimeMin = ints[0];
            this.mExposureTimeMax = ints[1];
            this.mExposureTimeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isExposureTimeAbsoluteEnable() {
        return this.checkSupportFlag(8L);
    }

    public synchronized void setExposureTimeAbsolute(int time) {
        this.nativeSetExposureTimeAbsolute(this.mNativePtr, time);
    }

    public synchronized int getExposureTimeAbsolute() {
        return this.nativeGetExposureTimeAbsolute(this.mNativePtr);
    }

    public synchronized void resetExposureTimeAbsolute() {
        this.nativeSetExposureTimeAbsolute(this.mNativePtr, this.mExposureTimeDef);
    }

    public synchronized int[] updateExposureTimeRelativeLimit() {
        int[] ints = this.nativeObtainExposureTimeRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mExposureTimeRelativeMin = ints[0];
            this.mExposureTimeRelativeMax = ints[1];
            this.mExposureTimeRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isExposureTimeRelativeEnable() {
        return this.checkSupportFlag(16L);
    }

    public synchronized void setExposureTimeRelative(int step) {
        this.nativeSetExposureTimeRelative(this.mNativePtr, step);
    }

    public synchronized int getExposureTimeRelative() {
        return this.nativeGetExposureTimeRelative(this.mNativePtr);
    }

    public synchronized void resetExposureTimeRelative() {
        this.nativeSetExposureTimeRelative(this.mNativePtr, this.mExposureTimeRelativeDef);
    }

    public synchronized int[] updateFocusAbsoluteLimit() {
        int[] ints = this.nativeObtainFocusAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mFocusAbsoluteMin = ints[0];
            this.mFocusAbsoluteMax = ints[1];
            this.mFocusAbsoluteDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isFocusAbsoluteEnable() {
        return this.checkSupportFlag(32L);
    }

    public synchronized void setFocusAbsolute(int focus) {
        this.nativeSetFocusAbsolute(this.mNativePtr, focus);
    }

    public synchronized int getFocusAbsolute() {
        return this.nativeGetFocusAbsolute(this.mNativePtr);
    }

    public synchronized void resetFocusAbsolute() {
        this.nativeSetFocusAbsolute(this.mNativePtr, this.mFocusAbsoluteDef);
    }

    public synchronized void setFocusAbsolutePercent(int percent) {
        float range = Math.abs(this.mFocusAbsoluteMax - this.mFocusAbsoluteMin);
        if (range > 0.0f) {
            this.nativeSetFocusAbsolute(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mFocusAbsoluteMin);
        }
    }

    public synchronized int getFocusAbsolutePercent() {
        int result = 0;
        this.updateFocusAbsoluteLimit();
        float range = Math.abs(this.mFocusAbsoluteMax - this.mFocusAbsoluteMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetFocusAbsolute(this.mNativePtr) - this.mFocusAbsoluteMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateFocusRelativeLimit() {
        int[] ints = this.nativeObtainFocusRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mFocusRelativeMin = ints[0];
            this.mFocusRelativeMax = ints[1];
            this.mFocusRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isFocusRelativeEnable() {
        return this.checkSupportFlag(64L);
    }

    public synchronized void setFocusRelative(int focus) {
        this.nativeSetFocusRelative(this.mNativePtr, focus);
    }

    public synchronized int getFocusRelative() {
        return this.nativeGetFocusRelative(this.mNativePtr);
    }

    public synchronized void resetFocusRelative() {
        this.nativeSetFocusRelative(this.mNativePtr, this.mFocusAbsoluteDef);
    }

    public synchronized int[] updateIrisAbsoluteLimit() {
        int[] ints = this.nativeObtainIrisAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mIrisAbsoluteMin = ints[0];
            this.mIrisAbsoluteMax = ints[1];
            this.mIrisAbsoluteDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isIrisAbsoluteEnable() {
        return this.checkSupportFlag(128L);
    }

    public synchronized void setIrisAbsolute(int iris) {
        this.nativeSetIrisAbsolute(this.mNativePtr, iris);
    }

    public synchronized int getIrisAbsolute() {
        return this.nativeGetIrisAbsolute(this.mNativePtr);
    }

    public synchronized void resetIrisAbsolute() {
        this.nativeSetIrisAbsolute(this.mNativePtr, this.mIrisAbsoluteDef);
    }

    public synchronized int[] updateIrisRelativeLimit() {
        int[] ints = this.nativeObtainIrisRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mIrisRelativeMin = ints[0];
            this.mIrisRelativeMax = ints[1];
            this.mIrisRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isIrisRelativeEnable() {
        return this.checkSupportFlag(256L);
    }

    public synchronized void setIrisRelative(int iris) {
        this.nativeSetIrisRelative(this.mNativePtr, iris);
    }

    public synchronized int getIrisRelative() {
        return this.nativeGetIrisRelative(this.mNativePtr);
    }

    public synchronized void resetIrisRelative() {
        this.nativeSetIrisRelative(this.mNativePtr, this.mIrisRelativeDef);
    }

    public synchronized int[] updateZoomAbsoluteLimit() {
        int[] ints = this.nativeObtainZoomAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mZoomAbsoluteMin = ints[0];
            this.mZoomAbsoluteMax = ints[1];
            this.mZoomAbsoluteDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isZoomAbsoluteEnable() {
        return this.checkSupportFlag(512L);
    }

    public synchronized void setZoomAbsolute(int zoom) {
        this.nativeSetZoomAbsolute(this.mNativePtr, zoom);
    }

    public synchronized int getZoomAbsolute() {
        return this.nativeGetZoomAbsolute(this.mNativePtr);
    }

    public synchronized void resetZoomAbsolute() {
        this.nativeSetZoomAbsolute(this.mNativePtr, this.mZoomAbsoluteDef);
    }

    public synchronized void setZoomAbsolutePercent(int percent) {
        float range = Math.abs(this.mZoomAbsoluteMax - this.mZoomAbsoluteMin);
        if (range > 0.0f) {
            int z = (int)((float)percent / 100.0f * range) + this.mZoomAbsoluteMin;
            this.nativeSetZoomAbsolute(this.mNativePtr, z);
        }
    }

    public synchronized int getZoomAbsolutePercent() {
        int result = 0;
        this.updateZoomAbsoluteLimit();
        float range = Math.abs(this.mZoomAbsoluteMax - this.mZoomAbsoluteMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetZoomAbsolute(this.mNativePtr) - this.mZoomAbsoluteMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateZoomRelativeLimit() {
        int[] ints = this.nativeObtainZoomRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mZoomRelativeMin = ints[0];
            this.mZoomRelativeMax = ints[1];
            this.mZoomRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isZoomRelativeEnable() {
        return this.checkSupportFlag(1024L);
    }

    public synchronized void setZoomRelative(int zoom) {
        this.nativeSetZoomRelative(this.mNativePtr, zoom);
    }

    public synchronized int getZoomRelative() {
        return this.nativeGetZoomRelative(this.mNativePtr);
    }

    public synchronized void resetZoomRelative() {
        this.nativeSetZoomRelative(this.mNativePtr, this.mZoomRelativeDef);
    }

    public synchronized int[] updatePanAbsoluteLimit() {
        int[] ints = this.nativeObtainPanAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mPanAbsoluteMin = ints[0];
            this.mPanAbsoluteMax = ints[1];
            this.mPanAbsoluteDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isPanAbsoluteEnable() {
        return this.checkSupportFlag(2048L);
    }

    public synchronized void setPanAbsolute(int pan) {
        this.nativeSetPanAbsolute(this.mNativePtr, pan);
    }

    public synchronized int getPanAbsolute() {
        return this.nativeGetPanAbsolute(this.mNativePtr);
    }

    public synchronized void resetPanAbsolute() {
        this.nativeSetPanAbsolute(this.mNativePtr, this.mPanAbsoluteDef);
    }

    public synchronized int[] updateTiltAbsoluteLimit() {
        int[] ints = this.nativeObtainTiltAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mTiltAbsoluteMin = ints[0];
            this.mTiltAbsoluteMax = ints[1];
            this.mTiltAbsoluteDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isTiltAbsoluteEnable() {
        return this.checkSupportFlag(2048L);
    }

    public synchronized void setTiltAbsolute(int pan) {
        this.nativeSetTiltAbsolute(this.mNativePtr, pan);
    }

    public synchronized int getTiltAbsolute() {
        return this.nativeGetTiltAbsolute(this.mNativePtr);
    }

    public synchronized void resetTiltAbsolute() {
        this.nativeSetTiltAbsolute(this.mNativePtr, this.mTiltAbsoluteDef);
    }

    public synchronized int[] updatePanRelativeLimit() {
        int[] ints = this.nativeObtainPanRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mPanRelativeMin = ints[0];
            this.mPanRelativeMax = ints[1];
            this.mPanRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isPanRelativeEnable() {
        return this.checkSupportFlag(4096L);
    }

    public synchronized void setPanRelative(int PanRelative) {
        this.nativeSetPanRelative(this.mNativePtr, PanRelative);
    }

    public synchronized int getPanRelative() {
        return this.nativeGetPanRelative(this.mNativePtr);
    }

    public synchronized void resetPanRelative() {
        this.nativeSetPanRelative(this.mNativePtr, this.mPanRelativeDef);
    }

    public synchronized int[] updateTiltRelativeLimit() {
        int[] ints = this.nativeObtainTiltRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mTiltRelativeMin = ints[0];
            this.mTiltRelativeMax = ints[1];
            this.mTiltRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isTiltRelativeEnable() {
        return this.checkSupportFlag(4096L);
    }

    public synchronized void setTiltRelative(int TiltRelative) {
        this.nativeSetTiltRelative(this.mNativePtr, TiltRelative);
    }

    public synchronized int getTiltRelative() {
        return this.nativeGetTiltRelative(this.mNativePtr);
    }

    public synchronized void resetTiltRelative() {
        this.nativeSetTiltRelative(this.mNativePtr, this.mTiltRelativeDef);
    }

    public synchronized int[] updateRollAbsoluteLimit() {
        int[] ints = this.nativeObtainRollAbsoluteLimit(this.mNativePtr);
        if (ints != null) {
            this.mRollMin = ints[0];
            this.mRollMax = ints[1];
            this.mRollDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isRollAbsoluteEnable() {
        return this.checkSupportFlag(8192L);
    }

    public synchronized void setRollAbsolute(int roll) {
        this.nativeSetRollAbsolute(this.mNativePtr, roll);
    }

    public synchronized int getRollAbsolute() {
        return this.nativeGetRollAbsolute(this.mNativePtr);
    }

    public synchronized void resetRollAbsolute() {
        this.nativeSetRollAbsolute(this.mNativePtr, this.mRollDef);
    }

    public synchronized int[] updateRollRelativeLimit() {
        int[] ints = this.nativeObtainRollRelativeLimit(this.mNativePtr);
        if (ints != null) {
            this.mRollRelativeMin = ints[0];
            this.mRollRelativeMax = ints[1];
            this.mRollRelativeDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isRollRelativeEnable() {
        return this.checkSupportFlag(16384L);
    }

    public synchronized void setRollRelative(int roll) {
        this.nativeSetRollRelative(this.mNativePtr, roll);
    }

    public synchronized int getRollRelative() {
        return this.nativeGetRollRelative(this.mNativePtr);
    }

    public synchronized void resetRollRelative() {
        this.nativeSetRollRelative(this.mNativePtr, this.mRollRelativeDef);
    }

    public synchronized int[] updateFocusAutoLimit() {
        int[] ints = this.nativeObtainFocusAutoLimit(this.mNativePtr);
        if (ints != null) {
            this.mFocusAutoMin = ints[0];
            this.mFocusAutoMax = ints[1];
            this.mFocusAutoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isFocusAutoEnable() {
        return this.checkSupportFlag(131072L);
    }

    public synchronized void setFocusAuto(boolean state) {
        this.nativeSetFocusAuto(this.mNativePtr, state);
    }

    public synchronized boolean getFocusAuto() {
        return this.nativeGetFocusAuto(this.mNativePtr) > 0;
    }

    public synchronized void resetFocusAuto() {
        this.nativeSetFocusAuto(this.mNativePtr, this.mFocusAutoDef > 0);
    }

    public synchronized int[] updatePrivacyLimit() {
        int[] ints = this.nativeObtainPrivacyLimit(this.mNativePtr);
        if (ints != null) {
            this.mPrivacyMin = ints[0];
            this.mPrivacyMax = ints[1];
            this.mPrivacyDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isPrivacyEnable() {
        return this.checkSupportFlag(262144L);
    }

    public synchronized void setPrivacy(boolean state) {
        this.nativeSetPrivacy(this.mNativePtr, state);
    }

    public synchronized boolean getPrivacy() {
        return this.nativeGetPrivacy(this.mNativePtr) > 0;
    }

    public synchronized void resetPrivacy() {
        this.nativeSetPrivacy(this.mNativePtr, this.mPrivacyDef > 0);
    }

    public synchronized int[] updateBrightnessLimit() {
        int[] ints = this.nativeObtainBrightnessLimit(this.mNativePtr);
        if (ints != null) {
            this.mBrightnessMin = ints[0];
            this.mBrightnessMax = ints[1];
            this.mBrightnessDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isBrightnessEnable() {
        return this.checkSupportFlag(-2147483647L);
    }

    public synchronized void setBrightness(int brightness) {
        this.nativeSetBrightness(this.mNativePtr, brightness);
    }

    public synchronized int getBrightness() {
        return this.nativeGetBrightness(this.mNativePtr);
    }

    public synchronized void resetBrightness() {
        this.nativeSetBrightness(this.mNativePtr, this.mBrightnessDef);
    }

    public synchronized void setBrightnessPercent(int percent) {
        float range = Math.abs(this.mBrightnessMax - this.mBrightnessMin);
        if (range > 0.0f) {
            this.nativeSetBrightness(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mBrightnessMin);
        }
    }

    public synchronized int getBrightnessPercent() {
        int result = 0;
        this.updateBrightnessLimit();
        float range = Math.abs(this.mBrightnessMax - this.mBrightnessMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetBrightness(this.mNativePtr) - this.mBrightnessMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateContrastLimit() {
        int[] ints = this.nativeObtainContrastLimit(this.mNativePtr);
        if (ints != null) {
            this.mContrastMin = ints[0];
            this.mContrastMax = ints[1];
            this.mContrastDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isContrastEnable() {
        return this.checkSupportFlag(-2147483646L);
    }

    public synchronized void setContrast(int contrast) {
        this.nativeSetContrast(this.mNativePtr, contrast);
    }

    public synchronized int getContrast() {
        return this.nativeGetContrast(this.mNativePtr);
    }

    public synchronized void resetContrast() {
        this.nativeSetContrast(this.mNativePtr, this.mContrastDef);
    }

    public synchronized void setContrastPercent(int percent) {
        this.updateContrastLimit();
        float range = Math.abs(this.mContrastMax - this.mContrastMin);
        if (range > 0.0f) {
            this.nativeSetContrast(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mContrastMin);
        }
    }

    public synchronized int getContrastPercent() {
        int result = 0;
        float range = Math.abs(this.mContrastMax - this.mContrastMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetContrast(this.mNativePtr) - this.mContrastMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateHueLimit() {
        int[] ints = this.nativeObtainHueLimit(this.mNativePtr);
        if (ints != null) {
            this.mHueMin = ints[0];
            this.mHueMax = ints[1];
            this.mHueDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isHueEnable() {
        return this.checkSupportFlag(-2147483644L);
    }

    public synchronized void setHue(int hue) {
        this.nativeSetHue(this.mNativePtr, hue);
    }

    public synchronized int getHue() {
        return this.nativeGetHue(this.mNativePtr);
    }

    public synchronized void resetHue() {
        this.nativeSetHue(this.mNativePtr, this.mHueDef);
    }

    public synchronized void setHuePercent(int percent) {
        float range = Math.abs(this.mHueMax - this.mHueMin);
        if (range > 0.0f) {
            this.nativeSetHue(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mHueMin);
        }
    }

    public synchronized int getHuePercent() {
        int result = 0;
        this.nativeObtainHueLimit(this.mNativePtr);
        float range = Math.abs(this.mHueMax - this.mHueMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetHue(this.mNativePtr) - this.mHueMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateSaturationLimit() {
        int[] ints = this.nativeObtainSaturationLimit(this.mNativePtr);
        if (ints != null) {
            this.mSaturationMin = ints[0];
            this.mSaturationMax = ints[1];
            this.mSaturationDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isSaturationEnable() {
        return this.checkSupportFlag(-2147483640L);
    }

    public synchronized void setSaturation(int saturation) {
        this.nativeSetSaturation(this.mNativePtr, saturation);
    }

    public synchronized int getSaturation() {
        return this.nativeGetSaturation(this.mNativePtr);
    }

    public synchronized void resetSaturation() {
        this.nativeSetSaturation(this.mNativePtr, this.mSaturationDef);
    }

    public synchronized void setSaturationPercent(int percent) {
        float range = Math.abs(this.mSaturationMax - this.mSaturationMin);
        if (range > 0.0f) {
            this.nativeSetSaturation(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mSaturationMin);
        }
    }

    public synchronized int getSaturationPercent() {
        int result = 0;
        this.updateSaturationLimit();
        float range = Math.abs(this.mSaturationMax - this.mSaturationMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetSaturation(this.mNativePtr) - this.mSaturationMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateSharpnessLimit() {
        int[] ints = this.nativeObtainSharpnessLimit(this.mNativePtr);
        if (ints != null) {
            this.mSharpnessMin = ints[0];
            this.mSharpnessMax = ints[1];
            this.mSharpnessDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isSharpnessEnable() {
        return this.checkSupportFlag(-2147483632L);
    }

    public synchronized void setSharpness(int sharpness) {
        this.nativeSetSharpness(this.mNativePtr, sharpness);
    }

    public synchronized int getSharpness() {
        return this.nativeGetSharpness(this.mNativePtr);
    }

    public synchronized void resetSharpness() {
        this.nativeSetSharpness(this.mNativePtr, this.mSharpnessDef);
    }

    public synchronized void setSharpnessPercent(int percent) {
        float range = Math.abs(this.mSharpnessMax - this.mSharpnessMin);
        if (range > 0.0f) {
            this.nativeSetSharpness(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mSharpnessMin);
        }
    }

    public synchronized int getSharpnessPercent() {
        int result = 0;
        this.updateSharpnessLimit();
        float range = Math.abs(this.mSharpnessMax - this.mSharpnessMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetSharpness(this.mNativePtr) - this.mSharpnessMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateGammaLimit() {
        int[] ints = this.nativeObtainGammaLimit(this.mNativePtr);
        if (ints != null) {
            this.mGammaMin = ints[0];
            this.mGammaMax = ints[1];
            this.mGammaDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isGammaEnable() {
        return this.checkSupportFlag(-2147483616L);
    }

    public synchronized void setGamma(int gamma) {
        this.nativeSetGamma(this.mNativePtr, gamma);
    }

    public synchronized int getGamma() {
        return this.nativeGetGamma(this.mNativePtr);
    }

    public synchronized void resetGamma() {
        this.nativeSetGamma(this.mNativePtr, this.mGammaDef);
    }

    public synchronized void setGammaPercent(int percent) {
        float range = Math.abs(this.mGammaMax - this.mGammaMin);
        if (range > 0.0f) {
            this.nativeSetGamma(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mGammaMin);
        }
    }

    public synchronized int getGammaPercent() {
        int result = 0;
        this.updateGammaLimit();
        float range = Math.abs(this.mGammaMax - this.mGammaMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetGamma(this.mNativePtr) - this.mGammaMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateWhiteBalanceLimit() {
        int[] ints = this.nativeObtainWhiteBalanceLimit(this.mNativePtr);
        if (ints != null) {
            this.mWhiteBalanceMin = ints[0];
            this.mWhiteBalanceMax = ints[1];
            this.mWhiteBalanceDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isWhiteBalanceEnable() {
        return this.checkSupportFlag(-2147483584L);
    }

    public synchronized void setWhiteBalance(int whiteBalance) {
        this.nativeSetWhiteBalance(this.mNativePtr, whiteBalance);
    }

    public synchronized int getWhiteBalance() {
        return this.nativeGetWhiteBalance(this.mNativePtr);
    }

    public synchronized void resetWhiteBalance() {
        this.nativeSetWhiteBalance(this.mNativePtr, this.mWhiteBalanceDef);
    }

    public synchronized void setWhiteBalancePercent(int percent) {
        float range = Math.abs(this.mWhiteBalanceMax - this.mWhiteBalanceMin);
        if (range > 0.0f) {
            this.nativeSetWhiteBalance(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mWhiteBalanceMin);
        }
    }

    public synchronized int getWhiteBalancePercent() {
        int result = 0;
        this.updateWhiteBalanceLimit();
        float range = Math.abs(this.mWhiteBalanceMax - this.mWhiteBalanceMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetWhiteBalance(this.mNativePtr) - this.mWhiteBalanceMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updateWhiteBalanceCompoLimit() {
        int[] ints = this.nativeObtainWhiteBalanceCompoLimit(this.mNativePtr);
        if (ints != null) {
            this.mWhiteBalanceCompoMin = ints[0];
            this.mWhiteBalanceCompoMax = ints[1];
            this.mWhiteBalanceCompoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isWhiteBalanceCompoEnable() {
        return this.checkSupportFlag(-2147483520L);
    }

    public synchronized void setWhiteBalanceCompo(int component) {
        this.nativeSetWhiteBalanceCompo(this.mNativePtr, component);
    }

    public synchronized int getWhiteBalanceCompo() {
        return this.nativeGetWhiteBalanceCompo(this.mNativePtr);
    }

    public synchronized void resetWhiteBalanceCompo() {
        this.nativeSetZoomRelative(this.mNativePtr, this.mWhiteBalanceCompoDef);
    }

    public synchronized int[] updateBacklightCompLimit() {
        int[] ints = this.nativeObtainBacklightCompLimit(this.mNativePtr);
        if (ints != null) {
            this.mBacklightCompMin = ints[0];
            this.mBacklightCompMax = ints[1];
            this.mBacklightCompDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isBacklightCompEnable() {
        return this.checkSupportFlag(-2147483392L);
    }

    public synchronized void setBacklightComp(int backlight_compensation) {
        this.nativeSetBacklightComp(this.mNativePtr, backlight_compensation);
    }

    public synchronized int getBacklightComp() {
        return this.nativeGetBacklightComp(this.mNativePtr);
    }

    public synchronized void resetBacklightComp() {
        this.nativeSetBacklightComp(this.mNativePtr, this.mBacklightCompDef);
    }

    public synchronized int[] updateGainLimit() {
        int[] ints = this.nativeObtainGainLimit(this.mNativePtr);
        if (ints != null) {
            this.mGainMin = ints[0];
            this.mGainMax = ints[1];
            this.mGainDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isGainEnable() {
        return this.checkSupportFlag(-2147483136L);
    }

    public synchronized void setGain(int gain) {
        this.nativeSetGain(this.mNativePtr, gain);
    }

    public synchronized int getGain() {
        return this.nativeGetGain(this.mNativePtr);
    }

    public synchronized void resetGain() {
        this.nativeSetGain(this.mNativePtr, this.mGainDef);
    }

    public synchronized void setGainPercent(int percent) {
        float range = Math.abs(this.mGainMax - this.mGainMin);
        if (range > 0.0f) {
            this.nativeSetGain(this.mNativePtr, (int)((float)percent / 100.0f * range) + this.mGainMin);
        }
    }

    public synchronized int getGainPercent() {
        int result = 0;
        this.updateGainLimit();
        float range = Math.abs(this.mGainMax - this.mGainMin);
        if (range > 0.0f) {
            result = (int)((float)(this.nativeGetGain(this.mNativePtr) - this.mGainMin) * 100.0f / range);
        }
        return result;
    }

    public synchronized int[] updatePowerlineFrequencyLimit() {
        int[] ints = this.nativeObtainPowerlineFrequencyLimit(this.mNativePtr);
        if (ints != null) {
            this.mPowerlineFrequencyMin = ints[0];
            this.mPowerlineFrequencyMax = ints[1];
            this.mPowerlineFrequencyDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isPowerlineFrequencyEnable() {
        return this.checkSupportFlag(-2147482624L);
    }

    public void setPowerlineFrequency(int frequency) {
        this.nativeSetPowerlineFrequency(this.mNativePtr, frequency);
    }

    public int getPowerlineFrequency() {
        return this.nativeGetPowerlineFrequency(this.mNativePtr);
    }

    public synchronized void resetPowerlineFrequency() {
        this.nativeSetPowerlineFrequency(this.mNativePtr, this.mPowerlineFrequencyDef);
    }

    public synchronized int[] updateHueAutoLimit() {
        int[] ints = this.nativeObtainHueAutoLimit(this.mNativePtr);
        if (ints != null) {
            this.mHueAutoMin = ints[0];
            this.mHueAutoMax = ints[1];
            this.mHueAutoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isHueAutoEnable() {
        return this.checkSupportFlag(-2147481600L);
    }

    public synchronized void setHueAuto(boolean state) {
        this.nativeSetHueAuto(this.mNativePtr, state);
    }

    public synchronized boolean getHueAuto() {
        return this.nativeGetHueAuto(this.mNativePtr) > 0;
    }

    public synchronized void resetHueAuto() {
        this.nativeSetHueAuto(this.mNativePtr, this.mHueAutoDef > 0);
    }

    public synchronized int[] updateWhiteBalanceAutoLimit() {
        int[] ints = this.nativeObtainWhiteBalanceAutoLimit(this.mNativePtr);
        if (ints != null) {
            this.mWhiteBalanceAutoMin = ints[0];
            this.mWhiteBalanceAutoMax = ints[1];
            this.mWhiteBalanceAutoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isWhiteBalanceAutoEnable() {
        return this.checkSupportFlag(-2147479552L);
    }

    public synchronized void setWhiteBalanceAuto(boolean whiteBalanceAuto) {
        this.nativeSetWhiteBalanceAuto(this.mNativePtr, whiteBalanceAuto);
    }

    public synchronized boolean getWhiteBalanceAuto() {
        return this.nativeGetWhiteBalanceAuto(this.mNativePtr) > 0;
    }

    public synchronized void resetWhiteBalanceAuto() {
        this.nativeSetWhiteBalanceAuto(this.mNativePtr, this.mWhiteBalanceAutoDef > 0);
    }

    public synchronized int[] updateWhiteBalanceCompoAutoLimit() {
        int[] ints = this.nativeObtainWhiteBalanceCompoAutoLimit(this.mNativePtr);
        if (ints != null) {
            this.mWhiteBalanceCompoAutoMin = ints[0];
            this.mWhiteBalanceCompoAutoMax = ints[1];
            this.mWhiteBalanceCompoAutoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isWhiteBalanceCompoAutoEnable() {
        return this.checkSupportFlag(-2147475456L);
    }

    public synchronized void setWhiteBalanceCompoAuto(boolean whiteBalanceCompoAuto) {
        this.nativeSetWhiteBalanceCompoAuto(this.mNativePtr, whiteBalanceCompoAuto);
    }

    public synchronized boolean getWhiteBalanceCompoAuto() {
        return this.nativeGetWhiteBalanceCompoAuto(this.mNativePtr) > 0;
    }

    public synchronized void resetWhiteBalanceCompoAuto() {
        this.nativeSetWhiteBalanceCompoAuto(this.mNativePtr, this.mWhiteBalanceCompoAutoDef > 0);
    }

    public synchronized int[] updateDigitalMultiplierLimit() {
        int[] ints = this.nativeObtainDigitalMultiplierLimit(this.mNativePtr);
        if (ints != null) {
            this.mDigitalMultiplierMin = ints[0];
            this.mDigitalMultiplierMax = ints[1];
            this.mDigitalMultiplierDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isDigitalMultiplierEnable() {
        return this.checkSupportFlag(-2147467264L);
    }

    public void setDigitalMultiplier(int digitalMultiplier) {
        this.nativeSetDigitalMultiplier(this.mNativePtr, digitalMultiplier);
    }

    public int getDigitalMultiplier() {
        return this.nativeGetDigitalMultiplier(this.mNativePtr);
    }

    public synchronized void resetDigitalMultiplier() {
        this.nativeSetDigitalMultiplier(this.mNativePtr, this.mDigitalMultiplierDef);
    }

    public synchronized int[] updateDigitalMultiplierLimitLimit() {
        int[] ints = this.nativeObtainDigitalMultiplierLimitLimit(this.mNativePtr);
        if (ints != null) {
            this.mDigitalMultiplierLimitMin = ints[0];
            this.mDigitalMultiplierLimitMax = ints[1];
            this.mDigitalMultiplierLimitDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isDigitalMultiplierLimitEnable() {
        return this.checkSupportFlag(-2147450880L);
    }

    public void setDigitalMultiplierLimit(int digitalMultiplierLimit) {
        this.nativeSetDigitalMultiplierLimit(this.mNativePtr, digitalMultiplierLimit);
    }

    public int getDigitalMultiplierLimit() {
        return this.nativeGetDigitalMultiplierLimit(this.mNativePtr);
    }

    public synchronized void resetDigitalMultiplierLimit() {
        this.nativeSetDigitalMultiplierLimit(this.mNativePtr, this.mDigitalMultiplierLimitDef);
    }

    public synchronized int[] updateAnalogVideoStandardLimit() {
        int[] ints = this.nativeObtainAnalogVideoStandardLimit(this.mNativePtr);
        if (ints != null) {
            this.mAnalogVideoStandardMin = ints[0];
            this.mAnalogVideoStandardMax = ints[1];
            this.mAnalogVideoStandardDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isAnalogVideoStandardEnable() {
        return this.checkSupportFlag(-2147418112L);
    }

    public void setAnalogVideoStandard(int analogVideoStandard) {
        this.nativeSetAnalogVideoStandard(this.mNativePtr, analogVideoStandard);
    }

    public int getAnalogVideoStandard() {
        return this.nativeGetAnalogVideoStandard(this.mNativePtr);
    }

    public synchronized void resetAnalogVideoStandard() {
        this.nativeSetAnalogVideoStandard(this.mNativePtr, this.mAnalogVideoStandardDef);
    }

    public synchronized int[] updateAnalogVideoLockStateLimit() {
        int[] ints = this.nativeObtainAnalogVideoLockStateLimit(this.mNativePtr);
        if (ints != null) {
            this.mAnalogVideoLockStateMin = ints[0];
            this.mAnalogVideoLockStateMax = ints[1];
            this.mAnalogVideoLockStateDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isAnalogVideoLockStateEnable() {
        return this.checkSupportFlag(-2147352576L);
    }

    public void setAnalogVideoLockState(int analogVideoLockState) {
        this.nativeSetAnalogVideoLockState(this.mNativePtr, analogVideoLockState);
    }

    public int getAnalogVideoLockState() {
        return this.nativeGetAnalogVideoLockState(this.mNativePtr);
    }

    public synchronized void resetAnalogVideoLockState() {
        this.nativeSetAnalogVideoLockState(this.mNativePtr, this.mAnalogVideoLockStateDef);
    }

    public synchronized int[] updateContrastAutoLimit() {
        int[] ints = this.nativeObtainContrastAutoLimit(this.mNativePtr);
        if (ints != null) {
            this.mContrastAutoMin = ints[0];
            this.mContrastAutoMax = ints[1];
            this.mContrastAutoDef = ints[2];
        }
        return ints;
    }

    public synchronized boolean isContrastAutoEnable() {
        return this.checkSupportFlag(-2147221504L);
    }

    public synchronized void setContrastAuto(boolean state) {
        this.nativeSetContrastAuto(this.mNativePtr, state);
    }

    public synchronized boolean getContrastAuto() {
        return this.nativeGetContrastAuto(this.mNativePtr) > 0;
    }

    public synchronized void resetContrastAuto() {
        this.nativeSetContrastAuto(this.mNativePtr, this.mContrastAutoDef > 0);
    }

    public synchronized void updateCameraParams() {
        if (this.mNativePtr != 0L) {
            if (this.mCameraTerminalControls == 0L || this.mProcessingUnitControls == 0L) {
                if (this.mCameraTerminalControls == 0L) {
                    this.mCameraTerminalControls = this.nativeGetCameraTerminalControls(this.mNativePtr);
                }
                if (this.mProcessingUnitControls == 0L) {
                    this.mProcessingUnitControls = this.nativeGetProcessingUnitControls(this.mNativePtr);
                }
                if (this.mCameraTerminalControls != 0L && this.mProcessingUnitControls != 0L) {
                    this.updateScanningModeLimit();
                    this.updateAutoExposureModeLimit();
                    this.updateAutoExposurePriorityLimit();
                    this.updateExposureTimeAbsoluteLimit();
                    this.updateExposureTimeRelativeLimit();
                    this.updateFocusAbsoluteLimit();
                    this.updateFocusRelativeLimit();
                    this.updateIrisAbsoluteLimit();
                    this.updateIrisRelativeLimit();
                    this.updateZoomAbsoluteLimit();
                    this.updateZoomRelativeLimit();
                    this.updatePanAbsoluteLimit();
                    this.updateTiltAbsoluteLimit();
                    this.updatePanRelativeLimit();
                    this.updateTiltRelativeLimit();
                    this.updateRollAbsoluteLimit();
                    this.updateRollRelativeLimit();
                    this.updateFocusAutoLimit();
                    this.updatePrivacyLimit();
                    this.updateBrightnessLimit();
                    this.updateContrastLimit();
                    this.updateHueLimit();
                    this.updateSaturationLimit();
                    this.updateSharpnessLimit();
                    this.updateGammaLimit();
                    this.updateWhiteBalanceLimit();
                    this.updateWhiteBalanceCompoLimit();
                    this.updateBacklightCompLimit();
                    this.updateGainLimit();
                    this.updatePowerlineFrequencyLimit();
                    this.updateHueAutoLimit();
                    this.updateWhiteBalanceAutoLimit();
                    this.updateWhiteBalanceCompoAutoLimit();
                    this.updateDigitalMultiplierLimit();
                    this.updateDigitalMultiplierLimitLimit();
                    this.updateAnalogVideoStandardLimit();
                    this.updateAnalogVideoLockStateLimit();
                    this.updateContrastAutoLimit();
                }
            }
        } else {
            this.mProcessingUnitControls = 0L;
            this.mCameraTerminalControls = 0L;
        }
    }

    public void release() {
        this.mNativePtr = 0L;
        this.mProcessingUnitControls = 0L;
        this.mCameraTerminalControls = 0L;
    }

    private void dumpCameraTerminal(long CameraTerminalControls) {
        Log.i((String)TAG, (String)String.format("CameraTerminalControls=%x", CameraTerminalControls));
        for (int i = 0; i < CAMERA_TERMINAL_DESCS.length; ++i) {
            Log.i((String)TAG, (String)(CAMERA_TERMINAL_DESCS[i] + ((CameraTerminalControls & (long)(1 << i)) != 0L ? "=enabled" : "=disabled")));
        }
    }

    private void dumpProcessingUnit(long ProcessingUnitControls) {
        Log.i((String)TAG, (String)String.format("ProcessingUnitControls=%x", ProcessingUnitControls));
        for (int i = 0; i < PROCESSING_UNIT_DESCS.length; ++i) {
            Log.i((String)TAG, (String)(PROCESSING_UNIT_DESCS[i] + ((ProcessingUnitControls & (long)(1 << i)) != 0L ? "=enabled" : "=disabled")));
        }
    }

    private native long nativeGetCameraTerminalControls(long var1);

    private native long nativeGetProcessingUnitControls(long var1);

    private native int[] nativeObtainScanningModeLimit(long var1);

    private native int nativeSetScanningMode(long var1, int var3);

    private native int nativeGetScanningMode(long var1);

    private native int[] nativeObtainAutoExposureModeLimit(long var1);

    private native int nativeSetAutoExposureMode(long var1, int var3);

    private native int nativeGetAutoExposureMode(long var1);

    private native int[] nativeObtainAutoExposurePriorityLimit(long var1);

    private native int nativeSetAutoExposurePriority(long var1, int var3);

    private native int nativeGetAutoExposurePriority(long var1);

    private native int[] nativeObtainExposureTimeAbsoluteLimit(long var1);

    private native int nativeSetExposureTimeAbsolute(long var1, int var3);

    private native int nativeGetExposureTimeAbsolute(long var1);

    private native int[] nativeObtainExposureTimeRelativeLimit(long var1);

    private native int nativeSetExposureTimeRelative(long var1, int var3);

    private native int nativeGetExposureTimeRelative(long var1);

    private native int[] nativeObtainFocusAbsoluteLimit(long var1);

    private native int nativeSetFocusAbsolute(long var1, int var3);

    private native int nativeGetFocusAbsolute(long var1);

    private native int[] nativeObtainFocusRelativeLimit(long var1);

    private native int nativeSetFocusRelative(long var1, int var3);

    private native int nativeGetFocusRelative(long var1);

    private native int[] nativeObtainIrisAbsoluteLimit(long var1);

    private native int nativeSetIrisAbsolute(long var1, int var3);

    private native int nativeGetIrisAbsolute(long var1);

    private native int[] nativeObtainIrisRelativeLimit(long var1);

    private native int nativeSetIrisRelative(long var1, int var3);

    private native int nativeGetIrisRelative(long var1);

    private native int[] nativeObtainZoomAbsoluteLimit(long var1);

    private native int nativeSetZoomAbsolute(long var1, int var3);

    private native int nativeGetZoomAbsolute(long var1);

    private native int[] nativeObtainZoomRelativeLimit(long var1);

    private native int nativeSetZoomRelative(long var1, int var3);

    private native int nativeGetZoomRelative(long var1);

    private native int[] nativeObtainPanAbsoluteLimit(long var1);

    private native int nativeSetPanAbsolute(long var1, int var3);

    private native int nativeGetPanAbsolute(long var1);

    private native int[] nativeObtainTiltAbsoluteLimit(long var1);

    private native int nativeSetTiltAbsolute(long var1, int var3);

    private native int nativeGetTiltAbsolute(long var1);

    private native int[] nativeObtainPanRelativeLimit(long var1);

    private native int nativeSetPanRelative(long var1, int var3);

    private native int nativeGetPanRelative(long var1);

    private native int[] nativeObtainTiltRelativeLimit(long var1);

    private native int nativeSetTiltRelative(long var1, int var3);

    private native int nativeGetTiltRelative(long var1);

    private native int[] nativeObtainRollAbsoluteLimit(long var1);

    private native int nativeSetRollAbsolute(long var1, int var3);

    private native int nativeGetRollAbsolute(long var1);

    private native int[] nativeObtainRollRelativeLimit(long var1);

    private native int nativeSetRollRelative(long var1, int var3);

    private native int nativeGetRollRelative(long var1);

    private native int[] nativeObtainFocusAutoLimit(long var1);

    private native int nativeSetFocusAuto(long var1, boolean var3);

    private native int nativeGetFocusAuto(long var1);

    private native int[] nativeObtainPrivacyLimit(long var1);

    private native int nativeSetPrivacy(long var1, boolean var3);

    private native int nativeGetPrivacy(long var1);

    private native int[] nativeObtainBrightnessLimit(long var1);

    private native int nativeSetBrightness(long var1, int var3);

    private native int nativeGetBrightness(long var1);

    private native int[] nativeObtainContrastLimit(long var1);

    private native int nativeSetContrast(long var1, int var3);

    private native int nativeGetContrast(long var1);

    private native int[] nativeObtainHueLimit(long var1);

    private native int nativeSetHue(long var1, int var3);

    private native int nativeGetHue(long var1);

    private native int[] nativeObtainSaturationLimit(long var1);

    private native int nativeSetSaturation(long var1, int var3);

    private native int nativeGetSaturation(long var1);

    private native int[] nativeObtainSharpnessLimit(long var1);

    private native int nativeSetSharpness(long var1, int var3);

    private native int nativeGetSharpness(long var1);

    private native int[] nativeObtainGammaLimit(long var1);

    private native int nativeSetGamma(long var1, int var3);

    private native int nativeGetGamma(long var1);

    private native int[] nativeObtainWhiteBalanceLimit(long var1);

    private native int nativeSetWhiteBalance(long var1, int var3);

    private native int nativeGetWhiteBalance(long var1);

    private native int[] nativeObtainWhiteBalanceCompoLimit(long var1);

    private native int nativeSetWhiteBalanceCompo(long var1, int var3);

    private native int nativeGetWhiteBalanceCompo(long var1);

    private native int[] nativeObtainBacklightCompLimit(long var1);

    private native int nativeSetBacklightComp(long var1, int var3);

    private native int nativeGetBacklightComp(long var1);

    private native int[] nativeObtainGainLimit(long var1);

    private native int nativeSetGain(long var1, int var3);

    private native int nativeGetGain(long var1);

    private native int[] nativeObtainPowerlineFrequencyLimit(long var1);

    private native int nativeSetPowerlineFrequency(long var1, int var3);

    private native int nativeGetPowerlineFrequency(long var1);

    private native int[] nativeObtainHueAutoLimit(long var1);

    private native int nativeSetHueAuto(long var1, boolean var3);

    private native int nativeGetHueAuto(long var1);

    private native int[] nativeObtainWhiteBalanceAutoLimit(long var1);

    private native int nativeSetWhiteBalanceAuto(long var1, boolean var3);

    private native int nativeGetWhiteBalanceAuto(long var1);

    private native int[] nativeObtainWhiteBalanceCompoAutoLimit(long var1);

    private native int nativeSetWhiteBalanceCompoAuto(long var1, boolean var3);

    private native int nativeGetWhiteBalanceCompoAuto(long var1);

    private native int[] nativeObtainDigitalMultiplierLimit(long var1);

    private native int nativeSetDigitalMultiplier(long var1, int var3);

    private native int nativeGetDigitalMultiplier(long var1);

    private native int[] nativeObtainDigitalMultiplierLimitLimit(long var1);

    private native int nativeSetDigitalMultiplierLimit(long var1, int var3);

    private native int nativeGetDigitalMultiplierLimit(long var1);

    private native int[] nativeObtainAnalogVideoStandardLimit(long var1);

    private native int nativeSetAnalogVideoStandard(long var1, int var3);

    private native int nativeGetAnalogVideoStandard(long var1);

    private native int[] nativeObtainAnalogVideoLockStateLimit(long var1);

    private native int nativeSetAnalogVideoLockState(long var1, int var3);

    private native int nativeGetAnalogVideoLockState(long var1);

    private native int[] nativeObtainContrastAutoLimit(long var1);

    private native int nativeSetContrastAuto(long var1, boolean var3);

    private native int nativeGetContrastAuto(long var1);

    static {
        System.loadLibrary("jpeg-turbo212");
        System.loadLibrary("usb1.0");
        System.loadLibrary("uvc");
        System.loadLibrary("UVCCamera");
    }
}

