/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.os.Looper;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.engine.Resource;

class EngineResource<Z>
implements Resource<Z> {
    private final Resource<Z> resource;
    private final boolean isCacheable;
    private ResourceListener listener;
    private Key key;
    private int acquired;
    private boolean isRecycled;

    EngineResource(Resource<Z> resource, boolean bl) {
        if (resource == null) {
            throw new NullPointerException("Wrapped resource must not be null");
        }
        this.resource = resource;
        this.isCacheable = bl;
    }

    void setResourceListener(Key key, ResourceListener resourceListener) {
        this.key = key;
        this.listener = resourceListener;
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    public Z get() {
        return this.resource.get();
    }

    @Override
    public int getSize() {
        return this.resource.getSize();
    }

    @Override
    public void recycle() {
        if (this.acquired > 0) {
            throw new IllegalStateException("Cannot recycle a resource while it is still acquired");
        }
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot recycle a resource that has already been recycled");
        }
        this.isRecycled = true;
        this.resource.recycle();
    }

    void acquire() {
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot acquire a recycled resource");
        }
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            throw new IllegalThreadStateException("Must call acquire on the main thread");
        }
        ++this.acquired;
    }

    void release() {
        if (this.acquired <= 0) {
            throw new IllegalStateException("Cannot release a recycled or not yet acquired resource");
        }
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            throw new IllegalThreadStateException("Must call release on the main thread");
        }
        if (--this.acquired == 0) {
            this.listener.onResourceReleased(this.key, this);
        }
    }

    static interface ResourceListener {
        public void onResourceReleased(Key var1, EngineResource<?> var2);
    }
}

