/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.text.TextUtils;
import com.hpplay.sdk.source.bean.SortJSONObject;
import com.hpplay.sdk.source.log.SourceLog;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    private static final String TAG = "JSONUtil";
    private static final int JSON_INDENT = 4;

    public static String formatJSON(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string = string.trim();
                if (string.startsWith("{")) {
                    JSONObject jSONObject = new JSONObject(string);
                    String string2 = jSONObject.toString(4);
                    return string2;
                }
                if (string.startsWith("[")) {
                    JSONArray jSONArray = new JSONArray(string);
                    String string3 = jSONArray.toString(4);
                    return string3;
                }
                return "Invalid json content";
            }
            catch (JSONException jSONException) {
                return "Invalid json content";
            }
        }
        return "Empty/Null json content";
    }

    public static JSONObject commonBean2Json(Object object) {
        JSONObject jSONObject = new JSONObject();
        try {
            for (Field field : object.getClass().getFields()) {
                field.setAccessible(true);
                boolean bl = Modifier.isStatic(field.getModifiers());
                boolean bl2 = Modifier.isPrivate(field.getModifiers());
                if (bl || bl2 || field.isEnumConstant() || field.isSynthetic()) continue;
                String string = field.getGenericType().toString();
                if ("int".equals(string) || "long".equals(string) || "double".equals(string) || "boolean".equals(string) || "class java.lang.String".equals(string) || "class java.lang.Object".equals(string)) {
                    jSONObject.put(field.getName(), field.get(object));
                    continue;
                }
                SourceLog.w(TAG, "can not recognized2 " + field.getName() + " in " + object);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public static JSONArray getSortJsonArray(JSONArray jSONArray, boolean bl) {
        JSONArray jSONArray2 = new JSONArray();
        if (jSONArray == null) {
            return jSONArray2;
        }
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = jSONArray.opt(i2);
            if (!(object instanceof JSONObject)) continue;
            if (bl) {
                jSONArray2.put((Object)JSONUtil.getLeboSortJson((JSONObject)object));
                continue;
            }
            jSONArray2.put((Object)JSONUtil.getSortJson((JSONObject)object));
        }
        return jSONArray2;
    }

    private static JSONObject getSortJson(JSONObject jSONObject) {
        String string;
        Iterator iterator = jSONObject.keys();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = jSONObject.optString(string);
            treeMap.put(string, string2);
        }
        try {
            string = new JSONObject();
            for (String string3 : treeMap.keySet()) {
                string.put(string3, treeMap.get(string3));
            }
            return string;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    private static JSONObject getLeboSortJson(JSONObject jSONObject) {
        Object object;
        Iterator iterator = jSONObject.keys();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = jSONObject.optString((String)object);
            treeMap.put(object, string);
        }
        try {
            object = new SortJSONObject();
            for (String string : treeMap.keySet()) {
                ((SortJSONObject)((Object)object)).put(string, treeMap.get(string));
            }
            return object;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }
}

