/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import com.hpplay.sdk.source.api.ICommonListener;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.transceiver.IRemoteServerListener;
import com.hpplay.sdk.source.transceiver.ISinkNotifyMirrorListener;
import com.hpplay.sdk.source.transceiver.bean.NotifyMirrorBean;
import org.json.JSONObject;

public class CommonListenerWrapper {
    private static final String TAG = "CommonListenerWrapper";
    private static CommonListenerWrapper sInstance;
    private ICommonListener mAPPCommonListener;
    private ISinkNotifyMirrorListener mSinkNotifyMirrorListener;
    private IRemoteServerListener mRemoteServerListener;

    private CommonListenerWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CommonListenerWrapper getInstance() {
        Class<CommonListenerWrapper> clazz = CommonListenerWrapper.class;
        synchronized (CommonListenerWrapper.class) {
            if (sInstance == null) {
                sInstance = new CommonListenerWrapper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setCommonListener(ICommonListener iCommonListener) {
        this.mAPPCommonListener = iCommonListener;
    }

    public ISinkNotifyMirrorListener getSinkNotifyMirrorListener() {
        return this.mSinkNotifyMirrorListener;
    }

    public IRemoteServerListener getRemoteServerListener() {
        return this.mRemoteServerListener;
    }

    public void registerListener(Object ... objectArray) {
        try {
            int n2 = Integer.parseInt(objectArray[0].toString());
            switch (n2) {
                case 1: {
                    this.mSinkNotifyMirrorListener = new ISinkNotifyMirrorListener(){

                        @Override
                        public void onNotifyMirror(NotifyMirrorBean notifyMirrorBean) {
                            if (CommonListenerWrapper.this.mAPPCommonListener != null) {
                                CommonListenerWrapper.this.mAPPCommonListener.onCallback(1, 1, notifyMirrorBean.toJSON());
                            }
                        }
                    };
                    break;
                }
                case 2: {
                    this.mRemoteServerListener = new IRemoteServerListener(){

                        @Override
                        public void onServerStarted(int n2) {
                            if (CommonListenerWrapper.this.mAPPCommonListener != null) {
                                try {
                                    JSONObject jSONObject = new JSONObject();
                                    jSONObject.put("port", n2);
                                    CommonListenerWrapper.this.mAPPCommonListener.onCallback(2, 1, jSONObject.toString());
                                }
                                catch (Exception exception) {
                                    SourceLog.w(CommonListenerWrapper.TAG, exception);
                                }
                            }
                        }

                        @Override
                        public void onServerFailed(int n2) {
                            if (CommonListenerWrapper.this.mAPPCommonListener != null) {
                                try {
                                    JSONObject jSONObject = new JSONObject();
                                    jSONObject.put("error", n2);
                                    CommonListenerWrapper.this.mAPPCommonListener.onCallback(2, 2, jSONObject.toString());
                                }
                                catch (Exception exception) {
                                    SourceLog.w(CommonListenerWrapper.TAG, exception);
                                }
                            }
                        }
                    };
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void unRegisterListener(Object ... objectArray) {
        try {
            int n2 = Integer.parseInt(objectArray[0].toString());
            switch (n2) {
                case 1: {
                    this.mSinkNotifyMirrorListener = null;
                    break;
                }
                case 2: {
                    this.mRemoteServerListener = null;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void release() {
        this.mAPPCommonListener = null;
    }
}

