/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSSEC;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base64;
import java.security.PublicKey;

abstract class KEYBase
extends Record {
    private static final long serialVersionUID = 3469321722693285454L;
    protected int flags;
    protected int proto;
    protected int alg;
    protected byte[] key;
    protected int footprint = -1;
    protected PublicKey publicKey = null;

    protected KEYBase() {
    }

    public KEYBase(Name name, int n2, int n3, long l2, int n4, int n5, int n6, byte[] byArray) {
        super(name, n2, n3, l2);
        this.flags = KEYBase.checkU16("flags", n4);
        this.proto = KEYBase.checkU8("proto", n5);
        this.alg = KEYBase.checkU8("alg", n6);
        this.key = byArray;
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.flags = dNSInput.readU16();
        this.proto = dNSInput.readU8();
        this.alg = dNSInput.readU8();
        if (dNSInput.remaining() > 0) {
            this.key = dNSInput.readByteArray();
        }
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.flags);
        stringBuffer.append(" ");
        stringBuffer.append(this.proto);
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        if (this.key != null) {
            if (Options.check("multiline")) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString(this.key, 64, "\t", true));
                stringBuffer.append(" ; key_tag = ");
                stringBuffer.append(this.getFootprint());
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(base64.toString(this.key));
            }
        }
        return stringBuffer.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProtocol() {
        return this.proto;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getFootprint() {
        if (this.footprint >= 0) {
            return this.footprint;
        }
        int n2 = 0;
        DNSOutput dNSOutput = new DNSOutput();
        this.rrToWire(dNSOutput, null, false);
        byte[] byArray = dNSOutput.toByteArray();
        if (this.alg == 1) {
            int n3 = byArray[byArray.length - 3] & 0xFF;
            int n4 = byArray[byArray.length - 2] & 0xFF;
            n2 = (n3 << 8) + n4;
        } else {
            int n5;
            int n6;
            for (n6 = 0; n6 < byArray.length - 1; n6 += 2) {
                n5 = byArray[n6] & 0xFF;
                int n7 = byArray[n6 + 1] & 0xFF;
                n2 += (n5 << 8) + n7;
            }
            if (n6 < byArray.length) {
                n5 = byArray[n6] & 0xFF;
                n2 += n5 << 8;
            }
            n2 += n2 >> 16 & 0xFFFF;
        }
        this.footprint = n2 & 0xFFFF;
        return this.footprint;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = DNSSEC.toPublicKey(this);
        return this.publicKey;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.flags);
        dNSOutput.writeU8(this.proto);
        dNSOutput.writeU8(this.alg);
        if (this.key != null) {
            dNSOutput.writeByteArray(this.key);
        }
    }
}

