/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi.transceiver;

import android.util.Log;
import com.tony.bluetoothunityapi.BLEBluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import java.util.Arrays;

public class CharacteristicTransceiver
implements ITransceiver {
    private final BLEBluetoothHelper helper;
    private ITransceiver.OnTransceiverMessageReceived listener;
    private boolean listening;

    public CharacteristicTransceiver(BLEBluetoothHelper helper) {
        this.helper = helper;
        this.listening = false;
    }

    @Override
    public void write(byte b) {
        byte[] buff = new byte[]{b};
        this.write(buff);
    }

    @Override
    public void write(byte[] b) {
        if (this.helper.getTxCharacteristic() == null) {
            Log.e((String)"test", (String)"Default characteristic null");
            throw new BluetoothHelper.BluetoothTransmissionCharacteristicNotSetException();
        }
        int count = b.length / 20;
        int offset = 0;
        while (count > 0) {
            byte[] temp = Arrays.copyOfRange(b, offset, offset + 20);
            offset += 20;
            --count;
            this.helper.getTxCharacteristic().setValue(temp);
            this.helper.getGatt().writeCharacteristic(this.helper.getTxCharacteristic());
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
        if (b.length % 20 != 0) {
            int rem = b.length % 20;
            byte[] temp = Arrays.copyOfRange(b, offset, rem);
            this.helper.getTxCharacteristic().setValue(temp);
            this.helper.getGatt().writeCharacteristic(this.helper.getTxCharacteristic());
        }
    }

    @Override
    public void listen() {
        this.listening = true;
    }

    @Override
    public void stop(boolean s) {
    }

    @Override
    public void setOnMessageReceived(ITransceiver.OnTransceiverMessageReceived listener) {
        this.listener = listener;
    }

    public void InvokeMessageReceived(byte[] x) {
        if (!this.listening || this.listener == null) {
            return;
        }
        this.listener.OnMessageReceived(x);
    }
}

