/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartbowlib;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.example.smartbowlib.UnityMsgSender;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class GPSTool {
    private static final String TAG = "GPSTool";
    private static LocationManager locationManager;
    private static boolean locationListening;
    private static LocationListener locationListener;

    private static LocationManager getLocationManager(Context context) {
        if (locationManager != null) {
            return locationManager;
        }
        if (context != null) {
            locationManager = (LocationManager)context.getSystemService("location");
        }
        return locationManager;
    }

    public static boolean hasOpenGPS(Activity context) {
        return GPSTool.getLocationManager((Context)context).isProviderEnabled("gps");
    }

    public static void goToOpenGPS(Activity context) {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        context.startActivityForResult(intent, 1001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=23)
    public static String[] getAddress(Activity context) {
        Log.d((String)TAG, (String)"getProvince");
        if (context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return null;
        }
        if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            return null;
        }
        LocationManager locationManager = GPSTool.getLocationManager((Context)context);
        Location location = locationManager.getLastKnownLocation("passive");
        if (location == null) {
            Class<GPSTool> clazz = GPSTool.class;
            synchronized (GPSTool.class) {
                if (!locationListening) {
                    locationListening = true;
                    locationManager.requestLocationUpdates("gps", 0L, 0.0f, locationListener);
                    locationManager.requestLocationUpdates("network", 0L, 0.0f, locationListener);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Log.w((String)TAG, (String)"\u83b7\u53d6\u4f4d\u7f6e\u4fe1\u606f\u5931\u8d25");
                return null;
            }
        }
        Log.d((String)TAG, (String)"\u83b7\u53d6\u4f4d\u7f6e\u4fe1\u606f\u6210\u529f");
        double latitude = location.getLatitude();
        Log.d((String)TAG, (String)("\u7eac\u5ea6\uff1a" + latitude));
        double longitude = location.getLongitude();
        Log.d((String)TAG, (String)("\u7ecf\u5ea6\uff1a" + longitude));
        String[] address = null;
        List addList = null;
        Geocoder ge = new Geocoder((Context)context, Locale.getDefault());
        try {
            addList = ge.getFromLocation(latitude, longitude, 1);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("getFromLocation-ERROR\n" + e.getMessage()));
        }
        if (addList != null && addList.size() > 0) {
            for (int i = 0; i < addList.size(); ++i) {
                Address ad = (Address)addList.get(i);
                address = new String[]{ad.getCountryName(), ad.getAdminArea(), ad.getLocality()};
            }
        }
        return address;
    }

    static {
        locationListening = false;
        locationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                Log.d((String)GPSTool.TAG, (String)"onLocationChanged");
                GPSTool.getLocationManager(null).removeUpdates((LocationListener)this);
                locationListening = false;
                UnityMsgSender.onLocationUpdate();
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
                Log.d((String)GPSTool.TAG, (String)("onStatusChanged: " + provider + " status: " + status + " extras: " + extras));
            }

            public void onProviderEnabled(String provider) {
                Log.d((String)GPSTool.TAG, (String)("onProviderEnabled: " + provider));
            }

            public void onProviderDisabled(String provider) {
                Log.d((String)GPSTool.TAG, (String)("onProviderDisabled: " + provider));
            }
        };
    }
}

