/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.opengl.utils;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.opengl.EGLBase;
import com.serenegiant.opengl.GLDrawer2D;

public final class RenderHandler
extends Handler {
    private static final String TAG = "RenderHandler";
    private static final int MSG_RENDER_SET_GLCONTEXT = 1;
    private static final int MSG_RENDER_DRAW = 2;
    private static final int MSG_CHECK_VALID = 3;
    private static final int MSG_RENDER_QUIT = 9;
    private int mTexId = -1;
    private final RenderThread mThread;

    public static RenderHandler createHandler() {
        return RenderHandler.createHandler("RenderThread");
    }

    public static final RenderHandler createHandler(String name) {
        RenderThread thread = new RenderThread(name);
        thread.start();
        return thread.getHandler();
    }

    public final void setEglContext(EGLBase.IContext sharedContext, int tex_id, Object surface, boolean isRecordable) {
        if (!(surface instanceof Surface || surface instanceof SurfaceTexture || surface instanceof SurfaceHolder)) {
            throw new RuntimeException("unsupported window type:" + surface);
        }
        this.mTexId = tex_id;
        this.sendMessage(this.obtainMessage(1, isRecordable ? 1 : 0, 0, new ContextParams(sharedContext, surface)));
    }

    public final void draw() {
        this.sendMessage(this.obtainMessage(2, this.mTexId, 0, null));
    }

    public final void draw(int tex_id) {
        this.sendMessage(this.obtainMessage(2, tex_id, 0, null));
    }

    public final void draw(float[] tex_matrix) {
        this.sendMessage(this.obtainMessage(2, this.mTexId, 0, tex_matrix));
    }

    public final void draw(int tex_id, float[] tex_matrix) {
        this.sendMessage(this.obtainMessage(2, tex_id, 0, tex_matrix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mThread.mSync;
        synchronized (object) {
            this.sendEmptyMessage(3);
            try {
                this.mThread.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mThread.mSurface != null && this.mThread.mSurface.isValid();
        }
    }

    public final void release() {
        this.removeMessages(1);
        this.removeMessages(2);
        this.sendEmptyMessage(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                ContextParams params = (ContextParams)msg.obj;
                this.mThread.handleSetEglContext(params.sharedContext, params.surface, msg.arg1 != 0);
                break;
            }
            case 2: {
                this.mThread.handleDraw(msg.arg1, (float[])msg.obj);
                break;
            }
            case 3: {
                Object object = this.mThread.mSync;
                synchronized (object) {
                    this.mThread.mSync.notify();
                    break;
                }
            }
            case 9: {
                Looper.myLooper().quit();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private RenderHandler(RenderThread thread) {
        this.mThread = thread;
    }

    private static final class RenderThread
    extends Thread {
        private static final String TAG_THREAD = "RenderThread";
        private final Object mSync = new Object();
        private RenderHandler mHandler;
        private EGLBase mEgl;
        private EGLBase.IEglSurface mTargetSurface;
        private Surface mSurface;
        private GLDrawer2D mDrawer;

        public RenderThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final RenderHandler getHandler() {
            Object object = this.mSync;
            synchronized (object) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.mHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void handleSetEglContext(EGLBase.IContext shardContext, Object surface, boolean isRecordable) {
            block6: {
                this.release();
                Object object = this.mSync;
                synchronized (object) {
                    this.mSurface = surface instanceof Surface ? (Surface)surface : (surface instanceof SurfaceTexture ? new Surface((SurfaceTexture)surface) : null);
                }
                this.mEgl = EGLBase.createFrom(shardContext, 3, false, 0, isRecordable);
                try {
                    this.mTargetSurface = this.mEgl.createFromSurface(surface);
                    this.mDrawer = new GLDrawer2D(isRecordable);
                }
                catch (Exception e) {
                    Log.w((String)RenderHandler.TAG, (Throwable)e);
                    if (this.mTargetSurface != null) {
                        this.mTargetSurface.release();
                        this.mTargetSurface = null;
                    }
                    if (this.mDrawer == null) break block6;
                    this.mDrawer.release();
                    this.mDrawer = null;
                }
            }
        }

        public void handleDraw(int tex_id, float[] tex_matrix) {
            if (tex_id >= 0 && this.mTargetSurface != null) {
                this.mTargetSurface.makeCurrent();
                this.mDrawer.draw(tex_id, tex_matrix, 0);
                this.mTargetSurface.swap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Looper.prepare();
            Object object = this.mSync;
            synchronized (object) {
                this.mHandler = new RenderHandler(this);
                this.mSync.notify();
            }
            Looper.loop();
            this.release();
            object = this.mSync;
            synchronized (object) {
                this.mHandler = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void release() {
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            Object object = this.mSync;
            synchronized (object) {
                this.mSurface = null;
            }
            if (this.mTargetSurface != null) {
                this.clear();
                this.mTargetSurface.release();
                this.mTargetSurface = null;
            }
            if (this.mEgl != null) {
                this.mEgl.release();
                this.mEgl = null;
            }
        }

        private final void clear() {
            this.mTargetSurface.makeCurrent();
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16384);
            this.mTargetSurface.swap();
        }
    }

    private static final class ContextParams {
        final EGLBase.IContext sharedContext;
        final Object surface;

        public ContextParams(EGLBase.IContext sharedContext, Object surface) {
            this.sharedContext = sharedContext;
            this.surface = surface;
        }
    }
}

