/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.hpplay.glide.GlideBuilder;
import com.hpplay.glide.MemoryCategory;
import com.hpplay.glide.RequestManager;
import com.hpplay.glide.load.DecodeFormat;
import com.hpplay.glide.load.engine.Engine;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.engine.cache.MemoryCache;
import com.hpplay.glide.load.engine.prefill.BitmapPreFiller;
import com.hpplay.glide.load.engine.prefill.PreFillType;
import com.hpplay.glide.load.model.GenericLoaderFactory;
import com.hpplay.glide.load.model.GlideUrl;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.model.ModelLoaderFactory;
import com.hpplay.glide.load.model.file_descriptor.FileDescriptorFileLoader;
import com.hpplay.glide.load.model.file_descriptor.FileDescriptorResourceLoader;
import com.hpplay.glide.load.model.file_descriptor.FileDescriptorStringLoader;
import com.hpplay.glide.load.model.file_descriptor.FileDescriptorUriLoader;
import com.hpplay.glide.load.model.stream.HttpUrlGlideUrlLoader;
import com.hpplay.glide.load.model.stream.StreamByteArrayLoader;
import com.hpplay.glide.load.model.stream.StreamFileLoader;
import com.hpplay.glide.load.model.stream.StreamResourceLoader;
import com.hpplay.glide.load.model.stream.StreamStringLoader;
import com.hpplay.glide.load.model.stream.StreamUriLoader;
import com.hpplay.glide.load.model.stream.StreamUrlLoader;
import com.hpplay.glide.load.resource.bitmap.CenterCrop;
import com.hpplay.glide.load.resource.bitmap.FileDescriptorBitmapDataLoadProvider;
import com.hpplay.glide.load.resource.bitmap.FitCenter;
import com.hpplay.glide.load.resource.bitmap.GlideBitmapDrawable;
import com.hpplay.glide.load.resource.bitmap.ImageVideoDataLoadProvider;
import com.hpplay.glide.load.resource.bitmap.StreamBitmapDataLoadProvider;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;
import com.hpplay.glide.load.resource.file.StreamFileDataLoadProvider;
import com.hpplay.glide.load.resource.gif.GifDrawable;
import com.hpplay.glide.load.resource.gif.GifDrawableLoadProvider;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapperTransformation;
import com.hpplay.glide.load.resource.gifbitmap.ImageVideoGifDrawableLoadProvider;
import com.hpplay.glide.load.resource.transcode.GifBitmapWrapperDrawableTranscoder;
import com.hpplay.glide.load.resource.transcode.GlideBitmapDrawableTranscoder;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.load.resource.transcode.TranscoderRegistry;
import com.hpplay.glide.manager.RequestManagerRetriever;
import com.hpplay.glide.module.GlideModule;
import com.hpplay.glide.module.ManifestParser;
import com.hpplay.glide.provider.DataLoadProvider;
import com.hpplay.glide.provider.DataLoadProviderRegistry;
import com.hpplay.glide.request.FutureTarget;
import com.hpplay.glide.request.Request;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.target.ImageViewTargetFactory;
import com.hpplay.glide.request.target.Target;
import com.hpplay.glide.request.target.ViewTarget;
import com.hpplay.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class Glide {
    private static final String TAG = "Glide";
    private static volatile Glide glide;
    private final GenericLoaderFactory loaderFactory;
    private final Engine engine;
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final DecodeFormat decodeFormat;
    private final ImageViewTargetFactory imageViewTargetFactory = new ImageViewTargetFactory();
    private final TranscoderRegistry transcoderRegistry = new TranscoderRegistry();
    private final DataLoadProviderRegistry dataLoadProviderRegistry;
    private final CenterCrop bitmapCenterCrop;
    private final GifBitmapWrapperTransformation drawableCenterCrop;
    private final FitCenter bitmapFitCenter;
    private final GifBitmapWrapperTransformation drawableFitCenter;
    private final Handler mainHandler;
    private final BitmapPreFiller bitmapPreFiller;

    public static File getPhotoCacheDir(Context context) {
        return Glide.getPhotoCacheDir(context, "image_manager_disk_cache");
    }

    public static File getPhotoCacheDir(Context context, String string) {
        File file = context.getCacheDir();
        if (file != null) {
            File file2 = new File(file, string);
            if (!(file2.mkdirs() || file2.exists() && file2.isDirectory())) {
                return null;
            }
            return file2;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Glide get(Context context) {
        if (glide != null) return glide;
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            if (glide != null) return glide;
            Context context2 = context.getApplicationContext();
            List<GlideModule> list = new ManifestParser(context2).parse();
            GlideBuilder glideBuilder = new GlideBuilder(context2);
            for (GlideModule glideModule : list) {
                glideModule.applyOptions(context2, glideBuilder);
            }
            glide = glideBuilder.createGlide();
            for (GlideModule glideModule : list) {
                glideModule.registerComponents(context2, glide);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return glide;
        }
    }

    @Deprecated
    public static boolean isSetup() {
        return glide != null;
    }

    @Deprecated
    public static void setup(GlideBuilder glideBuilder) {
        if (Glide.isSetup()) {
            throw new IllegalArgumentException("Glide is already setup, check with isSetup() first");
        }
        glide = glideBuilder.createGlide();
    }

    static void tearDown() {
        glide = null;
    }

    Glide(Engine engine, MemoryCache memoryCache, BitmapPool bitmapPool, Context context, DecodeFormat decodeFormat) {
        this.engine = engine;
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.decodeFormat = decodeFormat;
        this.loaderFactory = new GenericLoaderFactory(context);
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.bitmapPreFiller = new BitmapPreFiller(memoryCache, bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry = new DataLoadProviderRegistry();
        StreamBitmapDataLoadProvider streamBitmapDataLoadProvider = new StreamBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(InputStream.class, Bitmap.class, streamBitmapDataLoadProvider);
        FileDescriptorBitmapDataLoadProvider fileDescriptorBitmapDataLoadProvider = new FileDescriptorBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(ParcelFileDescriptor.class, Bitmap.class, fileDescriptorBitmapDataLoadProvider);
        ImageVideoDataLoadProvider imageVideoDataLoadProvider = new ImageVideoDataLoadProvider(streamBitmapDataLoadProvider, fileDescriptorBitmapDataLoadProvider);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, Bitmap.class, imageVideoDataLoadProvider);
        GifDrawableLoadProvider gifDrawableLoadProvider = new GifDrawableLoadProvider(context, bitmapPool);
        this.dataLoadProviderRegistry.register(InputStream.class, GifDrawable.class, gifDrawableLoadProvider);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, GifBitmapWrapper.class, new ImageVideoGifDrawableLoadProvider(imageVideoDataLoadProvider, gifDrawableLoadProvider, bitmapPool));
        this.dataLoadProviderRegistry.register(InputStream.class, File.class, new StreamFileDataLoadProvider());
        this.register(File.class, ParcelFileDescriptor.class, new FileDescriptorFileLoader.Factory());
        this.register(File.class, InputStream.class, new StreamFileLoader.Factory());
        this.register(Integer.TYPE, ParcelFileDescriptor.class, new FileDescriptorResourceLoader.Factory());
        this.register(Integer.TYPE, InputStream.class, new StreamResourceLoader.Factory());
        this.register(Integer.class, ParcelFileDescriptor.class, new FileDescriptorResourceLoader.Factory());
        this.register(Integer.class, InputStream.class, new StreamResourceLoader.Factory());
        this.register(String.class, ParcelFileDescriptor.class, new FileDescriptorStringLoader.Factory());
        this.register(String.class, InputStream.class, new StreamStringLoader.Factory());
        this.register(Uri.class, ParcelFileDescriptor.class, new FileDescriptorUriLoader.Factory());
        this.register(Uri.class, InputStream.class, new StreamUriLoader.Factory());
        this.register(URL.class, InputStream.class, new StreamUrlLoader.Factory());
        this.register(GlideUrl.class, InputStream.class, new HttpUrlGlideUrlLoader.Factory());
        this.register(byte[].class, InputStream.class, new StreamByteArrayLoader.Factory());
        this.transcoderRegistry.register(Bitmap.class, GlideBitmapDrawable.class, new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool));
        this.transcoderRegistry.register(GifBitmapWrapper.class, GlideDrawable.class, new GifBitmapWrapperDrawableTranscoder(new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool)));
        this.bitmapCenterCrop = new CenterCrop(bitmapPool);
        this.drawableCenterCrop = new GifBitmapWrapperTransformation(bitmapPool, this.bitmapCenterCrop);
        this.bitmapFitCenter = new FitCenter(bitmapPool);
        this.drawableFitCenter = new GifBitmapWrapperTransformation(bitmapPool, this.bitmapFitCenter);
    }

    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    <Z, R> ResourceTranscoder<Z, R> buildTranscoder(Class<Z> clazz, Class<R> clazz2) {
        return this.transcoderRegistry.get(clazz, clazz2);
    }

    <T, Z> DataLoadProvider<T, Z> buildDataProvider(Class<T> clazz, Class<Z> clazz2) {
        return this.dataLoadProviderRegistry.get(clazz, clazz2);
    }

    <R> Target<R> buildImageViewTarget(ImageView imageView, Class<R> clazz) {
        return this.imageViewTargetFactory.buildTarget(imageView, clazz);
    }

    Engine getEngine() {
        return this.engine;
    }

    CenterCrop getBitmapCenterCrop() {
        return this.bitmapCenterCrop;
    }

    FitCenter getBitmapFitCenter() {
        return this.bitmapFitCenter;
    }

    GifBitmapWrapperTransformation getDrawableCenterCrop() {
        return this.drawableCenterCrop;
    }

    GifBitmapWrapperTransformation getDrawableFitCenter() {
        return this.drawableFitCenter;
    }

    Handler getMainHandler() {
        return this.mainHandler;
    }

    DecodeFormat getDecodeFormat() {
        return this.decodeFormat;
    }

    private GenericLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    public void preFillBitmapPool(PreFillType.Builder ... builderArray) {
        this.bitmapPreFiller.preFill(builderArray);
    }

    public void clearMemory() {
        Util.assertMainThread();
        this.memoryCache.clearMemory();
        this.bitmapPool.clearMemory();
    }

    public void trimMemory(int n2) {
        Util.assertMainThread();
        this.memoryCache.trimMemory(n2);
        this.bitmapPool.trimMemory(n2);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.getEngine().clearDiskCache();
    }

    public void setMemoryCategory(MemoryCategory memoryCategory) {
        Util.assertMainThread();
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(memoryCategory.getMultiplier());
    }

    public static void clear(Target<?> target) {
        Util.assertMainThread();
        Request request = target.getRequest();
        if (request != null) {
            request.clear();
            target.setRequest(null);
        }
    }

    public static void clear(FutureTarget<?> futureTarget) {
        futureTarget.clear();
    }

    public static void clear(View view) {
        ClearTarget clearTarget = new ClearTarget(view);
        Glide.clear(clearTarget);
    }

    public <T, Y> void register(Class<T> clazz, Class<Y> clazz2, ModelLoaderFactory<T, Y> modelLoaderFactory) {
        ModelLoaderFactory<T, Y> modelLoaderFactory2 = this.loaderFactory.register(clazz, clazz2, modelLoaderFactory);
        if (modelLoaderFactory2 != null) {
            modelLoaderFactory2.teardown();
        }
    }

    @Deprecated
    public <T, Y> void unregister(Class<T> clazz, Class<Y> clazz2) {
        ModelLoaderFactory<T, Y> modelLoaderFactory = this.loaderFactory.unregister(clazz, clazz2);
        if (modelLoaderFactory != null) {
            modelLoaderFactory.teardown();
        }
    }

    public static <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> clazz, Class<Y> clazz2, Context context) {
        if (clazz == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Unable to load null model, setting placeholder only");
            }
            return null;
        }
        return Glide.get(context).getLoaderFactory().buildModelLoader(clazz, clazz2);
    }

    public static <T, Y> ModelLoader<T, Y> buildModelLoader(T t2, Class<Y> clazz, Context context) {
        return Glide.buildModelLoader(t2 != null ? t2.getClass() : null, clazz, context);
    }

    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(Class<T> clazz, Context context) {
        return Glide.buildModelLoader(clazz, InputStream.class, context);
    }

    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(T t2, Context context) {
        return Glide.buildModelLoader(t2, InputStream.class, context);
    }

    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(Class<T> clazz, Context context) {
        return Glide.buildModelLoader(clazz, ParcelFileDescriptor.class, context);
    }

    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(T t2, Context context) {
        return Glide.buildModelLoader(t2, ParcelFileDescriptor.class, context);
    }

    public static RequestManager with(Context context) {
        RequestManagerRetriever requestManagerRetriever = RequestManagerRetriever.get();
        return requestManagerRetriever.get(context);
    }

    public static RequestManager with(Activity activity) {
        RequestManagerRetriever requestManagerRetriever = RequestManagerRetriever.get();
        return requestManagerRetriever.get(activity);
    }

    @TargetApi(value=11)
    public static RequestManager with(Fragment fragment) {
        RequestManagerRetriever requestManagerRetriever = RequestManagerRetriever.get();
        return requestManagerRetriever.get(fragment);
    }

    private static class ClearTarget
    extends ViewTarget<View, Object> {
        public ClearTarget(View view) {
            super(view);
        }

        @Override
        public void onLoadStarted(Drawable drawable) {
        }

        @Override
        public void onLoadFailed(Exception exception, Drawable drawable) {
        }

        @Override
        public void onResourceReady(Object object, GlideAnimation<? super Object> glideAnimation) {
        }

        @Override
        public void onLoadCleared(Drawable drawable) {
        }
    }
}

