/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.asyncmanager;

import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.component.asyncmanager.AsyncCallableJob;
import com.hpplay.component.asyncmanager.AsyncCallableListener;
import com.hpplay.component.asyncmanager.AsyncHttpJob;
import com.hpplay.component.asyncmanager.AsyncHttpParameter;
import com.hpplay.component.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.component.asyncmanager.AsyncRunnableJob;
import com.hpplay.component.asyncmanager.AsyncRunnableListener;
import com.hpplay.component.common.utils.CLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AsyncManager {
    private static final String TAG = "AsyncManager";
    private static AsyncManager instance = new AsyncManager();
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILED = 1;
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_NULL_URL = 3;
    public static final int RESULT_INVALID_TYPE = 4;
    public static final int RESULT_FILE_DOWNLOADING = 5;
    public static final int RESULT_FILE_DOWNLOAD_CANCEL = 6;
    public static final int RESULT_FILE_DOWNLOAD_ERROR = 7;
    public static final int RESULT_FILE_DOWNLOAD_SUCCESS = 8;
    public static final int RESULT_UPLOAD_STATUS_SUCCESS = 1;
    public static final int RESULT_UPLOAD_STATUS_BUSY = 2;
    public static final int RESULT_UPLOAD_STATUS_FAILED = 3;
    private final int MAX_SEMAPHORE = 10;
    private volatile int mSemaphore = 10;
    private volatile List<AsyncTask> mSemaphoreTaskList = new ArrayList<AsyncTask>();
    private volatile List<AsyncTask> mTaskList = new ArrayList<AsyncTask>();
    private boolean isDebug = false;
    private Executor executor = Executors.newCachedThreadPool();

    private AsyncManager() {
    }

    public static synchronized AsyncManager getInstance() {
        return instance;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    private void printTaskDetail() {
        if (this.isDebug) {
            CLog.i(TAG, "printTaskDetail running list zie :" + this.mTaskList.size() + "  waiting task size:" + this.mSemaphoreTaskList.size() + " Semaphore: " + this.mSemaphore);
        }
    }

    private void exeTask(AsyncTask asyncTask, boolean bl) {
        if (bl) {
            try {
                asyncTask.executeOnExecutor(this.executor, new Object[0]);
                this.mTaskList.add(asyncTask);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        } else if (this.mSemaphore > 0) {
            try {
                asyncTask.executeOnExecutor(this.executor, new Object[0]);
                this.mTaskList.add(asyncTask);
                --this.mSemaphore;
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        } else {
            CLog.w(TAG, "exeRunnable parallel too many,wait amount. mSemaphore: " + this.mSemaphore);
            this.mSemaphoreTaskList.add(asyncTask);
        }
        this.printTaskDetail();
    }

    private void releaseTask(AsyncTask asyncTask) {
        try {
            if (this.mTaskList.contains(asyncTask)) {
                this.mTaskList.remove(asyncTask);
                ++this.mSemaphore;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            ++this.mSemaphore;
        }
        this.printTaskDetail();
        if (this.mSemaphore > 0 && this.mSemaphoreTaskList.size() > 0) {
            AsyncTask asyncTask2 = this.mSemaphoreTaskList.remove(0);
            this.exeTask(asyncTask2, false);
        }
    }

    public AsyncRunnableJob exeRunnable(Runnable runnable, AsyncRunnableListener asyncRunnableListener) {
        return this.exeRunnable(runnable, asyncRunnableListener, false);
    }

    public AsyncRunnableJob exeRunnableWithoutParallel(Runnable runnable, AsyncRunnableListener asyncRunnableListener) {
        return this.exeRunnable(runnable, asyncRunnableListener, true);
    }

    private AsyncRunnableJob exeRunnable(Runnable runnable, AsyncRunnableListener asyncRunnableListener, boolean bl) {
        AsyncRunnableJob asyncRunnableJob = new AsyncRunnableJob(runnable, asyncRunnableListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncRunnableJob, bl);
        return asyncRunnableJob;
    }

    public AsyncCallableJob exeCallable(Callable callable, AsyncCallableListener asyncCallableListener) {
        return this.exeCallable(callable, asyncCallableListener, false);
    }

    public AsyncCallableJob exeCallableWithoutParallel(Callable callable, AsyncCallableListener asyncCallableListener) {
        return this.exeCallable(callable, asyncCallableListener, true);
    }

    private AsyncCallableJob exeCallable(Callable callable, AsyncCallableListener asyncCallableListener, boolean bl) {
        AsyncCallableJob asyncCallableJob = new AsyncCallableJob(callable, asyncCallableListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncCallableJob, bl);
        return asyncCallableJob;
    }

    public AsyncHttpJob exeHttpTask(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        return this.exeHttpTask(asyncHttpParameter, asyncHttpRequestListener, false);
    }

    public AsyncHttpJob exeHttpTaskWithoutParallel(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        return this.exeHttpTask(asyncHttpParameter, asyncHttpRequestListener, true);
    }

    private AsyncHttpJob exeHttpTask(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        if (asyncHttpParameter == null) {
            return null;
        }
        CLog.i(TAG, "exeHttpTask  url=" + asyncHttpParameter.in.requestUrl);
        if (TextUtils.isEmpty((CharSequence)asyncHttpParameter.in.requestUrl)) {
            if (asyncHttpRequestListener != null) {
                asyncHttpParameter.out.resultType = 3;
                asyncHttpRequestListener.onRequestResult(asyncHttpParameter);
            }
            return null;
        }
        if (asyncHttpParameter.in.requestMethod == 1) {
            return this.doPostRequest(asyncHttpParameter, asyncHttpRequestListener, bl);
        }
        return this.doGetRequest(asyncHttpParameter, asyncHttpRequestListener, bl);
    }

    private AsyncHttpJob doGetRequest(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        AsyncHttpJob asyncHttpJob = new AsyncHttpJob(0, asyncHttpParameter, asyncHttpRequestListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncHttpJob, bl);
        return asyncHttpJob;
    }

    private AsyncHttpJob doPostRequest(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        CLog.i(TAG, "doPostRequest in " + asyncHttpParameter.in.params);
        AsyncHttpJob asyncHttpJob = new AsyncHttpJob(1, asyncHttpParameter, asyncHttpRequestListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncHttpJob, bl);
        return asyncHttpJob;
    }

    public int getTaskSize() {
        return this.mTaskList.size();
    }

    public int getCachedTaskSize() {
        return this.mSemaphoreTaskList.size();
    }

    public void cancelAllTask() {
        CLog.i(TAG, "cancelAllTask");
        for (AsyncTask asyncTask : this.mTaskList) {
            try {
                asyncTask.cancel(true);
            }
            catch (Exception exception) {
                CLog.w(TAG, "cancelAllTask waring in cancel asyncTask");
            }
        }
    }
}

