/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.player;

import android.content.Context;
import android.util.Log;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.player.CloudPlayer;
import com.hpplay.sdk.source.player.DLNAPlayer;
import com.hpplay.sdk.source.player.GroupPlayer;
import com.hpplay.sdk.source.player.ICastPlayer;
import com.hpplay.sdk.source.player.LelinkPlayer;
import com.hpplay.sdk.source.player.YimPlayer;
import com.hpplay.sdk.source.player.listener.OnCompletionListener;
import com.hpplay.sdk.source.player.listener.OnErrorListener;
import com.hpplay.sdk.source.player.listener.OnInfoListener;
import com.hpplay.sdk.source.player.listener.OnLoadingListener;
import com.hpplay.sdk.source.player.listener.OnPreparedListener;
import com.hpplay.sdk.source.player.listener.OnStateChangeListener;
import com.hpplay.sdk.source.player.listener.OnStopListener;
import com.hpplay.sdk.source.protocol.CaptureBridge;

public class CastPlayer
implements ICastPlayer {
    private static final String TAG = "CastPlayer";
    private Context mContext;
    private ICastPlayer mProtocolPlayer;
    private OutParameter mPlayInfo;

    public CastPlayer(Context context, OutParameter outParameter) {
        this.mContext = context;
        this.mPlayInfo = outParameter;
        this.initPlayer(outParameter);
    }

    private void initPlayer(OutParameter outParameter) {
        if (outParameter.currentBrowserInfo == null || outParameter.connectProtocol == -1) {
            SourceLog.w(TAG, "initPlayer ignore invalid service info");
            return;
        }
        Log.i((String)TAG, (String)("initPlayer: protocol: " + outParameter.protocol + " group:" + outParameter.isGroup + "  " + outParameter.connectProtocol));
        if (outParameter.isGroup && outParameter.connectProtocol != 1 && outParameter.connectProtocol != 5) {
            this.mProtocolPlayer = new GroupPlayer(this.mContext, outParameter);
            return;
        }
        CaptureBridge.getInstance().setICaptureDispatcher(null);
        switch (outParameter.protocol) {
            case 1: 
            case 5: {
                this.mProtocolPlayer = new LelinkPlayer(this.mContext, outParameter);
                break;
            }
            case 3: {
                this.mProtocolPlayer = new DLNAPlayer(this.mContext, outParameter);
                break;
            }
            case 4: {
                if (outParameter.castType == 1) {
                    this.mProtocolPlayer = new CloudPlayer(this.mContext, this.mPlayInfo);
                    break;
                }
                this.mProtocolPlayer = new YimPlayer(this.mContext, this.mPlayInfo);
                break;
            }
            default: {
                SourceLog.w(TAG, "initPlayer ignore invalid protocol");
            }
        }
    }

    @Override
    public void setDataSource(OutParameter outParameter) {
        this.mPlayInfo = outParameter;
        this.mProtocolPlayer.setDataSource(outParameter);
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        return this.mProtocolPlayer.switchExpansionScreen(bl);
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        this.mProtocolPlayer.setSecondMirrorView(secondMirrorView);
    }

    public void doChangeChannel(int n2) {
        if (this.mProtocolPlayer instanceof GroupPlayer) {
            ((GroupPlayer)this.mProtocolPlayer).doChangeChannel(n2);
        }
    }

    public void onWifiConnected() {
        if (this.mProtocolPlayer instanceof GroupPlayer) {
            ((GroupPlayer)this.mProtocolPlayer).onWifiConnected();
        }
    }

    public ICastPlayer getMediaPlayer() {
        return this.mProtocolPlayer;
    }

    @Override
    public boolean start(String string) {
        return this.mProtocolPlayer.start(string);
    }

    @Override
    public boolean pause(String string) {
        return this.mProtocolPlayer.pause(string);
    }

    @Override
    public boolean resume(String string) {
        return this.mProtocolPlayer.resume(string);
    }

    @Override
    public boolean playDrama(String string, String string2) {
        return this.mProtocolPlayer.playDrama(string, string2);
    }

    @Override
    public boolean playNextDrama(String string) {
        return this.mProtocolPlayer.playNextDrama(string);
    }

    @Override
    public boolean playPreDrama(String string) {
        return this.mProtocolPlayer.playPreDrama(string);
    }

    @Override
    public boolean appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        return this.mProtocolPlayer.appendPlayList(string, dramaInfoBeanArray, n2, n3, n4);
    }

    @Override
    public boolean clearPlayList(String string) {
        return this.mProtocolPlayer.clearPlayList(string);
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
        this.mProtocolPlayer.setWatermarkVisible(bl);
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
        this.mProtocolPlayer.setMirrorScreenSecret(bl);
    }

    @Override
    public void onAppPause() {
        this.mProtocolPlayer.onAppPause();
    }

    @Override
    public void onAppResume() {
        this.mProtocolPlayer.onAppResume();
    }

    @Override
    public boolean seekTo(String string, int n2) {
        return this.mProtocolPlayer.seekTo(string, n2);
    }

    @Override
    public void addVolume() {
        this.mProtocolPlayer.addVolume();
    }

    @Override
    public void subVolume() {
        this.mProtocolPlayer.subVolume();
    }

    @Override
    public void setVolume(int n2) {
        this.mProtocolPlayer.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        this.mProtocolPlayer.selectAudiotrack(n2);
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "cast player stop ");
        this.mProtocolPlayer.stop(string);
    }

    @Override
    public void setOnLoadingListener(OnLoadingListener onLoadingListener) {
        this.mProtocolPlayer.setOnLoadingListener(onLoadingListener);
    }

    @Override
    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mProtocolPlayer.setOnPreparedListener(onPreparedListener);
    }

    @Override
    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mProtocolPlayer.setOnStateChangeListener(onStateChangeListener);
    }

    @Override
    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mProtocolPlayer.setOnInfoListener(onInfoListener);
    }

    @Override
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mProtocolPlayer.setOnErrorListener(onErrorListener);
    }

    @Override
    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        this.mProtocolPlayer.setOnCompletionListener(onCompletionListener);
    }

    @Override
    public void setOnStopListener(OnStopListener onStopListener) {
        this.mProtocolPlayer.setOnStopListener(onStopListener);
    }

    @Override
    public void release(String string) {
        this.mProtocolPlayer.release(string);
    }
}

