/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CreateUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class DevicePinParser {
    private static final String TAG = "DevicePinParser";
    private static final int WHAT_CALLBACK_IM = 1;
    private static final int DELAY_CALLBACK_IM = 500;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (message.obj == null) break;
                    DevicePinParser.this.callbackIMFirst((LelinkServiceInfo)message.obj);
                }
            }
            return false;
        }
    });
    private IServiceInfoParseListener mServiceInfoParseListener;

    public void setParseResultListener(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mServiceInfoParseListener = iServiceInfoParseListener;
    }

    public void parse(String string, final int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "parse: deviceCode is empty");
            this.notifyParseResult(0, null);
            return;
        }
        String string2 = CreateUtil.createSessionId();
        SourceDataReport.getInstance().onPinCodeStart(string2);
        SourceLog.i(TAG, "parse: deviceCode: " + string);
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)string);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sREAL_TIME_SERVICE_INFO_QUERY_RUL, null);
        asyncHttpParameter.in.params = jSONArray.toString();
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                block9: {
                    if (asyncHttpParameter.out.resultType == 2) {
                        SourceLog.i(DevicePinParser.TAG, "onRequestResult: request cancel");
                        return;
                    }
                    if (DevicePinParser.this.mServiceInfoParseListener != null && !TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                        try {
                            JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                            int n22 = jSONObject.optInt("code");
                            if (n22 == 200) {
                                JSONArray jSONArray = jSONObject.optJSONArray("data");
                                if (jSONArray == null || jSONArray.length() <= 0) {
                                    DevicePinParser.this.notifyParseResult(5, null);
                                    return;
                                }
                                JSONObject jSONObject2 = jSONArray.optJSONObject(0);
                                String string = jSONObject2.optString("serviceBody");
                                JSONObject jSONObject3 = new JSONObject(string);
                                DevicePinParser.this.parseServiceInfo(jSONObject3.toString(), n2);
                                break block9;
                            }
                            if (n22 == 211) {
                                DevicePinParser.this.notifyParseResult(8, null);
                                break block9;
                            }
                            if (n22 == 221) {
                                DevicePinParser.this.notifyParseResult(7, null);
                                break block9;
                            }
                            DevicePinParser.this.notifyParseResult(5, null);
                        }
                        catch (Exception exception) {
                            SourceLog.w(DevicePinParser.TAG, exception);
                            DevicePinParser.this.notifyParseResult(5, null);
                        }
                    } else {
                        DevicePinParser.this.notifyParseResult(5, null);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public LelinkServiceInfo parseServiceInfo(String string, int n2) {
        if (this.mServiceInfoParseListener == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.createByServiceTxtInfo(jSONObject, n2);
            if (TextUtils.isEmpty((CharSequence)jSONObject.optString("ip"))) {
                lelinkServiceInfo.getBrowserInfos().get(4).getExtras().put("phone", "1");
                this.notifyParseResult(1, lelinkServiceInfo);
                SourceLog.i(TAG, "onParseResult name:" + lelinkServiceInfo.getName());
                return lelinkServiceInfo;
            }
            SourceLog.i(TAG, "parseServiceInfo ");
            this.delayCallbackIM(LelinkServiceInfoCreator.createByServiceTxtInfo(jSONObject, n2));
            this.requestLelinkTxtInfo(jSONObject.optString("ip"), jSONObject.optString("remote_port"), jSONObject.optString("pt"), lelinkServiceInfo);
            return lelinkServiceInfo;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    private void requestLelinkTxtInfo(String string, final String string2, final String string3, final LelinkServiceInfo lelinkServiceInfo) {
        String string4 = CloudAPI.getHttpServerUrl(string, string2);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string4, null);
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(5L);
        asyncHttpParameter.in.tryCount = 1;
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(DevicePinParser.TAG, "requestLelinkTxtInfo: cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    LelinkServiceInfo lelinkServiceInfo2;
                    String string = asyncHttpParameter.out.result;
                    BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
                    if (browserInfo == null) {
                        browserInfo = lelinkServiceInfo.getBrowserInfos().get(4);
                    }
                    if (null != (lelinkServiceInfo2 = LelinkServiceInfoCreator.getLelinkTxtInfo(browserInfo.getUid(), lelinkServiceInfo.getName(), browserInfo.getIp(), string2, TextUtils.isEmpty((CharSequence)string3) ? "tv" : string3, string, 9))) {
                        DevicePinParser.this.notifyParseResult(1, lelinkServiceInfo2);
                    } else {
                        if (Feature.isDisableIM()) {
                            SourceLog.i(DevicePinParser.TAG, "resolveLelinkTxtInfo: failed ");
                            DevicePinParser.this.notifyParseResult(5, null);
                            return;
                        }
                        DevicePinParser.this.notifyParseResult(1, lelinkServiceInfo);
                    }
                } else {
                    if (Feature.isDisableIM()) {
                        SourceLog.i(DevicePinParser.TAG, "requestLelinkTxtInfo: failed ");
                        DevicePinParser.this.notifyParseResult(5, null);
                        return;
                    }
                    try {
                        if (lelinkServiceInfo.getBrowserInfos().size() > 1 && lelinkServiceInfo.getBrowserInfos().containsKey(4)) {
                            lelinkServiceInfo.getBrowserInfos().remove(1);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.w(DevicePinParser.TAG, exception);
                    }
                    BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
                    if (browserInfo != null) {
                        browserInfo.setOnLine(true);
                    }
                    SourceLog.i(DevicePinParser.TAG, "requestLelinkTxtInfo: failed " + lelinkServiceInfo);
                }
            }
        });
    }

    private void notifyParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
        this.mHandler.removeMessages(1);
        if (this.mServiceInfoParseListener != null) {
            this.mServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo);
        }
    }

    private void delayCallbackIM(LelinkServiceInfo lelinkServiceInfo) {
        if (Feature.isDisableIM()) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, (Object)lelinkServiceInfo), 500L);
    }

    private void callbackIMFirst(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return;
        }
        SourceLog.w(TAG, "callbackIMFirst " + lelinkServiceInfo);
        try {
            if (lelinkServiceInfo.getBrowserInfos().size() > 1 && lelinkServiceInfo.getBrowserInfos().containsKey(4)) {
                lelinkServiceInfo.getBrowserInfos().remove(1);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (!CastUtil.isSupportIM(lelinkServiceInfo)) {
            return;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
        if (browserInfo != null) {
            browserInfo.setOnLine(true);
        }
        this.notifyParseResult(1, lelinkServiceInfo);
    }
}

