/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    public static InputStream obtain(InputStream inputStream, String string) {
        return ContentLengthInputStream.obtain(inputStream, ContentLengthInputStream.parseContentLength(string));
    }

    public static InputStream obtain(InputStream inputStream, long l2) {
        return new ContentLengthInputStream(inputStream, l2);
    }

    private static int parseContentLength(String string) {
        int n2;
        block3: {
            n2 = -1;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                    Log.d((String)TAG, (String)("failed to parse content length header: " + string), (Throwable)numberFormatException);
                }
            }
        }
        return n2;
    }

    ContentLengthInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.contentLength = l2;
    }

    @Override
    public synchronized int available() {
        return (int)Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
    }

    @Override
    public synchronized int read() {
        return this.checkReadSoFarOrThrow(super.read());
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) {
        return this.checkReadSoFarOrThrow(super.read(byArray, n2, n3));
    }

    private int checkReadSoFarOrThrow(int n2) {
        if (n2 >= 0) {
            this.readSoFar += n2;
        } else if (this.contentLength - (long)this.readSoFar > 0L) {
            throw new IOException("Failed to read all expected data, expected: " + this.contentLength + ", but read: " + this.readSoFar);
        }
        return n2;
    }
}

