/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.cache;

import com.hpplay.glide.load.engine.cache.DiskCache;
import com.hpplay.glide.load.engine.cache.DiskLruCacheWrapper;
import java.io.File;

public class DiskLruCacheFactory
implements DiskCache.Factory {
    private final int diskCacheSize;
    private final CacheDirectoryGetter cacheDirectoryGetter;

    public DiskLruCacheFactory(final String string, int n2) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string);
            }
        }, n2);
    }

    public DiskLruCacheFactory(final String string, final String string2, int n2) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string, string2);
            }
        }, n2);
    }

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, int n2) {
        this.diskCacheSize = n2;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    @Override
    public DiskCache build() {
        File file = this.cacheDirectoryGetter.getCacheDirectory();
        if (file == null) {
            return null;
        }
        if (!(file.mkdirs() || file.exists() && file.isDirectory())) {
            return null;
        }
        return DiskLruCacheWrapper.get(file, this.diskCacheSize);
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

