/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.encrypt;

public class Curve25519 {
    public static final int KEY_SIZE = 32;
    public static final byte[] ZERO = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] PRIME = new byte[]{-19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 127};
    public static final byte[] ORDER = new byte[]{-19, -45, -11, 92, 26, 99, 18, 88, -42, -100, -9, -94, -34, -7, -34, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16};
    private static final int P25 = 0x1FFFFFF;
    private static final int P26 = 0x3FFFFFF;
    private static final byte[] ORDER_TIMES_8 = new byte[]{104, -97, -82, -25, -46, 24, -109, -64, -78, -26, -68, 23, -11, -50, -9, -90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128};
    private static final long10 BASE_2Y = new long10(39999547L, 18689728L, 59995525L, 1648697L, 57546132L, 24010086L, 19059592L, 5425144L, 63499247L, 16420658L);
    private static final long10 BASE_R2Y = new long10(5744L, 8160848L, 4790893L, 13779497L, 35730846L, 12541209L, 49101323L, 30047407L, 40071253L, 6226132L);

    public static final void clamp(byte[] byArray) {
        byArray[31] = (byte)(byArray[31] & 0x7F);
        byArray[31] = (byte)(byArray[31] | 0x40);
        byArray[0] = (byte)(byArray[0] & 0xF8);
    }

    public static final void keygen(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Curve25519.clamp(byArray3);
        Curve25519.core(byArray, byArray2, byArray3, null);
    }

    public static final void curve(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Curve25519.core(byArray, null, byArray2, byArray3);
    }

    public static final boolean sign(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[32];
        byte[] byArray7 = new byte[64];
        byte[] byArray8 = new byte[64];
        Curve25519.cpy32(byArray5, byArray2);
        Curve25519.cpy32(byArray6, byArray3);
        byte[] byArray9 = new byte[32];
        Curve25519.divmod(byArray9, byArray5, 32, ORDER, 32);
        Curve25519.divmod(byArray9, byArray6, 32, ORDER, 32);
        Curve25519.mula_small(byArray, byArray6, 0, byArray5, 32, -1);
        Curve25519.mula_small(byArray, byArray, 0, ORDER, 32, 1);
        Curve25519.mula32(byArray7, byArray, byArray4, 32, 1);
        Curve25519.divmod(byArray8, byArray7, 64, ORDER, 32);
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            byArray[i2] = byArray7[i2];
            n2 |= byArray[i2];
        }
        return n2 != 0;
    }

    public static final void verify(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2;
        int n3;
        byte[] byArray5 = new byte[32];
        long10[] long10Array = new long10[]{new long10(), new long10()};
        long10[] long10Array2 = new long10[]{new long10(), new long10()};
        long10[] long10Array3 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array4 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array5 = new long10[]{new long10(), new long10(), new long10()};
        long10[] long10Array6 = new long10[]{new long10(), new long10(), new long10()};
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Curve25519.set(long10Array[0], 9);
        Curve25519.unpack(long10Array[1], byArray4);
        Curve25519.x_to_y2(long10Array5[0], long10Array6[0], long10Array[1]);
        Curve25519.sqrt(long10Array5[0], long10Array6[0]);
        int n8 = Curve25519.is_negative(long10Array5[0]);
        long10Array6[0]._0 += 39420360L;
        Curve25519.mul(long10Array6[1], BASE_2Y, long10Array5[0]);
        Curve25519.sub(long10Array5[n8], long10Array6[0], long10Array6[1]);
        Curve25519.add(long10Array5[1 - n8], long10Array6[0], long10Array6[1]);
        Curve25519.cpy(long10Array6[0], long10Array[1]);
        long10Array6[0]._0 -= 9L;
        Curve25519.sqr(long10Array6[1], long10Array6[0]);
        Curve25519.recip(long10Array6[0], long10Array6[1], 0);
        Curve25519.mul(long10Array2[0], long10Array5[0], long10Array6[0]);
        Curve25519.sub(long10Array2[0], long10Array2[0], long10Array[1]);
        long10Array2[0]._0 -= 486671L;
        Curve25519.mul(long10Array2[1], long10Array5[1], long10Array6[0]);
        Curve25519.sub(long10Array2[1], long10Array2[1], long10Array[1]);
        long10Array2[1]._0 -= 486671L;
        Curve25519.mul_small(long10Array2[0], long10Array2[0], 1L);
        Curve25519.mul_small(long10Array2[1], long10Array2[1], 1L);
        for (n3 = 0; n3 < 32; ++n3) {
            n4 = n4 >> 8 ^ byArray2[n3] & 0xFF ^ (byArray2[n3] & 0xFF) << 1;
            n5 = n5 >> 8 ^ byArray3[n3] & 0xFF ^ (byArray3[n3] & 0xFF) << 1;
            n7 = ~(n4 ^ n5);
            n6 = n7 & (n6 & 0x80) >> 7 ^ n4;
            n6 ^= n7 & (n6 & 1) << 1;
            n6 ^= n7 & (n6 & 2) << 1;
            n6 ^= n7 & (n6 & 4) << 1;
            n6 ^= n7 & (n6 & 8) << 1;
            n6 ^= n7 & (n6 & 0x10) << 1;
            n6 ^= n7 & (n6 & 0x20) << 1;
            n6 ^= n7 & (n6 & 0x40) << 1;
            byArray5[n3] = (byte)n6;
        }
        n6 = (n7 & (n6 & 0x80) << 1 ^ n4) >> 8;
        Curve25519.set(long10Array3[0], 1);
        Curve25519.cpy(long10Array3[1], long10Array[n6]);
        Curve25519.cpy(long10Array3[2], long10Array2[0]);
        Curve25519.set(long10Array4[0], 0);
        Curve25519.set(long10Array4[1], 1);
        Curve25519.set(long10Array4[2], 1);
        n4 = 0;
        n5 = 0;
        n3 = 32;
        while (n3-- != 0) {
            n4 = n4 << 8 | byArray2[n3] & 0xFF;
            n5 = n5 << 8 | byArray3[n3] & 0xFF;
            n6 = n6 << 8 | byArray5[n3] & 0xFF;
            n8 = 8;
            while (n8-- != 0) {
                Curve25519.mont_prep(long10Array5[0], long10Array6[0], long10Array3[0], long10Array4[0]);
                Curve25519.mont_prep(long10Array5[1], long10Array6[1], long10Array3[1], long10Array4[1]);
                Curve25519.mont_prep(long10Array5[2], long10Array6[2], long10Array3[2], long10Array4[2]);
                n2 = ((n4 ^ n4 >> 1) >> n8 & 1) + ((n5 ^ n5 >> 1) >> n8 & 1);
                Curve25519.mont_dbl(long10Array3[2], long10Array4[2], long10Array5[n2], long10Array6[n2], long10Array3[0], long10Array4[0]);
                n2 = n6 >> n8 & 2 ^ (n6 >> n8 & 1) << 1;
                Curve25519.mont_add(long10Array5[1], long10Array6[1], long10Array5[n2], long10Array6[n2], long10Array3[1], long10Array4[1], long10Array[n6 >> n8 & 1]);
                Curve25519.mont_add(long10Array5[2], long10Array6[2], long10Array5[0], long10Array6[0], long10Array3[2], long10Array4[2], long10Array2[((n4 ^ n5) >> n8 & 2) >> 1]);
            }
        }
        n2 = (n4 & 1) + (n5 & 1);
        Curve25519.recip(long10Array5[0], long10Array4[n2], 0);
        Curve25519.mul(long10Array5[1], long10Array3[n2], long10Array5[0]);
        Curve25519.pack(long10Array5[1], byArray);
    }

    private static final void cpy32(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < 32; ++i2) {
            byArray[i2] = byArray2[i2];
        }
    }

    private static final int mula_small(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4) {
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2 + n2] = (byte)(n5 += (byArray2[i2 + n2] & 0xFF) + n4 * (byArray3[i2] & 0xFF));
            n5 >>= 8;
        }
        return n5;
    }

    private static final int mula32(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        int n4;
        int n5 = 31;
        int n6 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            int n7 = n3 * (byArray3[n4] & 0xFF);
            byArray[n4 + 31] = (byte)(n6 += Curve25519.mula_small(byArray, byArray, n4, byArray2, 31, n7) + (byArray[n4 + 31] & 0xFF) + n7 * (byArray2[31] & 0xFF));
            n6 >>= 8;
        }
        byArray[n4 + 31] = (byte)(n6 + (byArray[n4 + 31] & 0xFF));
        return n6 >> 8;
    }

    private static final void divmod(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        int n4 = 0;
        int n5 = (byArray3[n3 - 1] & 0xFF) << 8;
        if (n3 > 1) {
            n5 |= byArray3[n3 - 2] & 0xFF;
        }
        while (n2-- >= n3) {
            int n6 = n4 << 16 | (byArray2[n2] & 0xFF) << 8;
            if (n2 > 0) {
                n6 |= byArray2[n2 - 1] & 0xFF;
            }
            byArray[n2 - n3 + 1] = (byte)(n6 + (n4 += Curve25519.mula_small(byArray2, byArray2, n2 - n3 + 1, byArray3, n3, -(n6 /= n5))) & 0xFF);
            Curve25519.mula_small(byArray2, byArray2, n2 - n3 + 1, byArray3, n3, -n4);
            n4 = byArray2[n2] & 0xFF;
            byArray2[n2] = 0;
        }
        byArray2[n3 - 1] = (byte)n4;
    }

    private static final int numsize(byte[] byArray, int n2) {
        while (n2-- != 0 && byArray[n2] == 0) {
        }
        return n2 + 1;
    }

    private static final byte[] egcd32(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = 32;
        for (int i2 = 0; i2 < 32; ++i2) {
            byArray2[i2] = 0;
            byArray[i2] = 0;
        }
        byArray[0] = 1;
        int n3 = Curve25519.numsize(byArray3, 32);
        if (n3 == 0) {
            return byArray2;
        }
        byte[] byArray5 = new byte[32];
        while (true) {
            int n4 = n2 - n3 + 1;
            Curve25519.divmod(byArray5, byArray4, n2, byArray3, n3);
            n2 = Curve25519.numsize(byArray4, n2);
            if (n2 == 0) {
                return byArray;
            }
            Curve25519.mula32(byArray2, byArray, byArray5, n4, -1);
            n4 = n3 - n2 + 1;
            Curve25519.divmod(byArray5, byArray3, n3, byArray4, n2);
            n3 = Curve25519.numsize(byArray3, n3);
            if (n3 == 0) {
                return byArray2;
            }
            Curve25519.mula32(byArray, byArray2, byArray5, n4, -1);
        }
    }

    private static final void unpack(long10 long102, byte[] byArray) {
        long102._0 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF & 3) << 24;
        long102._1 = (byArray[3] & 0xFF & 0xFFFFFFFC) >> 2 | (byArray[4] & 0xFF) << 6 | (byArray[5] & 0xFF) << 14 | (byArray[6] & 0xFF & 7) << 22;
        long102._2 = (byArray[6] & 0xFF & 0xFFFFFFF8) >> 3 | (byArray[7] & 0xFF) << 5 | (byArray[8] & 0xFF) << 13 | (byArray[9] & 0xFF & 0x1F) << 21;
        long102._3 = (byArray[9] & 0xFF & 0xFFFFFFE0) >> 5 | (byArray[10] & 0xFF) << 3 | (byArray[11] & 0xFF) << 11 | (byArray[12] & 0xFF & 0x3F) << 19;
        long102._4 = (byArray[12] & 0xFF & 0xFFFFFFC0) >> 6 | (byArray[13] & 0xFF) << 2 | (byArray[14] & 0xFF) << 10 | (byArray[15] & 0xFF) << 18;
        long102._5 = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF & 1) << 24;
        long102._6 = (byArray[19] & 0xFF & 0xFFFFFFFE) >> 1 | (byArray[20] & 0xFF) << 7 | (byArray[21] & 0xFF) << 15 | (byArray[22] & 0xFF & 7) << 23;
        long102._7 = (byArray[22] & 0xFF & 0xFFFFFFF8) >> 3 | (byArray[23] & 0xFF) << 5 | (byArray[24] & 0xFF) << 13 | (byArray[25] & 0xFF & 0xF) << 21;
        long102._8 = (byArray[25] & 0xFF & 0xFFFFFFF0) >> 4 | (byArray[26] & 0xFF) << 4 | (byArray[27] & 0xFF) << 12 | (byArray[28] & 0xFF & 0x3F) << 20;
        long102._9 = (byArray[28] & 0xFF & 0xFFFFFFC0) >> 6 | (byArray[29] & 0xFF) << 2 | (byArray[30] & 0xFF) << 10 | (byArray[31] & 0xFF) << 18;
    }

    private static final boolean is_overflow(long10 long102) {
        return long102._0 > 67108844L && (long102._1 & long102._3 & long102._5 & long102._7 & long102._9) == 0x1FFFFFFL && (long102._2 & long102._4 & long102._6 & long102._8) == 0x3FFFFFFL || long102._9 > 0x1FFFFFFL;
    }

    private static final void pack(long10 long102, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        n2 = (Curve25519.is_overflow(long102) ? 1 : 0) - (long102._9 < 0L ? 1 : 0);
        n3 = n2 * -33554432;
        long l2 = (long)(n2 *= 19) + long102._0 + (long102._1 << 26);
        byArray[0] = (byte)l2;
        byArray[1] = (byte)(l2 >> 8);
        byArray[2] = (byte)(l2 >> 16);
        byArray[3] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._2 << 19);
        byArray[4] = (byte)l2;
        byArray[5] = (byte)(l2 >> 8);
        byArray[6] = (byte)(l2 >> 16);
        byArray[7] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._3 << 13);
        byArray[8] = (byte)l2;
        byArray[9] = (byte)(l2 >> 8);
        byArray[10] = (byte)(l2 >> 16);
        byArray[11] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._4 << 6);
        byArray[12] = (byte)l2;
        byArray[13] = (byte)(l2 >> 8);
        byArray[14] = (byte)(l2 >> 16);
        byArray[15] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + long102._5 + (long102._6 << 25);
        byArray[16] = (byte)l2;
        byArray[17] = (byte)(l2 >> 8);
        byArray[18] = (byte)(l2 >> 16);
        byArray[19] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._7 << 19);
        byArray[20] = (byte)l2;
        byArray[21] = (byte)(l2 >> 8);
        byArray[22] = (byte)(l2 >> 16);
        byArray[23] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._8 << 12);
        byArray[24] = (byte)l2;
        byArray[25] = (byte)(l2 >> 8);
        byArray[26] = (byte)(l2 >> 16);
        byArray[27] = (byte)(l2 >> 24);
        l2 = (l2 >> 32) + (long102._9 + (long)n3 << 6);
        byArray[28] = (byte)l2;
        byArray[29] = (byte)(l2 >> 8);
        byArray[30] = (byte)(l2 >> 16);
        byArray[31] = (byte)(l2 >> 24);
    }

    private static final void cpy(long10 long102, long10 long103) {
        long102._0 = long103._0;
        long102._1 = long103._1;
        long102._2 = long103._2;
        long102._3 = long103._3;
        long102._4 = long103._4;
        long102._5 = long103._5;
        long102._6 = long103._6;
        long102._7 = long103._7;
        long102._8 = long103._8;
        long102._9 = long103._9;
    }

    private static final void set(long10 long102, int n2) {
        long102._0 = n2;
        long102._1 = 0L;
        long102._2 = 0L;
        long102._3 = 0L;
        long102._4 = 0L;
        long102._5 = 0L;
        long102._6 = 0L;
        long102._7 = 0L;
        long102._8 = 0L;
        long102._9 = 0L;
    }

    private static final void add(long10 long102, long10 long103, long10 long104) {
        long102._0 = long103._0 + long104._0;
        long102._1 = long103._1 + long104._1;
        long102._2 = long103._2 + long104._2;
        long102._3 = long103._3 + long104._3;
        long102._4 = long103._4 + long104._4;
        long102._5 = long103._5 + long104._5;
        long102._6 = long103._6 + long104._6;
        long102._7 = long103._7 + long104._7;
        long102._8 = long103._8 + long104._8;
        long102._9 = long103._9 + long104._9;
    }

    private static final void sub(long10 long102, long10 long103, long10 long104) {
        long102._0 = long103._0 - long104._0;
        long102._1 = long103._1 - long104._1;
        long102._2 = long103._2 - long104._2;
        long102._3 = long103._3 - long104._3;
        long102._4 = long103._4 - long104._4;
        long102._5 = long103._5 - long104._5;
        long102._6 = long103._6 - long104._6;
        long102._7 = long103._7 - long104._7;
        long102._8 = long103._8 - long104._8;
        long102._9 = long103._9 - long104._9;
    }

    private static final long10 mul_small(long10 long102, long10 long103, long l2) {
        long l3 = long103._8 * l2;
        long102._8 = l3 & 0x3FFFFFFL;
        l3 = (l3 >> 26) + long103._9 * l2;
        long102._9 = l3 & 0x1FFFFFFL;
        l3 = 19L * (l3 >> 25) + long103._0 * l2;
        long102._0 = l3 & 0x3FFFFFFL;
        l3 = (l3 >> 26) + long103._1 * l2;
        long102._1 = l3 & 0x1FFFFFFL;
        l3 = (l3 >> 25) + long103._2 * l2;
        long102._2 = l3 & 0x3FFFFFFL;
        l3 = (l3 >> 26) + long103._3 * l2;
        long102._3 = l3 & 0x1FFFFFFL;
        l3 = (l3 >> 25) + long103._4 * l2;
        long102._4 = l3 & 0x3FFFFFFL;
        l3 = (l3 >> 26) + long103._5 * l2;
        long102._5 = l3 & 0x1FFFFFFL;
        l3 = (l3 >> 25) + long103._6 * l2;
        long102._6 = l3 & 0x3FFFFFFL;
        l3 = (l3 >> 26) + long103._7 * l2;
        long102._7 = l3 & 0x1FFFFFFL;
        l3 = (l3 >> 25) + long102._8;
        long102._8 = l3 & 0x3FFFFFFL;
        long102._9 += l3 >> 26;
        return long102;
    }

    private static final long10 mul(long10 long102, long10 long103, long10 long104) {
        long l2 = long103._0;
        long l3 = long103._1;
        long l4 = long103._2;
        long l5 = long103._3;
        long l6 = long103._4;
        long l7 = long103._5;
        long l8 = long103._6;
        long l9 = long103._7;
        long l10 = long103._8;
        long l11 = long103._9;
        long l12 = long104._0;
        long l13 = long104._1;
        long l14 = long104._2;
        long l15 = long104._3;
        long l16 = long104._4;
        long l17 = long104._5;
        long l18 = long104._6;
        long l19 = long104._7;
        long l20 = long104._8;
        long l21 = long104._9;
        long l22 = l2 * l20 + l4 * l18 + l6 * l16 + l8 * l14 + l10 * l12 + 2L * (l3 * l19 + l5 * l17 + l7 * l15 + l9 * l13) + 38L * (l11 * l21);
        long102._8 = l22 & 0x3FFFFFFL;
        l22 = (l22 >> 26) + l2 * l21 + l3 * l20 + l4 * l19 + l5 * l18 + l6 * l17 + l7 * l16 + l8 * l15 + l9 * l14 + l10 * l13 + l11 * l12;
        long102._9 = l22 & 0x1FFFFFFL;
        l22 = l2 * l12 + 19L * ((l22 >> 25) + l4 * l20 + l6 * l18 + l8 * l16 + l10 * l14) + 38L * (l3 * l21 + l5 * l19 + l7 * l17 + l9 * l15 + l11 * l13);
        long102._0 = l22 & 0x3FFFFFFL;
        l22 = (l22 >> 26) + l2 * l13 + l3 * l12 + 19L * (l4 * l21 + l5 * l20 + l6 * l19 + l7 * l18 + l8 * l17 + l9 * l16 + l10 * l15 + l11 * l14);
        long102._1 = l22 & 0x1FFFFFFL;
        l22 = (l22 >> 25) + l2 * l14 + l4 * l12 + 19L * (l6 * l20 + l8 * l18 + l10 * l16) + 2L * (l3 * l13) + 38L * (l5 * l21 + l7 * l19 + l9 * l17 + l11 * l15);
        long102._2 = l22 & 0x3FFFFFFL;
        l22 = (l22 >> 26) + l2 * l15 + l3 * l14 + l4 * l13 + l5 * l12 + 19L * (l6 * l21 + l7 * l20 + l8 * l19 + l9 * l18 + l10 * l17 + l11 * l16);
        long102._3 = l22 & 0x1FFFFFFL;
        l22 = (l22 >> 25) + l2 * l16 + l4 * l14 + l6 * l12 + 19L * (l8 * l20 + l10 * l18) + 2L * (l3 * l15 + l5 * l13) + 38L * (l7 * l21 + l9 * l19 + l11 * l17);
        long102._4 = l22 & 0x3FFFFFFL;
        l22 = (l22 >> 26) + l2 * l17 + l3 * l16 + l4 * l15 + l5 * l14 + l6 * l13 + l7 * l12 + 19L * (l8 * l21 + l9 * l20 + l10 * l19 + l11 * l18);
        long102._5 = l22 & 0x1FFFFFFL;
        l22 = (l22 >> 25) + l2 * l18 + l4 * l16 + l6 * l14 + l8 * l12 + 19L * (l10 * l20) + 2L * (l3 * l17 + l5 * l15 + l7 * l13) + 38L * (l9 * l21 + l11 * l19);
        long102._6 = l22 & 0x3FFFFFFL;
        l22 = (l22 >> 26) + l2 * l19 + l3 * l18 + l4 * l17 + l5 * l16 + l6 * l15 + l7 * l14 + l8 * l13 + l9 * l12 + 19L * (l10 * l21 + l11 * l20);
        long102._7 = l22 & 0x1FFFFFFL;
        l22 = (l22 >> 25) + long102._8;
        long102._8 = l22 & 0x3FFFFFFL;
        long102._9 += l22 >> 26;
        return long102;
    }

    private static final long10 sqr(long10 long102, long10 long103) {
        long l2 = long103._0;
        long l3 = long103._1;
        long l4 = long103._2;
        long l5 = long103._3;
        long l6 = long103._4;
        long l7 = long103._5;
        long l8 = long103._6;
        long l9 = long103._7;
        long l10 = long103._8;
        long l11 = long103._9;
        long l12 = l6 * l6 + 2L * (l2 * l10 + l4 * l8) + 38L * (l11 * l11) + 4L * (l3 * l9 + l5 * l7);
        long102._8 = l12 & 0x3FFFFFFL;
        l12 = (l12 >> 26) + 2L * (l2 * l11 + l3 * l10 + l4 * l9 + l5 * l8 + l6 * l7);
        long102._9 = l12 & 0x1FFFFFFL;
        l12 = 19L * (l12 >> 25) + l2 * l2 + 38L * (l4 * l10 + l6 * l8 + l7 * l7) + 76L * (l3 * l11 + l5 * l9);
        long102._0 = l12 & 0x3FFFFFFL;
        l12 = (l12 >> 26) + 2L * (l2 * l3) + 38L * (l4 * l11 + l5 * l10 + l6 * l9 + l7 * l8);
        long102._1 = l12 & 0x1FFFFFFL;
        l12 = (l12 >> 25) + 19L * (l8 * l8) + 2L * (l2 * l4 + l3 * l3) + 38L * (l6 * l10) + 76L * (l5 * l11 + l7 * l9);
        long102._2 = l12 & 0x3FFFFFFL;
        l12 = (l12 >> 26) + 2L * (l2 * l5 + l3 * l4) + 38L * (l6 * l11 + l7 * l10 + l8 * l9);
        long102._3 = l12 & 0x1FFFFFFL;
        l12 = (l12 >> 25) + l4 * l4 + 2L * (l2 * l6) + 38L * (l8 * l10 + l9 * l9) + 4L * (l3 * l5) + 76L * (l7 * l11);
        long102._4 = l12 & 0x3FFFFFFL;
        l12 = (l12 >> 26) + 2L * (l2 * l7 + l3 * l6 + l4 * l5) + 38L * (l8 * l11 + l9 * l10);
        long102._5 = l12 & 0x1FFFFFFL;
        l12 = (l12 >> 25) + 19L * (l10 * l10) + 2L * (l2 * l8 + l4 * l6 + l5 * l5) + 4L * (l3 * l7) + 76L * (l9 * l11);
        long102._6 = l12 & 0x3FFFFFFL;
        l12 = (l12 >> 26) + 2L * (l2 * l9 + l3 * l8 + l4 * l7 + l5 * l6) + 38L * (l10 * l11);
        long102._7 = l12 & 0x1FFFFFFL;
        l12 = (l12 >> 25) + long102._8;
        long102._8 = l12 & 0x3FFFFFFL;
        long102._9 += l12 >> 26;
        return long102;
    }

    private static final void recip(long10 long102, long10 long103, int n2) {
        int n3;
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        long10 long107 = new long10();
        long10 long108 = new long10();
        Curve25519.sqr(long105, long103);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long104, long106);
        Curve25519.mul(long106, long104, long103);
        Curve25519.mul(long104, long106, long105);
        Curve25519.sqr(long105, long104);
        Curve25519.mul(long107, long105, long106);
        Curve25519.sqr(long105, long107);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.mul(long106, long105, long107);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long107, long105);
        for (n3 = 1; n3 < 5; ++n3) {
            Curve25519.sqr(long105, long107);
            Curve25519.sqr(long107, long105);
        }
        Curve25519.mul(long105, long107, long106);
        Curve25519.sqr(long107, long105);
        Curve25519.sqr(long108, long107);
        for (n3 = 1; n3 < 10; ++n3) {
            Curve25519.sqr(long107, long108);
            Curve25519.sqr(long108, long107);
        }
        Curve25519.mul(long107, long108, long105);
        for (n3 = 0; n3 < 5; ++n3) {
            Curve25519.sqr(long105, long107);
            Curve25519.sqr(long107, long105);
        }
        Curve25519.mul(long105, long107, long106);
        Curve25519.sqr(long106, long105);
        Curve25519.sqr(long107, long106);
        for (n3 = 1; n3 < 25; ++n3) {
            Curve25519.sqr(long106, long107);
            Curve25519.sqr(long107, long106);
        }
        Curve25519.mul(long106, long107, long105);
        Curve25519.sqr(long107, long106);
        Curve25519.sqr(long108, long107);
        for (n3 = 1; n3 < 50; ++n3) {
            Curve25519.sqr(long107, long108);
            Curve25519.sqr(long108, long107);
        }
        Curve25519.mul(long107, long108, long106);
        for (n3 = 0; n3 < 25; ++n3) {
            Curve25519.sqr(long108, long107);
            Curve25519.sqr(long107, long108);
        }
        Curve25519.mul(long106, long107, long105);
        Curve25519.sqr(long105, long106);
        Curve25519.sqr(long106, long105);
        if (n2 != 0) {
            Curve25519.mul(long102, long103, long106);
        } else {
            Curve25519.sqr(long105, long106);
            Curve25519.sqr(long106, long105);
            Curve25519.sqr(long105, long106);
            Curve25519.mul(long102, long105, long104);
        }
    }

    private static final int is_negative(long10 long102) {
        return (int)((long)(Curve25519.is_overflow(long102) || long102._9 < 0L ? 1 : 0) ^ long102._0 & 1L);
    }

    private static final void sqrt(long10 long102, long10 long103) {
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        Curve25519.add(long105, long103, long103);
        Curve25519.recip(long104, long105, 1);
        Curve25519.sqr(long102, long104);
        Curve25519.mul(long106, long105, long102);
        --long106._0;
        Curve25519.mul(long105, long104, long106);
        Curve25519.mul(long102, long103, long105);
    }

    private static final void mont_prep(long10 long102, long10 long103, long10 long104, long10 long105) {
        Curve25519.add(long102, long104, long105);
        Curve25519.sub(long103, long104, long105);
    }

    private static final void mont_add(long10 long102, long10 long103, long10 long104, long10 long105, long10 long106, long10 long107, long10 long108) {
        Curve25519.mul(long106, long103, long104);
        Curve25519.mul(long107, long102, long105);
        Curve25519.add(long102, long106, long107);
        Curve25519.sub(long103, long106, long107);
        Curve25519.sqr(long106, long102);
        Curve25519.sqr(long102, long103);
        Curve25519.mul(long107, long102, long108);
    }

    private static final void mont_dbl(long10 long102, long10 long103, long10 long104, long10 long105, long10 long106, long10 long107) {
        Curve25519.sqr(long102, long104);
        Curve25519.sqr(long103, long105);
        Curve25519.mul(long106, long102, long103);
        Curve25519.sub(long103, long102, long103);
        Curve25519.mul_small(long107, long103, 121665L);
        Curve25519.add(long102, long102, long107);
        Curve25519.mul(long107, long102, long103);
    }

    private static final void x_to_y2(long10 long102, long10 long103, long10 long104) {
        Curve25519.sqr(long102, long104);
        Curve25519.mul_small(long103, long104, 486662L);
        Curve25519.add(long102, long102, long103);
        ++long102._0;
        Curve25519.mul(long103, long102, long104);
    }

    private static final void core(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object object;
        long10 long102 = new long10();
        long10 long103 = new long10();
        long10 long104 = new long10();
        long10 long105 = new long10();
        long10 long106 = new long10();
        long10[] long10Array = new long10[]{new long10(), new long10()};
        long10[] long10Array2 = new long10[]{new long10(), new long10()};
        if (byArray4 != null) {
            Curve25519.unpack(long102, byArray4);
        } else {
            Curve25519.set(long102, 9);
        }
        Curve25519.set(long10Array[0], 1);
        Curve25519.set(long10Array2[0], 0);
        Curve25519.cpy(long10Array[1], long102);
        Curve25519.set(long10Array2[1], 1);
        int n2 = 32;
        while (n2-- != 0) {
            if (n2 == 0) {
                n2 = 0;
            }
            int n3 = 8;
            while (n3-- != 0) {
                int n4 = (byArray3[n2] & 0xFF) >> n3 & 1;
                int n5 = ~(byArray3[n2] & 0xFF) >> n3 & 1;
                object = long10Array[n5];
                long10 long107 = long10Array2[n5];
                long10 long108 = long10Array[n4];
                long10 long109 = long10Array2[n4];
                Curve25519.mont_prep(long103, long104, (long10)object, long107);
                Curve25519.mont_prep(long105, long106, long108, long109);
                Curve25519.mont_add(long103, long104, long105, long106, (long10)object, long107, long102);
                Curve25519.mont_dbl(long103, long104, long105, long106, long108, long109);
            }
        }
        Curve25519.recip(long103, long10Array2[0], 0);
        Curve25519.mul(long102, long10Array[0], long103);
        Curve25519.pack(long102, byArray);
        if (byArray2 != null) {
            Curve25519.x_to_y2(long104, long103, long102);
            Curve25519.recip(long105, long10Array2[1], 0);
            Curve25519.mul(long104, long10Array[1], long105);
            Curve25519.add(long104, long104, long102);
            long104._0 += 486671L;
            long102._0 -= 9L;
            Curve25519.sqr(long105, long102);
            Curve25519.mul(long102, long104, long105);
            Curve25519.sub(long102, long102, long103);
            long102._0 -= 39420360L;
            Curve25519.mul(long103, long102, BASE_R2Y);
            if (Curve25519.is_negative(long103) != 0) {
                Curve25519.cpy32(byArray2, byArray3);
            } else {
                Curve25519.mula_small(byArray2, ORDER_TIMES_8, 0, byArray3, 32, -1);
            }
            byte[] byArray5 = new byte[32];
            byte[] byArray6 = new byte[64];
            object = new byte[64];
            Curve25519.cpy32(byArray5, ORDER);
            Curve25519.cpy32(byArray2, Curve25519.egcd32(byArray6, (byte[])object, byArray2, byArray5));
            if ((byArray2[31] & 0x80) != 0) {
                Curve25519.mula_small(byArray2, byArray2, 0, ORDER, 32, 1);
            }
        }
    }

    private static final class long10 {
        public long _0;
        public long _1;
        public long _2;
        public long _3;
        public long _4;
        public long _5;
        public long _6;
        public long _7;
        public long _8;
        public long _9;

        public long10() {
        }

        public long10(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11) {
            this._0 = l2;
            this._1 = l3;
            this._2 = l4;
            this._3 = l5;
            this._4 = l6;
            this._5 = l7;
            this._6 = l8;
            this._7 = l9;
            this._8 = l10;
            this._9 = l11;
        }
    }
}

