/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import android.util.Size;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class NativeGalleryUtils {
    private static String secondaryStoragePath = null;
    private static int isXiaomiOrMIUI = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsXiaomiOrMIUI() {
        if (isXiaomiOrMIUI > 0) {
            return true;
        }
        if (isXiaomiOrMIUI < 0) {
            return false;
        }
        if ("xiaomi".equalsIgnoreCase(Build.MANUFACTURER)) {
            isXiaomiOrMIUI = 1;
            return true;
        }
        BufferedReader inputStream = null;
        try {
            Process process = Runtime.getRuntime().exec("getprop ro.miui.ui.version.name");
            inputStream = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
            String line = inputStream.readLine();
            if (line != null && line.length() > 0) {
                isXiaomiOrMIUI = 1;
                boolean bl = true;
                return bl;
            }
            isXiaomiOrMIUI = -1;
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            isXiaomiOrMIUI = -1;
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String GetPathFromURI(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String selection = null;
        String[] selectionArgs = null;
        try {
            if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context.getApplicationContext(), (Uri)uri)) {
                if ("com.android.externalstorage.documents".equals(uri.getAuthority())) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    if ("primary".equalsIgnoreCase(split[0])) {
                        return Environment.getExternalStorageDirectory() + File.separator + split[1];
                    }
                    if (!"raw".equalsIgnoreCase(split[0])) return NativeGalleryUtils.GetSecondaryStoragePathFor(split[1]);
                    return split[1];
                }
                if ("com.android.providers.downloads.documents".equals(uri.getAuthority())) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    if (id.startsWith("raw:")) {
                        return id.substring(4);
                    }
                    if (id.indexOf(58) >= 0) return null;
                    uri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.parseLong(id));
                } else if ("com.android.providers.media.documents".equals(uri.getAuthority())) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    if ("image".equals(type)) {
                        uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    } else if ("raw".equals(type)) {
                        return split[1];
                    }
                    selection = "_id=?";
                    selectionArgs = new String[]{split[1]};
                }
            }
            if (!"content".equalsIgnoreCase(uri.getScheme())) {
                if (!"file".equalsIgnoreCase(uri.getScheme())) return null;
                return uri.getPath();
            }
            String[] projection = new String[]{"_data"};
            try (Cursor cursor = null;){
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor == null) return null;
                int column_index = cursor.getColumnIndexOrThrow("_data");
                if (!cursor.moveToFirst()) return null;
                String columnValue = cursor.getString(column_index);
                if (columnValue == null) return null;
                if (columnValue.length() <= 0) return null;
                String string2 = columnValue;
                return string2;
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            return null;
        }
    }

    private static String GetSecondaryStoragePathFor(String localPath) {
        if (secondaryStoragePath == null) {
            String[] possibleRoots;
            String primaryPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            String strSDCardPath = System.getenv("SECONDARY_STORAGE");
            if (strSDCardPath == null || strSDCardPath.length() == 0) {
                strSDCardPath = System.getenv("EXTERNAL_SDCARD_STORAGE");
            }
            if (strSDCardPath != null && strSDCardPath.length() > 0) {
                if (!strSDCardPath.contains(":")) {
                    strSDCardPath = strSDCardPath + ":";
                }
                String[] externalPaths = strSDCardPath.split(":");
                for (int i = 0; i < externalPaths.length; ++i) {
                    String absolutePath;
                    File file;
                    String path = externalPaths[i];
                    if (path == null || path.length() <= 0 || !(file = new File(path)).exists() || !file.isDirectory() || !file.canRead() || file.getAbsolutePath().equalsIgnoreCase(primaryPath) || !new File(absolutePath = file.getAbsolutePath() + File.separator + localPath).exists()) continue;
                    secondaryStoragePath = file.getAbsolutePath();
                    return absolutePath;
                }
            }
            for (String root : possibleRoots = new String[]{"/storage", "/mnt", "/storage/removable", "/removable", "/data", "/mnt/media_rw", "/mnt/sdcard0"}) {
                try {
                    File[] fileList;
                    for (File file : fileList = new File(root).listFiles()) {
                        String absolutePath;
                        if (!file.exists() || !file.isDirectory() || !file.canRead() || file.getAbsolutePath().equalsIgnoreCase(primaryPath) || !new File(absolutePath = file.getAbsolutePath() + File.separator + localPath).exists()) continue;
                        secondaryStoragePath = file.getAbsolutePath();
                        return absolutePath;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            secondaryStoragePath = "_NulL_";
        } else if (!secondaryStoragePath.equals("_NulL_")) {
            return secondaryStoragePath + File.separator + localPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean WriteFileToStream(File file, OutputStream out) {
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            }
        }
        return true;
    }

    private static BitmapFactory.Options GetImageMetadata(String path) {
        try {
            BitmapFactory.Options result = new BitmapFactory.Options();
            result.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)result);
            return result;
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetImageOrientation(Context context, String path) {
        try {
            ExifInterface exif = new ExifInterface(path);
            int orientationEXIF = exif.getAttributeInt("Orientation", 0);
            if (orientationEXIF != 0) {
                return orientationEXIF;
            }
        }
        catch (Exception exif) {
            // empty catch block
        }
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(Uri.fromFile((File)new File(path)), new String[]{"orientation"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int orientation = cursor.getInt(cursor.getColumnIndex("orientation"));
                if (orientation == 90) {
                    int n = 6;
                    return n;
                }
                if (orientation == 180) {
                    int n = 3;
                    return n;
                }
                if (orientation == 270) {
                    int n = 8;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        return 0;
    }

    private static Matrix GetImageOrientationCorrectionMatrix(int orientation, float scale) {
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 8: {
                matrix.postRotate(270.0f);
                matrix.postScale(scale, scale);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                matrix.postScale(scale, scale);
                break;
            }
            case 6: {
                matrix.postRotate(90.0f);
                matrix.postScale(scale, scale);
                break;
            }
            case 2: {
                matrix.postScale(-scale, scale);
                break;
            }
            case 4: {
                matrix.postScale(scale, -scale);
                break;
            }
            case 5: {
                matrix.postRotate(90.0f);
                matrix.postScale(-scale, scale);
                break;
            }
            case 7: {
                matrix.postRotate(270.0f);
                matrix.postScale(-scale, scale);
                break;
            }
            default: {
                matrix.postScale(scale, scale);
            }
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String LoadImageAtPath(Context context, String path, String temporaryFilePath, int maxSize) {
        int orientation;
        BitmapFactory.Options metadata = NativeGalleryUtils.GetImageMetadata(path);
        if (metadata == null) {
            return path;
        }
        boolean shouldCreateNewBitmap = false;
        if (metadata.outWidth > maxSize || metadata.outHeight > maxSize) {
            shouldCreateNewBitmap = true;
        }
        if (metadata.outMimeType != null && !metadata.outMimeType.equals("image/jpeg") && !metadata.outMimeType.equals("image/png")) {
            shouldCreateNewBitmap = true;
        }
        if ((orientation = NativeGalleryUtils.GetImageOrientation(context, path)) != 1 && orientation != 0) {
            shouldCreateNewBitmap = true;
        }
        if (shouldCreateNewBitmap) {
            Bitmap bitmap = null;
            FileOutputStream out = null;
            try {
                float scale;
                int sampleSize = 1;
                int halfHeight = metadata.outHeight / 2;
                int halfWidth = metadata.outWidth / 2;
                while (halfHeight / sampleSize >= maxSize || halfWidth / sampleSize >= maxSize) {
                    sampleSize *= 2;
                }
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = sampleSize;
                options.inJustDecodeBounds = false;
                bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                float scaleX = 1.0f;
                float scaleY = 1.0f;
                if (bitmap.getWidth() > maxSize) {
                    scaleX = (float)maxSize / (float)bitmap.getWidth();
                }
                if (bitmap.getHeight() > maxSize) {
                    scaleY = (float)maxSize / (float)bitmap.getHeight();
                }
                float f = scale = scaleX < scaleY ? scaleX : scaleY;
                if (scale < 1.0f || orientation != 1 && orientation != 0) {
                    Matrix transformationMatrix = NativeGalleryUtils.GetImageOrientationCorrectionMatrix(orientation, scale);
                    Bitmap transformedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)transformationMatrix, (boolean)true);
                    if (transformedBitmap != bitmap) {
                        bitmap.recycle();
                        bitmap = transformedBitmap;
                    }
                }
                out = new FileOutputStream(temporaryFilePath);
                if (metadata.outMimeType == null || !metadata.outMimeType.equals("image/jpeg")) {
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
                } else {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                }
                path = temporaryFilePath;
            }
            catch (Exception e) {
                Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                try {
                    File temporaryFile = new File(temporaryFilePath);
                    if (temporaryFile.exists()) {
                        temporaryFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                if (bitmap != null) {
                    bitmap.recycle();
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return path;
    }

    public static String GetImageProperties(Context context, String path) {
        int orientation;
        BitmapFactory.Options metadata = NativeGalleryUtils.GetImageMetadata(path);
        if (metadata == null) {
            return "";
        }
        int width = metadata.outWidth;
        int height = metadata.outHeight;
        String mimeType = metadata.outMimeType;
        if (mimeType == null) {
            mimeType = "";
        }
        int orientationUnity = (orientation = NativeGalleryUtils.GetImageOrientation(context, path)) == 0 ? -1 : (orientation == 1 ? 0 : (orientation == 6 ? 1 : (orientation == 3 ? 2 : (orientation == 8 ? 3 : (orientation == 2 ? 4 : (orientation == 5 ? 5 : (orientation == 4 ? 6 : (orientation == 7 ? 7 : -1))))))));
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int temp = width;
            width = height;
            height = temp;
        }
        return width + ">" + height + ">" + mimeType + ">" + orientationUnity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=17)
    public static String GetVideoProperties(Context context, String path) {
        MediaMetadataRetriever metadataRetriever = new MediaMetadataRetriever();
        try {
            metadataRetriever.setDataSource(path);
            String width = metadataRetriever.extractMetadata(18);
            String height = metadataRetriever.extractMetadata(19);
            String duration = metadataRetriever.extractMetadata(9);
            String rotation = "0";
            if (Build.VERSION.SDK_INT >= 17) {
                rotation = metadataRetriever.extractMetadata(24);
            }
            if (width == null) {
                width = "0";
            }
            if (height == null) {
                height = "0";
            }
            if (duration == null) {
                duration = "0";
            }
            if (rotation == null) {
                rotation = "0";
            }
            String string2 = width + ">" + height + ">" + duration + ">" + rotation;
            return string2;
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            String string3 = "";
            return string3;
        }
        finally {
            try {
                metadataRetriever.release();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=29)
    public static String GetVideoThumbnail(Context context, String path, String savePath, boolean saveAsJpeg, int maxSize, double captureTime) {
        Object metadataRetriever;
        Bitmap bitmap = null;
        FileOutputStream out = null;
        try {
            if (captureTime < 0.0 && maxSize <= 1024) {
                try {
                    bitmap = Build.VERSION.SDK_INT < 29 ? ThumbnailUtils.createVideoThumbnail((String)path, (int)(maxSize > 512 ? 2 : 1)) : ThumbnailUtils.createVideoThumbnail((File)new File(path), (Size)(maxSize > 512 ? new Size(1024, 786) : new Size(512, 384)), null);
                }
                catch (Exception e) {
                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                }
            }
            if (bitmap == null) {
                metadataRetriever = new MediaMetadataRetriever();
                try {
                    metadataRetriever.setDataSource(path);
                    try {
                        int width = Integer.parseInt(metadataRetriever.extractMetadata(18));
                        int height = Integer.parseInt(metadataRetriever.extractMetadata(19));
                        if (maxSize > width && maxSize > height) {
                            maxSize = width > height ? width : height;
                        }
                    }
                    catch (Exception width) {
                        // empty catch block
                    }
                    if (captureTime < 0.0) {
                        captureTime = 0.0;
                    } else {
                        try {
                            double duration = (double)Long.parseLong(metadataRetriever.extractMetadata(9)) / 1000.0;
                            if (captureTime > duration) {
                                captureTime = duration;
                            }
                        }
                        catch (Exception duration) {
                            // empty catch block
                        }
                    }
                    long frameTime = (long)(captureTime * 1000000.0);
                    bitmap = Build.VERSION.SDK_INT < 27 ? metadataRetriever.getFrameAtTime(frameTime, 2) : metadataRetriever.getScaledFrameAtTime(frameTime, 2, maxSize, maxSize);
                }
                finally {
                    try {
                        metadataRetriever.release();
                    }
                    catch (Exception exception) {}
                }
            }
            if (bitmap == null) {
                metadataRetriever = "";
                return metadataRetriever;
            }
            out = new FileOutputStream(savePath);
            if (saveAsJpeg) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            }
            metadataRetriever = savePath;
        }
        catch (Exception e) {
            Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
            String string2 = "";
            return string2;
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return metadataRetriever;
    }
}

