/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SOARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Serial;
import com.hpplay.sdk.source.mdns.xbill.dns.TCPClient;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public class ZoneTransferIn {
    private static final int INITIALSOA = 0;
    private static final int FIRSTDATA = 1;
    private static final int IXFR_DELSOA = 2;
    private static final int IXFR_DEL = 3;
    private static final int IXFR_ADDSOA = 4;
    private static final int IXFR_ADD = 5;
    private static final int AXFR = 6;
    private static final int END = 7;
    private Name zname;
    private int qtype;
    private int dclass;
    private long ixfr_serial;
    private boolean want_fallback;
    private ZoneTransferHandler handler;
    private SocketAddress localAddress;
    private SocketAddress address;
    private TCPClient client;
    private TSIG tsig;
    private TSIG.StreamVerifier verifier;
    private long timeout = 900000L;
    private int state;
    private long end_serial;
    private long current_serial;
    private Record initialsoa;
    private int rtype;

    private ZoneTransferIn() {
    }

    private ZoneTransferIn(Name name, int n2, long l2, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        this.address = socketAddress;
        this.tsig = tSIG;
        if (name.isAbsolute()) {
            this.zname = name;
        } else {
            try {
                this.zname = Name.concatenate(name, Name.root);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("ZoneTransferIn: name too long");
            }
        }
        this.qtype = n2;
        this.dclass = 1;
        this.ixfr_serial = l2;
        this.want_fallback = bl;
        this.state = 0;
    }

    public static ZoneTransferIn newAXFR(Name name, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 252, 0L, false, socketAddress, tSIG);
    }

    public static ZoneTransferIn newAXFR(Name name, String string, int n2, TSIG tSIG) {
        if (n2 == 0) {
            n2 = 53;
        }
        return ZoneTransferIn.newAXFR(name, new InetSocketAddress(string, n2), tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l2, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 251, l2, bl, socketAddress, tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l2, boolean bl, String string, int n2, TSIG tSIG) {
        if (n2 == 0) {
            n2 = 53;
        }
        return ZoneTransferIn.newIXFR(name, l2, bl, new InetSocketAddress(string, n2), tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l2, boolean bl, String string, TSIG tSIG) {
        return ZoneTransferIn.newIXFR(name, l2, bl, string, 0, tSIG);
    }

    public Name getName() {
        return this.zname;
    }

    public int getType() {
        return this.qtype;
    }

    public void setTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.timeout = 1000L * (long)n2;
    }

    public void setDClass(int n2) {
        DClass.check(n2);
        this.dclass = n2;
    }

    public void setLocalAddress(SocketAddress socketAddress) {
        this.localAddress = socketAddress;
    }

    private void openConnection() {
        long l2 = System.currentTimeMillis() + this.timeout;
        this.client = new TCPClient(l2);
        if (this.localAddress != null) {
            this.client.bind(this.localAddress);
        }
        this.client.connect(this.address);
    }

    private void sendQuery() {
        Object object;
        Record record = Record.newRecord(this.zname, this.qtype, this.dclass);
        Message message = new Message();
        message.getHeader().setOpcode(0);
        message.addRecord(record, 0);
        if (this.qtype == 251) {
            object = new SOARecord(this.zname, this.dclass, 0L, Name.root, Name.root, this.ixfr_serial, 0L, 0L, 0L, 0L);
            message.addRecord((Record)object, 2);
        }
        if (this.tsig != null) {
            this.tsig.apply(message, null);
            this.verifier = new TSIG.StreamVerifier(this.tsig, message.getTSIG());
        }
        object = message.toWire(65535);
        this.client.send((byte[])object);
    }

    private static long getSOASerial(Record record) {
        SOARecord sOARecord = (SOARecord)record;
        return sOARecord.getSerial();
    }

    private void logxfr(String string) {
        if (Options.check("verbose")) {
            System.out.println(this.zname + ": " + string);
        }
    }

    private void fail(String string) {
        throw new Exception(string);
    }

    private void fallback() {
        if (!this.want_fallback) {
            this.fail("server doesn't support IXFR");
        }
        this.logxfr("falling back to AXFR");
        this.qtype = 252;
        this.state = 0;
    }

    private void parseRR(Record record) {
        int n2 = record.getType();
        switch (this.state) {
            case 0: {
                if (n2 != 6) {
                    this.fail("missing initial SOA");
                }
                this.initialsoa = record;
                this.end_serial = ZoneTransferIn.getSOASerial(record);
                if (this.qtype == 251 && Serial.compare(this.end_serial, this.ixfr_serial) <= 0) {
                    this.logxfr("up to date");
                    this.state = 7;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.qtype == 251 && n2 == 6 && ZoneTransferIn.getSOASerial(record) == this.ixfr_serial) {
                    this.rtype = 251;
                    this.handler.startIXFR();
                    this.logxfr("got incremental response");
                    this.state = 2;
                } else {
                    this.rtype = 252;
                    this.handler.startAXFR();
                    this.handler.handleRecord(this.initialsoa);
                    this.logxfr("got nonincremental response");
                    this.state = 6;
                }
                this.parseRR(record);
                return;
            }
            case 2: {
                this.handler.startIXFRDeletes(record);
                this.state = 3;
                break;
            }
            case 3: {
                if (n2 == 6) {
                    this.current_serial = ZoneTransferIn.getSOASerial(record);
                    this.state = 4;
                    this.parseRR(record);
                    return;
                }
                this.handler.handleRecord(record);
                break;
            }
            case 4: {
                this.handler.startIXFRAdds(record);
                this.state = 5;
                break;
            }
            case 5: {
                if (n2 == 6) {
                    long l2 = ZoneTransferIn.getSOASerial(record);
                    if (l2 == this.end_serial) {
                        this.state = 7;
                        break;
                    }
                    if (l2 == this.current_serial) {
                        this.state = 2;
                        this.parseRR(record);
                        return;
                    }
                    this.fail("IXFR out of sync: expected serial " + this.current_serial + " , got " + l2);
                }
                this.handler.handleRecord(record);
                break;
            }
            case 6: {
                if (n2 == 1 && record.getDClass() != this.dclass) break;
                this.handler.handleRecord(record);
                if (n2 != 6) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.fail("extra data");
                break;
            }
            default: {
                this.fail("invalid state");
            }
        }
    }

    private void closeConnection() {
        try {
            if (this.client != null) {
                this.client.cleanup();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Message parseMessage(byte[] byArray) {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            if (iOException instanceof Exception) {
                throw iOException;
            }
            throw new Exception("Error parsing message");
        }
    }

    private void doxfr() {
        this.sendQuery();
        while (this.state != 7) {
            int n2;
            Object object;
            byte[] byArray = this.client.recv();
            Message message = this.parseMessage(byArray);
            if (message.getHeader().getRcode() == 0 && this.verifier != null) {
                object = message.getTSIG();
                n2 = this.verifier.verify(message, byArray);
                if (n2 != 0) {
                    this.fail("TSIG failure");
                }
            }
            object = message.getSectionArray(1);
            if (this.state == 0) {
                Record record;
                n2 = message.getRcode();
                if (n2 != 0) {
                    if (this.qtype == 251 && n2 == 4) {
                        this.fallback();
                        this.doxfr();
                        return;
                    }
                    this.fail(Rcode.string(n2));
                }
                if ((record = message.getQuestion()) != null && record.getType() != this.qtype) {
                    this.fail("invalid question section");
                }
                if (((Record[])object).length == 0 && this.qtype == 251) {
                    this.fallback();
                    this.doxfr();
                    return;
                }
            }
            for (n2 = 0; n2 < ((Record[])object).length; ++n2) {
                this.parseRR(object[n2]);
            }
            if (this.state != 7 || this.verifier == null || message.isVerified()) continue;
            this.fail("last message must be signed");
        }
    }

    public void run(ZoneTransferHandler zoneTransferHandler) {
        this.handler = zoneTransferHandler;
        try {
            this.openConnection();
            this.doxfr();
        }
        finally {
            this.closeConnection();
        }
    }

    public List run() {
        BasicHandler basicHandler = new BasicHandler();
        this.run(basicHandler);
        return basicHandler.axfr != null ? basicHandler.axfr : basicHandler.ixfr;
    }

    private BasicHandler getBasicHandler() {
        if (this.handler instanceof BasicHandler) {
            return (BasicHandler)this.handler;
        }
        throw new IllegalArgumentException("ZoneTransferIn used callback interface");
    }

    public boolean isAXFR() {
        return this.rtype == 252;
    }

    public List getAXFR() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.axfr;
    }

    public boolean isIXFR() {
        return this.rtype == 251;
    }

    public List getIXFR() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.ixfr;
    }

    public boolean isCurrent() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.axfr == null && basicHandler.ixfr == null;
    }

    public static class Delta {
        public long start;
        public long end;
        public List adds = new ArrayList();
        public List deletes = new ArrayList();

        private Delta() {
        }
    }

    public static interface ZoneTransferHandler {
        public void startAXFR();

        public void startIXFR();

        public void startIXFRDeletes(Record var1);

        public void startIXFRAdds(Record var1);

        public void handleRecord(Record var1);
    }

    private static class BasicHandler
    implements ZoneTransferHandler {
        private List axfr;
        private List ixfr;

        private BasicHandler() {
        }

        @Override
        public void startAXFR() {
            this.axfr = new ArrayList();
        }

        @Override
        public void startIXFR() {
            this.ixfr = new ArrayList();
        }

        @Override
        public void startIXFRDeletes(Record record) {
            Delta delta = new Delta();
            delta.deletes.add(record);
            delta.start = ZoneTransferIn.getSOASerial(record);
            this.ixfr.add(delta);
        }

        @Override
        public void startIXFRAdds(Record record) {
            Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
            delta.adds.add(record);
            delta.end = ZoneTransferIn.getSOASerial(record);
        }

        @Override
        public void handleRecord(Record record) {
            List list;
            if (this.ixfr != null) {
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                list = delta.adds.size() > 0 ? delta.adds : delta.deletes;
            } else {
                list = this.axfr;
            }
            list.add(record);
        }
    }
}

