/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;

public class SRVRecord
extends Record {
    private static final long serialVersionUID = -3886460132387522052L;
    private int priority;
    private int weight;
    private int port;
    private Name target;

    SRVRecord() {
    }

    @Override
    Record getObject() {
        return new SRVRecord();
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.priority = dNSInput.readU16();
        this.weight = dNSInput.readU16();
        this.port = dNSInput.readU16();
        this.target = new Name(dNSInput);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        this.priority = tokenizer.getUInt16();
        this.weight = tokenizer.getUInt16();
        this.port = tokenizer.getUInt16();
        this.target = tokenizer.getName(name);
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.priority + " ");
        stringBuffer.append(this.weight + " ");
        stringBuffer.append(this.port + " ");
        stringBuffer.append(this.target);
        return stringBuffer.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.priority);
        dNSOutput.writeU16(this.weight);
        dNSOutput.writeU16(this.port);
        this.target.toWire(dNSOutput, null, bl);
    }

    @Override
    public Name getAdditionalName() {
        return this.target;
    }
}

