/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class HTTPHeader {
    private static final String TAG = "Cyber-HTTPHeader";
    private static int MAX_LENGTH = 1024;
    private String name;
    private String value;

    public HTTPHeader(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public HTTPHeader(String string) {
        this.setName("");
        this.setValue("");
        if (string == null) {
            return;
        }
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return;
        }
        String string2 = new String(string.getBytes(), 0, n2);
        String string3 = new String(string.getBytes(), n2 + 1, string.length() - n2 - 1);
        this.setName(string2.trim());
        this.setValue(string3.trim());
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() > 0;
    }

    public static final String getValue(LineNumberReader lineNumberReader, String string) {
        String string2 = string.toUpperCase();
        try {
            String string3 = lineNumberReader.readLine();
            while (string3 != null && 0 < string3.length()) {
                HTTPHeader hTTPHeader = new HTTPHeader(string3);
                if (!hTTPHeader.hasName()) {
                    string3 = lineNumberReader.readLine();
                    continue;
                }
                String string4 = hTTPHeader.getName().toUpperCase();
                if (!string4.equals(string2)) {
                    string3 = lineNumberReader.readLine();
                    continue;
                }
                return hTTPHeader.getValue();
            }
        }
        catch (IOException iOException) {
            CLog.d(TAG, null, iOException);
            return "";
        }
        return "";
    }

    public static final String getValue(String string, String string2) {
        try {
            StringReader stringReader = new StringReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(stringReader, Math.min(string.length(), MAX_LENGTH));
            return HTTPHeader.getValue(lineNumberReader, string2);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return " ";
        }
    }

    public static final String getValue(byte[] byArray, String string) {
        if (byArray != null && byArray.length > 0) {
            return HTTPHeader.getValue(new String(byArray), string);
        }
        return " ";
    }

    public static final int getIntegerValue(String string, String string2) {
        try {
            return Integer.parseInt(HTTPHeader.getValue(string, string2));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static final int getIntegerValue(byte[] byArray, String string) {
        try {
            return Integer.parseInt(HTTPHeader.getValue(byArray, string));
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

