/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.cybergarage.xml.Node;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class Icon {
    public static final String ELEM_NAME = "icon";
    private Node iconNode;
    private static final String MIME_TYPE = "mimetype";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DEPTH = "depth";
    private static final String URL = "url";
    private Object userData = null;
    private byte[] bytes = null;

    public Node getIconNode() {
        return this.iconNode;
    }

    public Icon(Node node) {
        this.iconNode = node;
    }

    public Icon() {
        this(new Node(ELEM_NAME));
    }

    public static boolean isIconNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setMimeType(String string) {
        this.getIconNode().setNode(MIME_TYPE, string);
    }

    public String getMimeType() {
        return this.getIconNode().getNodeValue(MIME_TYPE);
    }

    public boolean hasMimeType() {
        String string = this.getMimeType();
        if (string == null) {
            return false;
        }
        return 0 < string.length();
    }

    public void setWidth(String string) {
        this.getIconNode().setNode(WIDTH, string);
    }

    public void setWidth(int n2) {
        try {
            this.setWidth(Integer.toString(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWidth() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(WIDTH));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setHeight(String string) {
        this.getIconNode().setNode(HEIGHT, string);
    }

    public void setHeight(int n2) {
        try {
            this.setHeight(Integer.toString(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHeight() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(HEIGHT));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setDepth(String string) {
        this.getIconNode().setNode(DEPTH, string);
    }

    public void setDepth(int n2) {
        try {
            this.setDepth(Integer.toString(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDepth() {
        try {
            return Integer.parseInt(this.getIconNode().getNodeValue(DEPTH));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setURL(String string) {
        this.getIconNode().setNode(URL, string);
    }

    public String getURL() {
        return this.getIconNode().getNodeValue(URL);
    }

    public boolean hasURL() {
        String string = this.getURL();
        if (string == null) {
            return false;
        }
        return 0 < string.length();
    }

    public boolean isURL(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.getURL();
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public boolean hasBytes() {
        if (this.bytes != null) {
            return true;
        }
        if (this.hasURL()) {
            return Icon.class.getResourceAsStream(this.getURL()) != null;
        }
        return false;
    }

    public byte[] getBytes() {
        if (this.bytes == null && this.hasURL()) {
            try {
                InputStream inputStream = Icon.class.getResourceAsStream(this.getURL());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = -1;
                while ((n2 = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n2);
                }
                inputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bytes;
    }
}

