/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.data;

import android.content.res.AssetManager;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.data.DataFetcher;
import java.io.IOException;

public abstract class AssetPathFetcher<T>
implements DataFetcher<T> {
    private static final String TAG = "AssetUriFetcher";
    private final String assetPath;
    private final AssetManager assetManager;
    private T data;

    public AssetPathFetcher(AssetManager assetManager, String string) {
        this.assetManager = assetManager;
        this.assetPath = string;
    }

    @Override
    public T loadData(Priority priority) {
        this.data = this.loadResource(this.assetManager, this.assetPath);
        return this.data;
    }

    @Override
    public void cleanup() {
        block3: {
            if (this.data == null) {
                return;
            }
            try {
                this.close(this.data);
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)2)) break block3;
                Log.v((String)TAG, (String)"Failed to close data", (Throwable)iOException);
            }
        }
    }

    @Override
    public String getId() {
        return this.assetPath;
    }

    @Override
    public void cancel() {
    }

    protected abstract T loadResource(AssetManager var1, String var2);

    protected abstract void close(T var1);
}

