/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.engine.DecodeJob;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.executor.Prioritized;
import com.hpplay.glide.request.ResourceCallback;

class EngineRunnable
implements Prioritized,
Runnable {
    private static final String TAG = "EngineRunnable";
    private final Priority priority;
    private final EngineRunnableManager manager;
    private final DecodeJob<?, ?, ?> decodeJob;
    private Stage stage;
    private volatile boolean isCancelled;

    public EngineRunnable(EngineRunnableManager engineRunnableManager, DecodeJob<?, ?, ?> decodeJob, Priority priority) {
        this.manager = engineRunnableManager;
        this.decodeJob = decodeJob;
        this.stage = Stage.CACHE;
        this.priority = priority;
    }

    public void cancel() {
        this.isCancelled = true;
        this.decodeJob.cancel();
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        Exception exception = null;
        Resource<?> resource = null;
        try {
            resource = this.decode();
        }
        catch (Exception exception2) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Exception decoding", (Throwable)exception2);
            }
            exception = exception2;
        }
        if (this.isCancelled) {
            if (resource != null) {
                resource.recycle();
            }
            return;
        }
        if (resource == null) {
            this.onLoadFailed(exception);
        } else {
            this.onLoadComplete(resource);
        }
    }

    private boolean isDecodingFromCache() {
        return this.stage == Stage.CACHE;
    }

    private void onLoadComplete(Resource resource) {
        this.manager.onResourceReady(resource);
    }

    private void onLoadFailed(Exception exception) {
        if (this.isDecodingFromCache()) {
            this.stage = Stage.SOURCE;
            this.manager.submitForSource(this);
        } else {
            this.manager.onException(exception);
        }
    }

    private Resource<?> decode() {
        if (this.isDecodingFromCache()) {
            return this.decodeFromCache();
        }
        return this.decodeFromSource();
    }

    private Resource<?> decodeFromCache() {
        Resource<?> resource;
        block3: {
            resource = null;
            try {
                resource = this.decodeJob.decodeResultFromCache();
            }
            catch (Exception exception) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                Log.d((String)TAG, (String)("Exception decoding result from cache: " + exception));
            }
        }
        if (resource == null) {
            resource = this.decodeJob.decodeSourceFromCache();
        }
        return resource;
    }

    private Resource<?> decodeFromSource() {
        return this.decodeJob.decodeFromSource();
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }

    static interface EngineRunnableManager
    extends ResourceCallback {
        public void submitForSource(EngineRunnable var1);
    }

    private static enum Stage {
        CACHE,
        SOURCE;

    }
}

