/*
 * Decompiled with CFR 0.152.
 */
package com.macroyau.blue2serial;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class SPPService {
    private static final String TAG = "SPPService";
    private static final UUID UUID_SPP = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private Handler mHandler;
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;
    private int mState = 0;

    public SPPService(Handler handler) {
        this.mHandler = handler;
    }

    private synchronized void setState(int state) {
        Log.d((String)TAG, (String)("setState() " + this.mState + " -> " + state));
        this.mState = state;
        this.mHandler.obtainMessage(1, state, -1).sendToTarget();
    }

    public synchronized int getState() {
        return this.mState;
    }

    public synchronized void start() {
        Log.d((String)TAG, (String)"start()");
        this.resetThreads();
        this.setState(0);
    }

    public synchronized void connect(BluetoothDevice device) {
        Log.d((String)TAG, (String)("connect(" + device + ")"));
        if (this.mState == 1) {
            this.resetConnectThread();
        }
        if (this.mState == 2) {
            this.resetConnectedThread();
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(1);
    }

    public synchronized void connect(BluetoothAdapter adapter) {
        Log.d((String)TAG, (String)("connect(" + adapter + ")"));
        if (this.mState == 1) {
            this.resetConnectThread();
        }
        if (this.mState == 2) {
            this.resetConnectedThread();
        }
        this.mConnectThread = new ConnectThread(adapter);
        this.mConnectThread.start();
        this.setState(1);
    }

    public synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        if (device == null) {
            Log.d((String)TAG, (String)"ServerMode!");
        } else {
            Log.d((String)TAG, (String)("Connected to " + device + "!"));
        }
        this.resetThreads();
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.setState(2);
    }

    public synchronized void stop() {
        Log.d((String)TAG, (String)"stop()");
        this.resetThreads();
        this.setState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] data) {
        ConnectedThread t;
        SPPService sPPService = this;
        synchronized (sPPService) {
            if (this.mState != 2) {
                return;
            }
            t = this.mConnectedThread;
        }
        t.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] data, int offset, int len) {
        ConnectedThread t;
        SPPService sPPService = this;
        synchronized (sPPService) {
            if (this.mState != 2) {
                return;
            }
            t = this.mConnectedThread;
        }
        t.write(data, offset, len);
    }

    private synchronized void resetThreads() {
        this.resetConnectThread();
        this.resetConnectedThread();
    }

    private synchronized void resetConnectThread() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
    }

    private synchronized void resetConnectedThread() {
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    private void reconnect() {
        this.start();
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mSocket;
        private final InputStream mInputStream;
        private final OutputStream mOutputStream;

        public ConnectedThread(BluetoothSocket socket) {
            Log.d((String)SPPService.TAG, (String)"ConnectedThread()");
            this.mSocket = socket;
            InputStream tempInputStream = null;
            OutputStream tempOutputStream = null;
            try {
                tempInputStream = socket.getInputStream();
                tempOutputStream = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"I/O streams cannot be created from the socket!");
            }
            this.mInputStream = tempInputStream;
            this.mOutputStream = tempOutputStream;
        }

        @Override
        public void run() {
            byte[] data = new byte[1024];
            boolean ender = false;
            while (!ender) {
                try {
                    int length = this.mInputStream.read(data);
                    byte[] read = new byte[length];
                    System.arraycopy(data, 0, read, 0, length);
                    SPPService.this.mHandler.obtainMessage(2, length, -1, (Object)read).sendToTarget();
                }
                catch (IOException e) {
                    this.cancel();
                    SPPService.this.reconnect();
                    ender = true;
                }
            }
        }

        public void write(byte[] data) {
            try {
                this.mOutputStream.write(data);
                SPPService.this.mHandler.obtainMessage(3, -1, -1, (Object)data).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"Unable to write the socket!");
            }
        }

        public void write(byte[] data, int offset, int len) {
            try {
                this.mOutputStream.write(data, offset, len);
                SPPService.this.mHandler.obtainMessage(3, -1, -1, (Object)data).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"Unable to write the socket!");
            }
        }

        public void cancel() {
            try {
                this.mSocket.close();
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"Unable to close the socket!");
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private BluetoothServerSocket mServerSocket;
        private BluetoothSocket mSocket;
        private final BluetoothDevice mDevice;

        public ConnectThread(BluetoothDevice device) {
            Log.d((String)SPPService.TAG, (String)("ConnectThread(" + device + ")"));
            BluetoothSocket tempSocket = null;
            try {
                tempSocket = device.createRfcommSocketToServiceRecord(UUID_SPP);
            }
            catch (IOException e1) {
                Log.e((String)SPPService.TAG, (String)"Failed to create a secure socket!");
                try {
                    tempSocket = device.createInsecureRfcommSocketToServiceRecord(UUID_SPP);
                }
                catch (IOException e2) {
                    Log.e((String)SPPService.TAG, (String)"Failed to create an insecure socket!");
                }
            }
            this.mDevice = device;
            this.mSocket = tempSocket;
        }

        public ConnectThread(BluetoothAdapter adapter) {
            Log.d((String)SPPService.TAG, (String)("ConnectThread(" + adapter + ")"));
            this.mDevice = null;
            this.mSocket = null;
            Object tempSocket = null;
            try {
                this.mServerSocket = adapter.listenUsingRfcommWithServiceRecord("SPAP_BT_SERVER", UUID_SPP);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.mSocket == null && this.mDevice == null) {
                    this.mSocket = this.mServerSocket.accept();
                    this.mServerSocket.close();
                } else {
                    this.mSocket.connect();
                }
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"Failed to connect to the socket!");
                this.cancel();
                SPPService.this.reconnect();
                return;
            }
            SPPService sPPService = SPPService.this;
            synchronized (sPPService) {
                SPPService.this.mConnectThread = null;
            }
            SPPService.this.connected(this.mSocket, this.mDevice);
        }

        public void cancel() {
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
                if (this.mServerSocket != null) {
                    this.mServerSocket.close();
                }
            }
            catch (IOException e) {
                Log.e((String)SPPService.TAG, (String)"Unable to close the socket!");
            }
        }
    }
}

