/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;

public class AutoStrategy {
    private static final String TAG = "AutoStrategy";
    private static final int MAX_SMOOTH_COUNT = 3000;
    public static final int DELAY_TINY = 1;
    public static final int DELAY_LOW = 2;
    public static final int MID_DELAY = 3;
    public static final int HIGH_DELAY = 4;
    public static final int SUPER_HIGH_DELAY = 5;
    public static final int BITRATE_SUPER = 0xA00000;
    public static final int BITRATE_HIGH = 0x800000;
    public static final int BITRATE_MID = 0x600000;
    public static final int BITRATE_LOW = 0x400000;
    public static final float BITRATE_LOW1 = 3670016.0f;
    public static final int BITRATE_LOW2 = 0x300000;
    public static final float BITRATE_LOW3 = 2621440.0f;
    public static final int BITRATE_LOW4 = 0x200000;
    public static final float BITRATE_LOW5 = 1992294.4f;
    private int mBitrate = 0x800000;
    private boolean isPauseEncode;
    private long delayMarkTime = System.currentTimeMillis();
    private int lowDelayCount;
    private long smoothInterval = 0L;
    private IMirrorStateListener mStrategyListener;
    private int mSmoothCount;
    private boolean isAutoBitrate;
    private int mQueueMaxRemain = 4;
    private int mHistoryBitrate;
    private int mRepeatRiseCount;
    private int mFrameRate;
    private int mJamCountkMonitor;

    public AutoStrategy(IMirrorStateListener iMirrorStateListener, int n2) {
        this.mStrategyListener = iMirrorStateListener;
        this.mFrameRate = n2;
        CLog.i(TAG, "===> " + this.mFrameRate);
    }

    public void setAutoBitrate(boolean bl) {
        CLog.i(TAG, "===> " + bl);
        this.isAutoBitrate = bl;
    }

    public void writeDelayCheck(int n2) {
        if (n2 == 0 && this.isPauseEncode) {
            this.isPauseEncode = false;
            long l2 = System.currentTimeMillis() - this.delayMarkTime;
            int n3 = 1;
            if (l2 <= 500L) {
                n3 = 2;
                this.lowDelayCount = this.smoothInterval > 0L && System.currentTimeMillis() - this.smoothInterval > 10000L && this.lowDelayCount > 0 ? --this.lowDelayCount : ++this.lowDelayCount;
                this.smoothInterval = System.currentTimeMillis();
            } else if (l2 <= 1000L) {
                this.lowDelayCount = 0;
                n3 = 3;
            } else if (l2 <= 1500L) {
                n3 = 4;
                this.lowDelayCount = 0;
            } else if (l2 > 2000L) {
                n3 = 5;
                this.lowDelayCount = 0;
            }
            CLog.i(TAG, "-----> remain send time --- > " + l2 + "  level  " + n3 + " lowDelayCount  " + this.lowDelayCount);
            if (n3 == 2 && this.lowDelayCount > 5) {
                if (this.isAutoBitrate) {
                    this.onBandwidthReduce(1);
                }
                this.lowDelayCount = 0;
            } else if (this.isAutoBitrate) {
                this.onBandwidthReduce(n3);
            }
            if (l2 > 10000L || l2 > 5000L && this.mJamCountkMonitor > 5) {
                CLog.i(TAG, "-----> onNetworkPoor --- > ");
                this.mJamCountkMonitor = 0;
                if (this.mStrategyListener != null && this.mStrategyListener.onNetworkPoor()) {
                    return;
                }
            }
            if (this.mStrategyListener != null) {
                this.mStrategyListener.onResumeEncode();
            }
        }
    }

    public void videoBufferSizeCheck(int n2, int n3) {
        if (n2 > n3) {
            if (this.mStrategyListener != null && !this.isPauseEncode) {
                this.isPauseEncode = true;
                this.delayMarkTime = System.currentTimeMillis();
                this.mStrategyListener.onPauseEncode();
                ++this.mJamCountkMonitor;
            }
        } else {
            this.mSmoothCount = n2 < this.mQueueMaxRemain ? ++this.mSmoothCount : 0;
            if (this.mSmoothCount > 3000) {
                this.mSmoothCount = 0;
                if (this.isAutoBitrate) {
                    this.onBandwidthRise();
                }
            }
        }
    }

    private void onBandwidthReduce(int n2) {
        this.setBitrateLevel(n2);
        boolean bl = this.bitrateAdjust(true);
        if (this.mStrategyListener != null) {
            this.mStrategyListener.onBitrateCallback(this.mBitrate);
            if (bl) {
                this.mStrategyListener.onFrameCallback(25);
            }
        }
    }

    private void onBandwidthRise() {
        if (!this.checkHistoryIsExceed()) {
            this.bitrateAdjust(false);
            CLog.i(TAG, " onBandwidthRise ===> " + this.mBitrate / 1000 / 1000);
            if (this.mBitrate == 0xA00000 && this.mStrategyListener != null) {
                this.mStrategyListener.onFrameCallback(this.mFrameRate);
            }
            if (this.mStrategyListener != null) {
                this.mStrategyListener.onBitrateCallback(this.mBitrate);
            }
        }
    }

    private boolean checkHistoryIsExceed() {
        if (this.mBitrate == this.mHistoryBitrate) {
            ++this.mRepeatRiseCount;
            CLog.i(TAG, " checkHistoryIsExceed  repeat count " + this.mRepeatRiseCount);
        }
        if (this.mRepeatRiseCount > 2) {
            int n2;
            this.mRepeatRiseCount = 0;
            if (this.mQueueMaxRemain > 2) {
                int n3 = this.mQueueMaxRemain;
                n2 = n3;
                this.mQueueMaxRemain = n3 - 1;
            } else {
                n2 = this.mQueueMaxRemain;
            }
            this.mQueueMaxRemain = n2;
            this.mHistoryBitrate = this.mBitrate;
            return true;
        }
        this.mHistoryBitrate = this.mBitrate;
        return false;
    }

    private void setBitrateLevel(int n2) {
        switch (n2) {
            case 1: {
                return;
            }
            case 2: {
                if ((float)this.mBitrate <= 3670016.0f) {
                    return;
                }
                this.mBitrate = 0x380000;
                break;
            }
            case 3: {
                if (this.mBitrate <= 0x300000) {
                    return;
                }
                this.mBitrate = 0x300000;
                break;
            }
            case 4: {
                if ((float)this.mBitrate <= 2621440.0f) {
                    return;
                }
                this.mBitrate = 0x280000;
                break;
            }
            case 5: {
                this.mBitrate = 0x1E6666;
            }
        }
        CLog.i(TAG, "setBitrateLevel " + this.mBitrate / 1000 / 1000);
    }

    private synchronized boolean bitrateAdjust(boolean bl) {
        boolean bl2 = false;
        switch (this.mBitrate) {
            case 0xA00000: {
                this.mBitrate = bl ? 0x800000 : 0xA00000;
                break;
            }
            case 0x800000: {
                this.mBitrate = bl ? 0x600000 : 0xA00000;
                break;
            }
            case 0x600000: {
                this.mBitrate = bl ? 0x400000 : 0x800000;
                break;
            }
            case 0x400000: {
                this.mBitrate = bl ? 0x380000 : 0x600000;
                break;
            }
            case 0x380000: {
                this.mBitrate = bl ? 0x300000 : 0x400000;
                break;
            }
            case 0x300000: {
                this.mBitrate = (int)(bl ? 2621440.0f : 3670016.0f);
                break;
            }
            case 0x280000: {
                this.mBitrate = bl ? 0x200000 : 0x300000;
                break;
            }
            case 0x200000: {
                this.mBitrate = (int)(bl ? 1992294.4f : 2621440.0f);
                break;
            }
            case 0x1E6666: {
                this.mBitrate = bl ? 0x1E6666 : 0x200000;
                bl2 = true;
            }
        }
        return bl2;
    }
}

