/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.common.store;

import android.content.Context;
import android.content.SharedPreferences;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;

public class ConnectCache {
    private static final String TAG = "SMCache";
    private static ConnectCache mPreference;
    private SharedPreferences mPref;

    private ConnectCache(Context context) {
        this.mPref = context.getSharedPreferences(context.getPackageName() + "_sm", 0);
    }

    public static synchronized ConnectCache getInstance() {
        if (mPreference == null) {
            ConnectCache.initPreference((Context)HapplayUtils.getApplication());
        }
        return mPreference;
    }

    private static ConnectCache initPreference(Context context) {
        SourceLog.i(TAG, "Preference initPreference");
        if (mPreference == null) {
            mPreference = new ConnectCache(context);
        }
        return mPreference;
    }

    public String get(String string) {
        return this.mPref.getString(string, null);
    }

    public void save(String string, String string2) {
        this.mPref.edit().putString(string, string2).apply();
    }
}

