/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp.utils;

import android.util.Log;
import com.herohan.uvcapp.utils.Watchdog;
import java.util.List;

class WatchdogDiagnostics {
    WatchdogDiagnostics() {
    }

    private static String getBlockedOnString(Object blockedOn) {
        return String.format("- waiting to lock <0x%08x> (a %s)", System.identityHashCode(blockedOn), blockedOn.getClass().getName());
    }

    private static String getLockedString(Object heldLock) {
        return String.format("- locked <0x%08x> (a %s)", System.identityHashCode(heldLock), heldLock.getClass().getName());
    }

    public static boolean diagnoseCheckers(List<Watchdog.HandlerChecker> blockedCheckers) {
        boolean hasStackTrace = false;
        for (int i = 0; i < blockedCheckers.size(); ++i) {
            StackTraceElement[] stackTrace;
            Thread blockedThread = blockedCheckers.get(i).getThread();
            Log.w((String)"Watchdog", (String)(blockedThread.getName() + " stack trace:"));
            for (StackTraceElement element : stackTrace = blockedThread.getStackTrace()) {
                Log.w((String)"Watchdog", (String)("    at " + element));
            }
            if (stackTrace.length <= 0) continue;
            hasStackTrace = true;
        }
        return hasStackTrace;
    }
}

