/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.api;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.GestureDescription;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Path;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.sdk.source.bean.PathEventInfo;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.List;

@SuppressLint(value={"LongLogTag"})
public class LelinkAccessibilityService
extends AccessibilityService {
    private static final String TAG = "LelinkAccessibilityService";
    private static volatile String mForegroundPackageName = "";
    static Handler handler;
    public static LelinkAccessibilityService lelinkAccessibilityService;
    private int mScreenWidth;
    private int mScreenHeight;

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        try {
            if (lelinkAccessibilityService == null) {
                lelinkAccessibilityService = this;
            }
            if (accessibilityEvent.getEventType() == 32 && !TextUtils.isEmpty((CharSequence)accessibilityEvent.getPackageName())) {
                mForegroundPackageName = accessibilityEvent.getPackageName() + "";
            }
            if (this.mScreenWidth == 0) {
                this.mScreenWidth = ScreenUtil.getRelScreenSize(this.getApplicationContext())[0];
                this.mScreenHeight = ScreenUtil.getRelScreenSize(this.getApplicationContext())[1];
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        SourceLog.i(TAG, "onServiceConnected: ");
    }

    public boolean onUnbind(Intent intent) {
        SourceLog.i(TAG, "onUnbind: ");
        return super.onUnbind(intent);
    }

    public static boolean isForeground(Context context) {
        if (TextUtils.isEmpty((CharSequence)mForegroundPackageName)) {
            return false;
        }
        String string = context.getApplicationContext().getPackageName();
        return mForegroundPackageName.equals(string);
    }

    public static boolean isServiceStart(Context context) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        List list = accessibilityManager.getEnabledAccessibilityServiceList(-1);
        for (AccessibilityServiceInfo accessibilityServiceInfo : list) {
            if (accessibilityServiceInfo.getId() == null || !accessibilityServiceInfo.getId().contains(LelinkAccessibilityService.class.getName()) || !accessibilityServiceInfo.getId().contains(context.getPackageName())) continue;
            return true;
        }
        mForegroundPackageName = "";
        return false;
    }

    public static void startMove() {
        handler.sendEmptyMessageDelayed(0, 4000L);
    }

    public void clickOnScreen(float f2, float f3, int n2, AccessibilityService.GestureResultCallback gestureResultCallback) {
        Path path = new Path();
        path.moveTo(f2, f3);
        this.gestureOnScreen(path, 0L, n2, gestureResultCallback);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        SourceLog.i(TAG, "onConfigurationChanged orientation:" + configuration.orientation);
        int n2 = ScreenUtil.getRelScreenSize(this.getApplicationContext())[0];
        int n3 = ScreenUtil.getRelScreenSize(this.getApplicationContext())[1];
        if (configuration.orientation == 2) {
            this.mScreenWidth = n2 > n3 ? n2 : n3;
            this.mScreenHeight = n2 > n3 ? n3 : n2;
        } else {
            this.mScreenWidth = n2 > n3 ? n3 : n2;
            this.mScreenHeight = n2 > n3 ? n2 : n3;
        }
    }

    public void moveOnScreen(PathEventInfo pathEventInfo, AccessibilityService.GestureResultCallback gestureResultCallback) {
        SourceLog.i(TAG, "moveOnScreen pathEventInfo.getStartRatioX():" + pathEventInfo.getStartRatioX() + ",pathEventInfo.getStartRatioY():" + pathEventInfo.getStartRatioY() + ",pathEventInfo.getTargetRatioX():" + pathEventInfo.getTargetRatioX() + ",pathEventInfo.getTargetRatioY():" + pathEventInfo.getTargetRatioY() + ",mScreenWidth:" + this.mScreenWidth + ",mScreenHeight:" + this.mScreenHeight);
        Path path = new Path();
        float f2 = pathEventInfo.getStartRatioX() * (float)this.mScreenWidth;
        float f3 = pathEventInfo.getStartRatioY() * (float)this.mScreenHeight;
        float f4 = pathEventInfo.getTargetRatioX() * (float)this.mScreenWidth;
        float f5 = pathEventInfo.getTargetRatioY() * (float)this.mScreenHeight;
        SourceLog.i(TAG, "moveOnScreen startX:" + f2 + "  startY:" + f3 + "   targetX " + f4 + " targetY  " + f5);
        path.moveTo(f2, f3);
        path.lineTo(f4, f5);
        this.gestureOnScreen(path, 0L, (long)pathEventInfo.getDuration(), gestureResultCallback);
    }

    protected void gestureOnScreen(Path path, long l2, long l3, AccessibilityService.GestureResultCallback gestureResultCallback) {
        GestureDescription.Builder builder = null;
        if (Build.VERSION.SDK_INT >= 24) {
            builder = new GestureDescription.Builder();
            builder.addStroke(new GestureDescription.StrokeDescription(path, l2, l3));
            GestureDescription gestureDescription = builder.build();
            this.dispatchGesture(gestureDescription, gestureResultCallback, null);
        }
    }

    public void onInterrupt() {
        SourceLog.i(TAG, "onInterrupt");
    }
}

