/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.util.Map;

public class BrowseResultOnlineCheck {
    private static final String TAG = "BrowseResultOnlineCheck";
    private static final int WHAT_TOAST_OFFLINE = 3;
    private static final int WHAT_CALLBACK_DISCONNECT = 4;
    private static BrowseResultOnlineCheck sInstance;
    private Context mContext;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 3: {
                    try {
                        LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)message.obj;
                        ConnectManager.getInstance().notifyOffline(lelinkServiceInfo);
                        if (!Feature.isXigua() || BrowseResultOnlineCheck.this.mContext == null) break;
                        if (lelinkServiceInfo == null || TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getName())) {
                            Toast.makeText((Context)BrowseResultOnlineCheck.this.mContext.getApplicationContext(), (CharSequence)"\u63a5\u6536\u7aef\u8bbe\u5907\u5df2\u79bb\u7ebf\uff0c\u8bf7\u6253\u5f00\u7535\u89c6\u5e94\u7528\u91cd\u65b0\u641c\u7d22\u6295\u5c4f", (int)1).show();
                            break;
                        }
                        Toast.makeText((Context)BrowseResultOnlineCheck.this.mContext.getApplicationContext(), (CharSequence)(lelinkServiceInfo.getName() + "\u5df2\u79bb\u7ebf\uff0c\u8bf7\u6253\u5f00\u7535\u89c6\u5e94\u7528\u91cd\u65b0\u641c\u7d22\u6295\u5c4f"), (int)1).show();
                    }
                    catch (Exception exception) {
                        SourceLog.w(BrowseResultOnlineCheck.TAG, exception);
                    }
                    break;
                }
                case 4: {
                    try {
                        LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)message.obj;
                        int n2 = message.arg1;
                        int n3 = message.arg2;
                        ConnectManager.getInstance().notifyDisconnect(lelinkServiceInfo, n2, n3);
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(BrowseResultOnlineCheck.TAG, exception);
                    }
                }
            }
            return false;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BrowseResultOnlineCheck getInstance() {
        Class<BrowseResultOnlineCheck> clazz = BrowseResultOnlineCheck.class;
        synchronized (BrowseResultOnlineCheck.class) {
            if (sInstance == null) {
                sInstance = new BrowseResultOnlineCheck();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BrowseResultOnlineCheck() {
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void checkDeviceOnline(final LelinkServiceInfo lelinkServiceInfo, final int n2, final int n3) {
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "checkDeviceOnline ignore");
            return;
        }
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean bl;
                    boolean bl2;
                    Map<Integer, BrowserInfo> map = lelinkServiceInfo.getBrowserInfos();
                    if (map == null) {
                        return;
                    }
                    BrowserInfo browserInfo = map.get(1);
                    if (browserInfo != null && !(bl2 = KeepAliveUtitls.tcpCheckTvState(lelinkServiceInfo.getName(), lelinkServiceInfo.getIp(), lelinkServiceInfo.getPort()))) {
                        SourceLog.i(BrowseResultOnlineCheck.TAG, "checkDeviceOnline " + lelinkServiceInfo.getName() + " " + lelinkServiceInfo.getIp() + " lelink is offline, browse again");
                        if (BrowseResultOnlineCheck.this.mHandler != null) {
                            BrowseResultOnlineCheck.this.mHandler.obtainMessage(3, (Object)lelinkServiceInfo).sendToTarget();
                        }
                        return;
                    }
                    BrowserInfo browserInfo2 = map.get(3);
                    if (browserInfo2 != null && !(bl = KeepAliveUtitls.tcpCheckTvState(lelinkServiceInfo.getName(), lelinkServiceInfo.getIp(), lelinkServiceInfo.getPort()))) {
                        SourceLog.i(BrowseResultOnlineCheck.TAG, "checkDeviceOnline " + lelinkServiceInfo.getName() + " " + lelinkServiceInfo.getIp() + " dlna is offline, browse again");
                        if (BrowseResultOnlineCheck.this.mHandler != null) {
                            BrowseResultOnlineCheck.this.mHandler.obtainMessage(3, (Object)lelinkServiceInfo).sendToTarget();
                        }
                        return;
                    }
                    if (BrowseResultOnlineCheck.this.mHandler != null) {
                        BrowseResultOnlineCheck.this.mHandler.obtainMessage(4, n2, n3, (Object)lelinkServiceInfo).sendToTarget();
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(BrowseResultOnlineCheck.TAG, exception);
                }
            }
        }, null);
    }

    public void release() {
        SourceLog.i(TAG, "release");
    }
}

