/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Routines;
import com.hpplay.component.protocol.srp6.XRoutine;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;

public class SRP6VerifierGenerator {
    protected final SRP6Routines srp6Routines;
    private SRP6CryptoParams config;
    private XRoutine xRoutine = null;

    public SRP6VerifierGenerator(SRP6CryptoParams sRP6CryptoParams) {
        this(sRP6CryptoParams, new SRP6Routines());
    }

    public SRP6VerifierGenerator(SRP6CryptoParams sRP6CryptoParams, SRP6Routines sRP6Routines) {
        if (sRP6CryptoParams == null) {
            throw new IllegalArgumentException("The SRP-6a crypto parameters must not be null");
        }
        this.config = sRP6CryptoParams;
        this.srp6Routines = sRP6Routines;
    }

    public byte[] generateRandomSalt(int n2) {
        return this.srp6Routines.generateRandomSalt(n2);
    }

    public byte[] generateRandomSalt(int n2, SecureRandom secureRandom) {
        return this.srp6Routines.generateRandomSalt(n2, secureRandom);
    }

    public byte[] generateRandomSalt() {
        return this.srp6Routines.generateRandomSalt(16);
    }

    public void setXRoutine(XRoutine xRoutine) {
        this.xRoutine = xRoutine;
    }

    public XRoutine getXRoutine() {
        return this.xRoutine;
    }

    public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            throw new IllegalArgumentException("The salt 's' must not be null");
        }
        if (byArray3 == null) {
            throw new IllegalArgumentException("The password 'P' must not be null");
        }
        BigInteger bigInteger = this.xRoutine != null ? this.xRoutine.computeX(this.config.getMessageDigestInstance(), byArray, byArray2, byArray3) : this.srp6Routines.computeX(this.config.getMessageDigestInstance(), byArray, byArray3);
        return this.srp6Routines.computeVerifier(this.config.N, this.config.g, bigInteger);
    }

    public BigInteger generateVerifier(BigInteger bigInteger, String string, String string2) {
        byte[] byArray = null;
        if (string != null) {
            byArray = string.getBytes(Charset.forName("UTF-8"));
        }
        byte[] byArray2 = string2.getBytes(Charset.forName("UTF-8"));
        byte[] byArray3 = BigIntegerUtils.bigIntegerToBytes(bigInteger);
        return this.generateVerifier(byArray3, byArray, byArray2);
    }

    public BigInteger generateVerifier(byte[] byArray, byte[] byArray2) {
        return this.generateVerifier(byArray, null, byArray2);
    }

    public BigInteger generateVerifier(BigInteger bigInteger, String string) {
        return this.generateVerifier(bigInteger, null, string);
    }
}

