/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.server;

import android.text.TextUtils;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.protocol.server.IRequestHandler;
import com.hpplay.component.protocol.server.IRequstManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;

public class RequestHandler
implements IRequestHandler,
Runnable {
    private String TAG = "RequestHandler";
    private static final String KEY_HEADER_EVENT = "POST /heart";
    private static final String KEY_HEADER_HARDBET = "POST /event";
    private static final String KEY_HEADER_PHOTO_STATE = "POST /photo";
    private final InputStream mInputStream;
    private final Socket mAcceptSocket;
    private IMirrorStateListener mLelinkMirrorListener;
    private IRequstManager mRequstManager;
    private String mDeviceIp;
    private static final String STATE = "state";
    private static final String REASON = "reason";
    private static final String STOPPED = "stopped";
    private static final String ERROR = "error";
    private static final String USER_STOPED = "user_stopped";
    private static final String FORCE_STOPED = "force_stopped";
    private static final String PREEMPT_STOPED = "preempt_stopped";
    private static final String SERVER_STOPED = "server_force_stopped";
    private static final String MIRROR_MODE = "mirrormode";

    public RequestHandler(IRequstManager iRequstManager, IMirrorStateListener iMirrorStateListener, InputStream inputStream, Socket socket) {
        this.mInputStream = inputStream;
        this.mAcceptSocket = socket;
        this.mLelinkMirrorListener = iMirrorStateListener;
        this.mRequstManager = iRequstManager;
        this.mDeviceIp = this.mAcceptSocket.getInetAddress().getHostAddress();
    }

    @Override
    public void close() {
        if (this.mInputStream != null) {
            try {
                this.mInputStream.close();
            }
            catch (IOException iOException) {
                CLog.w(this.TAG, iOException);
            }
        }
        if (this.mAcceptSocket != null) {
            try {
                this.mAcceptSocket.close();
            }
            catch (IOException iOException) {
                CLog.w(this.TAG, iOException);
            }
        }
        if (this.mRequstManager != null) {
            this.mRequstManager.closed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OutputStream outputStream = this.mAcceptSocket.getOutputStream();
            byte[] byArray = new byte[11];
            int n2 = 0;
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            boolean bl = false;
            while (!this.mAcceptSocket.isClosed()) {
                int n3;
                int n4;
                Object object;
                try {
                    n2 = this.mInputStream.read(byArray);
                }
                catch (Exception exception) {
                    CLog.w(this.TAG, exception);
                }
                if (n2 <= 0) continue;
                if (byArray.length == 1) {
                    arrayList.add(byArray[0]);
                    if (!ProtocolUtils.getProtocolDivide(arrayList)) continue;
                    object = new byte[arrayList.size()];
                    for (int i2 = 0; i2 < ((byte[])object).length; ++i2) {
                        object[i2] = arrayList.get(i2);
                    }
                    String string = new String((byte[])object);
                    CLog.d("header", "" + string);
                    try {
                        n4 = ProtocolUtils.getContentLength(string);
                        CLog.d(this.TAG, "contentLength" + n4 + "");
                        if (n4 > 0 && n4 < 0x200000) {
                            byArray = new byte[n4];
                            arrayList.clear();
                            continue;
                        }
                        byArray = new byte[11];
                        arrayList.clear();
                    }
                    catch (Exception exception) {
                        CLog.w(this.TAG, exception);
                        byArray = new byte[11];
                    }
                    continue;
                }
                if (byArray.length == 11 && !bl) {
                    try {
                        arrayList.clear();
                        object = new String(byArray, 0, byArray.length);
                        if (object.equals(KEY_HEADER_EVENT) || object.equals(KEY_HEADER_HARDBET) || object.equals(KEY_HEADER_PHOTO_STATE)) {
                            for (n3 = 0; n3 < byArray.length; ++n3) {
                                arrayList.add(byArray[n3]);
                            }
                        }
                        CLog.d(this.TAG, (String)object);
                        continue;
                    }
                    catch (Exception exception) {
                        CLog.w(this.TAG, exception);
                        continue;
                    }
                    finally {
                        byArray = new byte[1];
                        continue;
                    }
                }
                bl = false;
                arrayList.clear();
                try {
                    if (n2 < byArray.length) {
                        CLog.d(this.TAG, "---------------------->" + byArray.length + "  ----------------   " + n2);
                        object = new byte[n2];
                        System.arraycopy(byArray, 0, object, 0, n2);
                        arrayList2.add((byte[])object);
                        n3 = byArray.length - n2;
                        byArray = new byte[n3];
                        if (n3 != 11) continue;
                        bl = true;
                        continue;
                    }
                    int n5 = n2;
                    for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                        n5 += ((byte[])arrayList2.get(i3)).length;
                    }
                    byte[] byArray2 = new byte[n5];
                    n4 = 0;
                    for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
                        System.arraycopy(arrayList2.get(i4), 0, byArray2, n4, ((byte[])arrayList2.get(i4)).length);
                        n4 += ((byte[])arrayList2.get(i4)).length;
                    }
                    System.arraycopy(byArray, 0, byArray2, n4, n2);
                    String string = new String(byArray2, 0, n5);
                    CLog.i(this.TAG, string);
                    this.parseMirrorEvent(string);
                    String string2 = "HTTP/1.1 200 OK";
                    outputStream.write(string2.getBytes());
                    outputStream.close();
                    break;
                }
                catch (Exception exception) {
                    CLog.w(this.TAG, exception);
                    byArray = new byte[11];
                    arrayList2.clear();
                }
            }
        }
        catch (Exception exception) {
            CLog.w(this.TAG, exception);
        }
        finally {
            this.close();
        }
    }

    private void parseMirrorEvent(String string) {
        block15: {
            NSDictionary nSDictionary;
            block16: {
                String string2;
                CLog.i(this.TAG, "------>" + string);
                if (this.mLelinkMirrorListener == null) break block15;
                try {
                    nSDictionary = (NSDictionary)PropertyListParser.parse(string.getBytes());
                }
                catch (Exception exception) {
                    CLog.w(this.TAG, exception);
                    return;
                }
                if (nSDictionary == null) break block15;
                if (!nSDictionary.containsKey(STATE)) break block16;
                switch (string2 = nSDictionary.objectForKey(STATE).toString()) {
                    case "stopped": {
                        if (!nSDictionary.containsKey(REASON)) break;
                        String string3 = nSDictionary.objectForKey(REASON).toString();
                        if (TextUtils.equals((CharSequence)string3, (CharSequence)FORCE_STOPED)) {
                            this.mLelinkMirrorListener.onSinkStop(this.mDeviceIp, 120105104);
                            break;
                        }
                        if (TextUtils.equals((CharSequence)string3, (CharSequence)PREEMPT_STOPED)) {
                            this.mLelinkMirrorListener.onSinkStop(this.mDeviceIp, 120105103);
                            break;
                        }
                        if (TextUtils.equals((CharSequence)string3, (CharSequence)SERVER_STOPED)) {
                            this.mLelinkMirrorListener.onSinkStop(this.mDeviceIp, 120105105);
                            break;
                        }
                        break block15;
                    }
                    case "error": {
                        CLog.d(this.TAG, "ERROR");
                    }
                }
                break block15;
            }
            if (nSDictionary.containsKey(MIRROR_MODE)) {
                String string4 = nSDictionary.objectForKey(MIRROR_MODE).toString();
                if (this.mLelinkMirrorListener != null) {
                    this.mLelinkMirrorListener.onMirrorModeCallback(string4);
                }
            }
        }
    }
}

