/*
 * Decompiled with CFR 0.152.
 */
package com.slambb.myuvc;

import android.hardware.usb.UsbDevice;
import android.util.Log;
import com.herohan.uvcapp.CameraHelper;
import com.herohan.uvcapp.ICameraHelper;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.UVCControl;
import com.slambb.myuvc.UVCCtrl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MyUVCManager {
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANSFORM_ROTATE_90 = 1;
    public static final int TRANSFORM_ROTATE_180 = 2;
    public static final int TRANSFORM_ROTATE_270 = 4;
    public static final int TRANSFORM_MIRROR_HORIZONTAL = 8;
    public static final int TRANSFORM_MIRROR_VERTICAL = 16;
    private static final int MIN_FRAME_INTERVAL_MS = 33;
    private long mLastFrameTimeMs = 0L;
    private int mDroppedFrameCount = 0;
    private static final String TAG = "MyUVCManager";
    private static final boolean DEBUG = true;
    public CameraHelper mCameraHelper;
    protected Boolean mIsPreviewing = false;
    protected int mPreviewPixelFormat = 3;
    protected int mPreviewWidth = 640;
    protected int mPreviewHeight = 480;
    protected int mFormat = 7;
    private int mPreviewRotation = 0;
    List<UVCCtrl> uvcCtrlList = new ArrayList<UVCCtrl>();
    protected UVCControl mControl;
    protected int currentRotateTransform = 0;
    protected int currentMIRRORTransform = 0;
    protected boolean bSaveTempBrightness = false;
    protected boolean bSaveTempContrast = false;
    protected int tempBrightness = 0;
    protected int tempContrast = 0;
    protected boolean bInit = false;
    private final ICameraHelper.StateCallback mStateListener = new ICameraHelper.StateCallback(){

        @Override
        public void onAttach(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onAttach:");
            MyUVCManager.this.selectDevice(device);
        }

        @Override
        public void onDeviceOpen(UsbDevice device, boolean isFirstOpen) {
            Size size = new Size(MyUVCManager.this.mFormat, MyUVCManager.this.mPreviewWidth, MyUVCManager.this.mPreviewHeight, 30, new ArrayList<Integer>());
            Log.v((String)MyUVCManager.TAG, (String)("onDeviceOpen:" + size.toString()));
            MyUVCManager.this.mCameraHelper.openCamera(size);
        }

        @Override
        public void onCameraOpen(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onCameraOpen:");
            MyUVCManager.this.mCameraHelper.startPreview();
            if (MyUVCManager.this.mControl == null) {
                MyUVCManager.this.mControl = MyUVCManager.this.mCameraHelper.getUVCControl();
                MyUVCManager.this.mControl.setContrastAuto(false);
                MyUVCManager.this.Log("\u521d\u59cb\u5316Control\u3002");
                if (MyUVCManager.this.bSaveTempBrightness) {
                    MyUVCManager.this.mControl.setBrightness(MyUVCManager.this.tempBrightness);
                }
                if (MyUVCManager.this.bSaveTempContrast) {
                    MyUVCManager.this.mControl.setContrast(MyUVCManager.this.tempContrast);
                }
            }
            MyUVCManager.this.mLastFrameTimeMs = 0L;
            MyUVCManager.this.mDroppedFrameCount = 0;
            MyUVCManager.this.mCameraHelper.setFrameCallback(frame -> {
                long currentTimeMs = System.currentTimeMillis();
                if (currentTimeMs - MyUVCManager.this.mLastFrameTimeMs < 33L) {
                    MyUVCManager.this.mDroppedFrameCount++;
                    if (MyUVCManager.this.mDroppedFrameCount % 100 == 0) {
                        Log.d((String)MyUVCManager.TAG, (String)("Frame rate limiting: dropped " + MyUVCManager.this.mDroppedFrameCount + " frames"));
                    }
                    return;
                }
                MyUVCManager.this.mLastFrameTimeMs = currentTimeMs;
                int transform = MyUVCManager.this.currentRotateTransform | MyUVCManager.this.currentMIRRORTransform;
                MyUVCManager.ProcessBuffer(frame, MyUVCManager.this.mPreviewWidth, MyUVCManager.this.mPreviewHeight, frame.capacity(), MyUVCManager.this.mPreviewPixelFormat, transform);
            }, MyUVCManager.this.mPreviewPixelFormat);
            MyUVCManager.this.Log("onCameraOpen " + MyUVCManager.this.mPreviewWidth + "x" + MyUVCManager.this.mPreviewHeight + " format : " + MyUVCManager.this.mPreviewPixelFormat);
            MyUVCManager.this.mIsPreviewing = true;
        }

        @Override
        public void onCameraClose(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onCameraClose:");
            MyUVCManager.this.mIsPreviewing = false;
            if (MyUVCManager.this.mControl != null) {
                MyUVCManager.this.mControl = null;
                MyUVCManager.this.uvcCtrlList.clear();
            }
            if (MyUVCManager.this.mDroppedFrameCount > 0) {
                Log.d((String)MyUVCManager.TAG, (String)("Total dropped frames: " + MyUVCManager.this.mDroppedFrameCount));
            }
        }

        @Override
        public void onDeviceClose(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onDeviceClose:");
        }

        @Override
        public void onDetach(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onDetach:");
        }

        @Override
        public void onCancel(UsbDevice device) {
            Log.v((String)MyUVCManager.TAG, (String)"onCancel:");
        }
    };

    MyUVCManager() {
    }

    static native void ProcessBuffer(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5);

    private void selectDevice(UsbDevice device) {
        Log.v((String)TAG, (String)("selectDevice:device=" + device.getDeviceName()));
        this.mCameraHelper.selectDevice(device);
    }

    public void initCameraHelper(int width, int height, String format, String mirror) {
        if (width != 0) {
            this.mPreviewWidth = width;
        }
        if (height != 0) {
            this.mPreviewHeight = height;
        }
        switch (format) {
            case "MJPEG": {
                this.mFormat = 7;
                break;
            }
            case "YUV": {
                this.mFormat = 5;
            }
        }
        switch (mirror) {
            case "NONE": {
                this.currentMIRRORTransform = 0;
                break;
            }
            case "HORIZONTAL": {
                this.currentMIRRORTransform = 8;
                break;
            }
            case "VERTICAL": {
                this.currentMIRRORTransform = 16;
            }
        }
        Log.d((String)TAG, (String)("initCameraHelper:width=" + this.mPreviewWidth + ",height:" + this.mPreviewHeight + ",mFormat:" + this.mFormat + ",MIRROR:" + this.currentMIRRORTransform));
        if (this.mCameraHelper == null) {
            this.mCameraHelper = new CameraHelper();
            this.mCameraHelper.setStateCallback(this.mStateListener);
        }
    }

    public void clearCameraHelper() {
        Log.d((String)TAG, (String)"clearCameraHelper:");
        if (this.mCameraHelper != null) {
            this.mCameraHelper.release();
            this.mCameraHelper = null;
        }
    }

    public void OpenCamera() {
        List<UsbDevice> list;
        Log.d((String)TAG, (String)"openCamera:");
        if (this.mCameraHelper != null && (list = this.mCameraHelper.getDeviceList()) != null && list.size() > 0) {
            this.mCameraHelper.selectDevice(list.get(0));
        }
    }

    public void CloseCamera() {
        Log.d((String)TAG, (String)"closeCamera:");
        if (this.mCameraHelper != null) {
            this.mCameraHelper.closeCamera();
        }
    }

    public void ChangeCameraInfo(int width, int height, String format) {
        Log.d((String)TAG, (String)("ChangeCameraInfo (int width,int height, String format):" + format));
        if (this.mCameraHelper != null && this.mCameraHelper.isCameraOpened()) {
            Size size = this.mCameraHelper.getPreviewSize();
            switch (format) {
                case "MJPEG": {
                    size.type = 7;
                    this.mFormat = 7;
                    break;
                }
                case "YUV": {
                    size.type = 5;
                    this.mFormat = 5;
                }
            }
            this.mPreviewWidth = size.width = width;
            this.mPreviewHeight = size.height = height;
            this.mIsPreviewing = false;
            this.mCameraHelper.stopPreview();
            this.mCameraHelper.setPreviewSize(size);
            this.mCameraHelper.startPreview();
            this.mIsPreviewing = true;
        }
    }

    public String[] GetSupportedResolutions() {
        Log.d((String)TAG, (String)"GetSupportedResolutions called");
        Log.d((String)TAG, (String)"GetSupportedResolutions:");
        if (this.mCameraHelper != null && this.mCameraHelper.isCameraOpened()) {
            List<Size> sizes = this.mCameraHelper.getSupportedSizeList();
            HashSet<Size> uniqueSizes = new HashSet<Size>(sizes);
            ArrayList<Size> sortedSizes = new ArrayList<Size>(uniqueSizes);
            Collections.sort(sortedSizes, new Comparator<Size>(){

                @Override
                public int compare(Size s1, Size s2) {
                    int widthComparison = Integer.compare(s2.width, s1.width);
                    if (widthComparison != 0) {
                        return widthComparison;
                    }
                    return Integer.compare(s2.height, s1.height);
                }
            });
            ArrayList<String> sizeList = new ArrayList<String>();
            for (Size size : sortedSizes) {
                if (this.mFormat != size.type) continue;
                Log.i((String)TAG, (String)("GetSupportedResolutions: type" + size.type + ",size" + size.width + "x" + size.height));
                sizeList.add(size.width + "x" + size.height);
            }
            return sizeList.toArray(new String[0]);
        }
        return new String[0];
    }

    public int GetIsPreviewing() {
        if (this.mIsPreviewing.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void FlipHorizontally() {
        if (this.mCameraHelper != null) {
            this.currentMIRRORTransform = 8;
        }
    }

    public void FlipVertically() {
        if (this.mCameraHelper != null) {
            this.currentMIRRORTransform = 16;
        }
    }

    public void ResetTransform() {
        this.currentRotateTransform = 0;
        this.currentMIRRORTransform = 0;
    }

    void setUvcCtrlList() {
        this.uvcCtrlList.clear();
        this.uvcCtrlList.add(new UVCCtrl("PU_BRIGHTNESS", false, this.mControl.isBrightnessEnable(), this.mControl.updateBrightnessLimit(), this.mControl.getBrightness()));
        this.uvcCtrlList.add(new UVCCtrl("PU_CONTRAST", this.mControl.isContrastAutoEnable(), this.mControl.isContrastEnable(), this.mControl.updateContrastLimit(), this.mControl.getContrast()));
    }

    public String GetUvcCtrlList() {
        JSONArray jsonArray = new JSONArray();
        try {
            this.setUvcCtrlList();
            for (UVCCtrl uvcCtrl : this.uvcCtrlList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)uvcCtrl.getName());
                jsonObject.put("isAuto", uvcCtrl.getIsAuto());
                jsonObject.put("isEnable", uvcCtrl.getIsEnable());
                JSONArray limitArray = new JSONArray();
                for (int limit : uvcCtrl.getLimit()) {
                    limitArray.put(limit);
                }
                jsonObject.put("limit", (Object)limitArray);
                jsonObject.put("value", uvcCtrl.getValue());
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("GetUvcCtrlList:" + jsonArray.toString()));
        return jsonArray.toString();
    }

    public void SetBrightness(int value) {
        if (this.mCameraHelper != null) {
            this.bSaveTempBrightness = true;
            this.tempBrightness = value;
            this.mControl.setBrightness(value);
        }
    }

    public void SetContrast(int value) {
        if (this.mCameraHelper != null) {
            this.bSaveTempContrast = true;
            this.tempContrast = value;
            this.mControl.setContrast(value);
        }
    }

    public void resetControlParams() {
        if (this.mControl == null) {
            return;
        }
        this.mControl.resetBrightness();
        this.mControl.resetContrast();
        this.mControl.resetContrastAuto();
    }

    public void resetAllControlParams(UVCControl control) {
        control.resetBrightness();
        control.resetContrast();
        control.resetContrastAuto();
        control.resetHue();
        control.resetHueAuto();
        control.resetSaturation();
        control.resetSharpness();
        control.resetGamma();
        control.resetWhiteBalance();
        control.resetWhiteBalanceAuto();
        control.resetBacklightComp();
        control.resetGain();
        control.resetExposureTimeAbsolute();
        control.resetAutoExposureMode();
        control.resetIrisAbsolute();
        control.resetFocusAbsolute();
        control.resetFocusAuto();
        control.resetZoomAbsolute();
        control.resetPanAbsolute();
        control.resetTiltAbsolute();
        control.resetRollAbsolute();
        control.resetPowerlineFrequency();
    }

    public void Log(String log) {
        Log.d((String)"Unity : ", (String)("UVCCameraInterface -> " + log));
    }

    static {
        System.loadLibrary("TransferTexture");
    }
}

