/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.USBVendorId;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.uvccamera.BuildConfig;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class USBMonitor {
    private static final boolean DEBUG = BuildConfig.DEBUG;
    private static final String TAG = USBMonitor.class.getSimpleName();
    public static int USB_OPEN_ERROR_UNKNOWN = 1;
    private static final int CHECK_DEVICE_RUNNABLE_DELAY = 150;
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    private final HashMap<UsbDevice, UsbControlBlock> mOpenedCtrlBlocks = new HashMap();
    private HashSet<String> mHasPermissionDeviceKeys = new HashSet();
    private HashSet<String> mDetectedDeviceKeys = new HashSet();
    private final WeakReference<Context> mWeakContext;
    private final UsbManager mUsbManager;
    private final OnDeviceConnectListener mOnDeviceConnectListener;
    private PendingIntent mPermissionIntent = null;
    private List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    private final Handler mListenerHandler;
    private final Handler mAsyncHandler;
    private volatile boolean mDestroyed;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            USBMonitor.this.mAsyncHandler.post(() -> {
                UsbDevice device;
                if (USBMonitor.this.mDestroyed) {
                    return;
                }
                String action = intent.getAction();
                if (USBMonitor.this.ACTION_USB_PERMISSION.equals(action)) {
                    USBMonitor uSBMonitor = USBMonitor.this;
                    synchronized (uSBMonitor) {
                        UsbDevice device2 = USBMonitor.this.getExtraDevice(intent);
                        if (device2 != null) {
                            if (intent.getBooleanExtra("permission", false)) {
                                USBMonitor.this.processOpenDevice(device2);
                            } else {
                                USBMonitor.this.processCancel(device2);
                            }
                        }
                    }
                }
                if (USBMonitor.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                    UsbDevice device3 = USBMonitor.this.getExtraDevice(intent);
                    if (device3 != null) {
                        USBMonitor.this.updateDeviceKeys(device3, USBMonitor.this.hasPermission(device3));
                        USBMonitor.this.processAttach(device3);
                    }
                } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = USBMonitor.this.getExtraDevice(intent)) != null) {
                    HashMap hashMap = USBMonitor.this.mOpenedCtrlBlocks;
                    synchronized (hashMap) {
                        UsbControlBlock ctrlBlock = (UsbControlBlock)USBMonitor.this.mOpenedCtrlBlocks.remove(device);
                        if (ctrlBlock != null) {
                            ctrlBlock.close();
                        }
                    }
                    USBMonitor.this.processDetach(device);
                }
            });
        }
    };
    private final Runnable mDeviceCheckRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (USBMonitor.this.mDestroyed) {
                return;
            }
            List<UsbDevice> devices = USBMonitor.this.getDeviceList();
            HashSet<UsbDevice> needNotifyDevices = new HashSet<UsbDevice>();
            2 var3_3 = this;
            synchronized (var3_3) {
                HashSet oldHasPermissionKeys = USBMonitor.this.mHasPermissionDeviceKeys;
                HashSet oldDetectedKeys = USBMonitor.this.mDetectedDeviceKeys;
                USBMonitor.this.mHasPermissionDeviceKeys = new HashSet();
                USBMonitor.this.mDetectedDeviceKeys = new HashSet();
                for (UsbDevice device : devices) {
                    boolean hasPermission = USBMonitor.this.hasPermission(device);
                    String deviceKey = USBMonitor.getDeviceKey(device);
                    if (!oldDetectedKeys.contains(deviceKey) || hasPermission && !oldHasPermissionKeys.contains(deviceKey)) {
                        needNotifyDevices.add(device);
                    }
                    USBMonitor.this.updateDeviceKeys(deviceKey, hasPermission);
                }
            }
            if (USBMonitor.this.mOnDeviceConnectListener != null && needNotifyDevices.size() > 0) {
                USBMonitor.this.mListenerHandler.post(() -> {
                    for (UsbDevice device : needNotifyDevices) {
                        if (DEBUG) {
                            Log.d((String)TAG, (String)("DeviceCheckRunnable onAttach:device=" + device.getDeviceName()));
                        }
                        USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                    }
                });
            }
            USBMonitor.this.mAsyncHandler.postDelayed((Runnable)this, 150L);
        }
    };
    private static final int USB_DIR_OUT = 0;
    private static final int USB_DIR_IN = 128;
    private static final int USB_TYPE_MASK = 96;
    private static final int USB_TYPE_STANDARD = 0;
    private static final int USB_TYPE_CLASS = 32;
    private static final int USB_TYPE_VENDOR = 64;
    private static final int USB_TYPE_RESERVED = 96;
    private static final int USB_RECIP_MASK = 31;
    private static final int USB_RECIP_DEVICE = 0;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_RECIP_ENDPOINT = 2;
    private static final int USB_RECIP_OTHER = 3;
    private static final int USB_RECIP_PORT = 4;
    private static final int USB_RECIP_RPIPE = 5;
    private static final int USB_REQ_GET_STATUS = 0;
    private static final int USB_REQ_CLEAR_FEATURE = 1;
    private static final int USB_REQ_SET_FEATURE = 3;
    private static final int USB_REQ_SET_ADDRESS = 5;
    private static final int USB_REQ_GET_DESCRIPTOR = 6;
    private static final int USB_REQ_SET_DESCRIPTOR = 7;
    private static final int USB_REQ_GET_CONFIGURATION = 8;
    private static final int USB_REQ_SET_CONFIGURATION = 9;
    private static final int USB_REQ_GET_INTERFACE = 10;
    private static final int USB_REQ_SET_INTERFACE = 11;
    private static final int USB_REQ_SYNCH_FRAME = 12;
    private static final int USB_REQ_SET_SEL = 48;
    private static final int USB_REQ_SET_ISOCH_DELAY = 49;
    private static final int USB_REQ_SET_ENCRYPTION = 13;
    private static final int USB_REQ_GET_ENCRYPTION = 14;
    private static final int USB_REQ_RPIPE_ABORT = 14;
    private static final int USB_REQ_SET_HANDSHAKE = 15;
    private static final int USB_REQ_RPIPE_RESET = 15;
    private static final int USB_REQ_GET_HANDSHAKE = 16;
    private static final int USB_REQ_SET_CONNECTION = 17;
    private static final int USB_REQ_SET_SECURITY_DATA = 18;
    private static final int USB_REQ_GET_SECURITY_DATA = 19;
    private static final int USB_REQ_SET_WUSB_DATA = 20;
    private static final int USB_REQ_LOOPBACK_DATA_WRITE = 21;
    private static final int USB_REQ_LOOPBACK_DATA_READ = 22;
    private static final int USB_REQ_SET_INTERFACE_DS = 23;
    private static final int USB_REQ_STANDARD_DEVICE_SET = 0;
    private static final int USB_REQ_STANDARD_DEVICE_GET = 128;
    private static final int USB_REQ_STANDARD_INTERFACE_SET = 1;
    private static final int USB_REQ_STANDARD_INTERFACE_GET = 129;
    private static final int USB_REQ_STANDARD_ENDPOINT_SET = 2;
    private static final int USB_REQ_STANDARD_ENDPOINT_GET = 130;
    private static final int USB_REQ_CS_DEVICE_SET = 32;
    private static final int USB_REQ_CS_DEVICE_GET = 160;
    private static final int USB_REQ_CS_INTERFACE_SET = 33;
    private static final int USB_REQ_CS_INTERFACE_GET = 161;
    private static final int USB_REQ_CS_ENDPOINT_SET = 34;
    private static final int USB_REQ_CS_ENDPOINT_GET = 162;
    private static final int USB_REQ_VENDER_DEVICE_SET = 32;
    private static final int USB_REQ_VENDER_DEVICE_GET = 160;
    private static final int USB_REQ_VENDER_INTERFACE_SET = 33;
    private static final int USB_REQ_VENDER_INTERFACE_GET = 161;
    private static final int USB_REQ_VENDER_ENDPOINT_SET = 34;
    private static final int USB_REQ_VENDER_ENDPOINT_GET = 162;
    private static final int USB_DT_DEVICE = 1;
    private static final int USB_DT_CONFIG = 2;
    private static final int USB_DT_STRING = 3;
    private static final int USB_DT_INTERFACE = 4;
    private static final int USB_DT_ENDPOINT = 5;
    private static final int USB_DT_DEVICE_QUALIFIER = 6;
    private static final int USB_DT_OTHER_SPEED_CONFIG = 7;
    private static final int USB_DT_INTERFACE_POWER = 8;
    private static final int USB_DT_OTG = 9;
    private static final int USB_DT_DEBUG = 10;
    private static final int USB_DT_INTERFACE_ASSOCIATION = 11;
    private static final int USB_DT_SECURITY = 12;
    private static final int USB_DT_KEY = 13;
    private static final int USB_DT_ENCRYPTION_TYPE = 14;
    private static final int USB_DT_BOS = 15;
    private static final int USB_DT_DEVICE_CAPABILITY = 16;
    private static final int USB_DT_WIRELESS_ENDPOINT_COMP = 17;
    private static final int USB_DT_WIRE_ADAPTER = 33;
    private static final int USB_DT_RPIPE = 34;
    private static final int USB_DT_CS_RADIO_CONTROL = 35;
    private static final int USB_DT_PIPE_USAGE = 36;
    private static final int USB_DT_SS_ENDPOINT_COMP = 48;
    private static final int USB_DT_CS_DEVICE = 33;
    private static final int USB_DT_CS_CONFIG = 34;
    private static final int USB_DT_CS_STRING = 35;
    private static final int USB_DT_CS_INTERFACE = 36;
    private static final int USB_DT_CS_ENDPOINT = 37;
    private static final int USB_DT_DEVICE_SIZE = 18;

    public USBMonitor(Context context, OnDeviceConnectListener listener, Handler handler) {
        if (DEBUG) {
            Log.v((String)TAG, (String)"USBMonitor:Constructor");
        }
        if (listener == null) {
            throw new IllegalArgumentException("OnDeviceConnectListener should not null.");
        }
        this.mWeakContext = new WeakReference<Context>(context);
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mOnDeviceConnectListener = listener;
        this.mListenerHandler = handler;
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.mDestroyed = false;
        if (DEBUG) {
            Log.v((String)TAG, (String)("USBMonitor:mUsbManager=" + this.mUsbManager));
        }
    }

    public USBMonitor(Context context, OnDeviceConnectListener listener) {
        this(context, listener, new Handler(Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (DEBUG) {
            Log.i((String)TAG, (String)"destroy:");
        }
        this.unregister();
        if (!this.mDestroyed) {
            this.mDestroyed = true;
            HashMap<UsbDevice, UsbControlBlock> hashMap = this.mOpenedCtrlBlocks;
            synchronized (hashMap) {
                Set<UsbDevice> keys = this.mOpenedCtrlBlocks.keySet();
                if (keys != null) {
                    try {
                        for (UsbDevice key : keys) {
                            UsbControlBlock ctrlBlock = this.mOpenedCtrlBlocks.remove(key);
                            if (ctrlBlock == null) continue;
                            ctrlBlock.close();
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"destroy:", (Throwable)e);
                    }
                }
                this.mOpenedCtrlBlocks.clear();
            }
            try {
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"destroy:", (Throwable)e);
            }
        }
    }

    public synchronized void register() {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"register: already destroyed");
            return;
        }
        if (DEBUG) {
            Log.i((String)TAG, (String)"111 mPermissionIntent:");
        }
        if (this.mPermissionIntent == null) {
            Context context;
            if (DEBUG) {
                Log.i((String)TAG, (String)"register:");
            }
            if ((context = (Context)this.mWeakContext.get()) != null) {
                int flags = 0;
                if (Build.VERSION.SDK_INT >= 34) {
                    flags = 0x3000000;
                } else if (Build.VERSION.SDK_INT >= 31) {
                    flags = 0x2000000;
                }
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)flags);
                IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                if (Build.VERSION.SDK_INT >= 33) {
                    context.registerReceiver(this.mUsbReceiver, filter, 2);
                } else {
                    context.registerReceiver(this.mUsbReceiver, filter);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("\u6ce8\u518c\u65f6\u5019\uff1amPermissionIntent" + this.mPermissionIntent.toString()));
                }
            }
            this.mDetectedDeviceKeys.clear();
            this.mAsyncHandler.postDelayed(this.mDeviceCheckRunnable, 150L);
        }
    }

    public synchronized void unregister() {
        this.mDetectedDeviceKeys.clear();
        if (!this.mDestroyed) {
            this.mAsyncHandler.removeCallbacks(this.mDeviceCheckRunnable);
        }
        if (this.mPermissionIntent != null) {
            Context context = (Context)this.mWeakContext.get();
            try {
                if (context != null) {
                    context.unregisterReceiver(this.mUsbReceiver);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mPermissionIntent = null;
        }
    }

    public synchronized boolean isRegistered() {
        return !this.mDestroyed && this.mPermissionIntent != null;
    }

    public void setDeviceFilter(DeviceFilter filter) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"setDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.add(filter);
    }

    public void addDeviceFilter(DeviceFilter filter) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"addDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.add(filter);
    }

    public void removeDeviceFilter(DeviceFilter filter) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"removeDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.remove(filter);
    }

    public void setDeviceFilter(List<DeviceFilter> filters) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"setDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.addAll(filters);
    }

    public void addDeviceFilter(List<DeviceFilter> filters) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"addDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.addAll(filters);
    }

    public void removeDeviceFilter(List<DeviceFilter> filters) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"removeDeviceFilter: already destroyed");
            return;
        }
        this.mDeviceFilters.removeAll(filters);
    }

    public boolean isAvailableDevice(UsbDevice device) {
        if (device == null) {
            return false;
        }
        if (this.mDeviceFilters == null || this.mDeviceFilters.isEmpty()) {
            return true;
        }
        for (DeviceFilter filter : this.mDeviceFilters) {
            if (filter == null || !filter.matches(device)) continue;
            return !filter.isExclude;
        }
        return false;
    }

    public int getDeviceCount() {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"getDeviceCount: already destroyed");
            return 0;
        }
        return this.getDeviceList().size();
    }

    public List<UsbDevice> getDeviceList() {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"getDeviceList: already destroyed");
            return new ArrayList<UsbDevice>();
        }
        return this.getDeviceList(this.mDeviceFilters);
    }

    public List<UsbDevice> getDeviceList(List<DeviceFilter> filters) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"getDeviceList: already destroyed");
            return new ArrayList<UsbDevice>();
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            if (filters == null || filters.isEmpty()) {
                result.addAll(deviceList.values());
            } else {
                block0: for (UsbDevice device : deviceList.values()) {
                    for (DeviceFilter filter : filters) {
                        if (filter == null || !filter.matches(device)) continue;
                        if (filter.isExclude) continue block0;
                        result.add(device);
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public List<UsbDevice> getDeviceList(DeviceFilter filter) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"getDeviceList: already destroyed");
            return new ArrayList<UsbDevice>();
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                if (filter != null && (!filter.matches(device) || filter.isExclude)) continue;
                result.add(device);
            }
        }
        return result;
    }

    public Iterator<UsbDevice> getDevices() {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"getDevices: already destroyed");
            return null;
        }
        Iterator iterator = null;
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            iterator = list.values().iterator();
        }
        return iterator;
    }

    public final void dumpDevices() {
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            Set keys = list.keySet();
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device = (UsbDevice)list.get(key);
                    int num_interface = device != null ? device.getInterfaceCount() : 0;
                    sb.setLength(0);
                    for (int i = 0; i < num_interface; ++i) {
                        sb.append(String.format(Locale.US, "interface%d:%s", i, device.getInterface(i).toString()));
                    }
                    Log.i((String)TAG, (String)("key=" + key + ":" + device + ":" + sb.toString()));
                }
            } else {
                Log.i((String)TAG, (String)"no device");
            }
        } else {
            Log.i((String)TAG, (String)"no device");
        }
    }

    public boolean hasPermission(UsbDevice device) {
        if (this.mDestroyed) {
            Log.e((String)TAG, (String)"hasPermission: already destroyed");
            return false;
        }
        return device != null && this.mUsbManager.hasPermission(device);
    }

    private void updateDeviceKeys(UsbDevice device, boolean hasPermission) {
        String deviceKey = USBMonitor.getDeviceKey(device);
        this.updateDeviceKeys(deviceKey, hasPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceKeys(String deviceKey, boolean hasPermission) {
        USBMonitor uSBMonitor = this;
        synchronized (uSBMonitor) {
            this.mDetectedDeviceKeys.add(deviceKey);
            if (hasPermission) {
                this.mHasPermissionDeviceKeys.add(deviceKey);
            } else {
                this.mHasPermissionDeviceKeys.remove(deviceKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPermission(UsbDevice device) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("requestPermission:device=" + device.getDeviceName()));
        }
        Class<USBMonitor> clazz = USBMonitor.class;
        synchronized (USBMonitor.class) {
            if (this.isRegistered()) {
                if (device != null) {
                    if (this.mUsbManager.hasPermission(device)) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("requestPermission:mUsbManager.hasPermission=" + device.getDeviceName()));
                        }
                        this.processOpenDevice(device);
                    } else {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("\u8bf7\u6c42\u6743\u9650\uff1a" + this.mPermissionIntent.toString()));
                        }
                        try {
                            this.mUsbManager.requestPermission(device, this.mPermissionIntent);
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (Throwable)e);
                            this.processCancel(device);
                        }
                    }
                } else {
                    this.processCancel(device);
                }
            } else {
                this.processCancel(device);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private UsbDevice getExtraDevice(Intent intent) {
        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
        return this.isAvailableDevice(device) ? device : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOpenDevice(UsbDevice device) {
        boolean createNew;
        UsbControlBlock ctrlBlock;
        if (this.mDestroyed) {
            return;
        }
        this.updateDeviceKeys(device, true);
        if (DEBUG) {
            Log.v((String)TAG, (String)("processOpenDevice:device=" + device.getDeviceName()));
        }
        HashMap<UsbDevice, UsbControlBlock> hashMap = this.mOpenedCtrlBlocks;
        synchronized (hashMap) {
            if (!this.mOpenedCtrlBlocks.containsKey(device)) {
                ctrlBlock = new UsbControlBlock(this, device);
                try {
                    ctrlBlock.open();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                    if (this.mOnDeviceConnectListener != null) {
                        this.mListenerHandler.post(() -> {
                            USBException ex = e instanceof USBException ? (USBException)e : new USBException(USB_OPEN_ERROR_UNKNOWN, e.getLocalizedMessage());
                            this.mOnDeviceConnectListener.onError(device, ex);
                        });
                    }
                    return;
                }
                this.mOpenedCtrlBlocks.put(device, ctrlBlock);
                createNew = true;
            } else {
                ctrlBlock = this.mOpenedCtrlBlocks.get(device);
                createNew = false;
            }
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mListenerHandler.post(() -> this.mOnDeviceConnectListener.onDeviceOpen(device, ctrlBlock, createNew));
        }
    }

    private void processCancel(UsbDevice device) {
        if (this.mDestroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processCancel:");
        }
        this.updateDeviceKeys(device, false);
        if (this.mOnDeviceConnectListener != null) {
            this.mListenerHandler.post(() -> this.mOnDeviceConnectListener.onCancel(device));
        }
    }

    private void processAttach(UsbDevice device) {
        if (this.mDestroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processAttach:");
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mListenerHandler.post(() -> this.mOnDeviceConnectListener.onAttach(device));
        }
    }

    private void processDetach(UsbDevice device) {
        if (this.mDestroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processDetach:");
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mListenerHandler.post(() -> this.mOnDeviceConnectListener.onDetach(device));
        }
    }

    @SuppressLint(value={"NewApi"})
    public static String getDeviceKey(UsbDevice device) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getDeviceName());
        sb.append("#");
        sb.append(device.getVendorId());
        sb.append("#");
        sb.append(device.getProductId());
        sb.append("#");
        sb.append(device.getDeviceClass());
        sb.append("#");
        sb.append(device.getDeviceSubclass());
        sb.append("#");
        sb.append(device.getDeviceProtocol());
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append("#");
            if (Build.VERSION.SDK_INT < 29) {
                sb.append(device.getSerialNumber());
                sb.append("#");
            }
            sb.append(device.getManufacturerName());
            sb.append("#");
            sb.append(device.getConfigurationCount());
            sb.append("#");
            if (Build.VERSION.SDK_INT >= 23) {
                sb.append(device.getVersion());
                sb.append("#");
            }
        }
        return sb.toString();
    }

    public static String getProductKey(UsbDevice device) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId());
        sb.append("#");
        sb.append(device.getProductId());
        sb.append("#");
        sb.append(device.getDeviceClass());
        sb.append("#");
        sb.append(device.getDeviceSubclass());
        sb.append("#");
        sb.append(device.getDeviceProtocol());
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append("#");
            if (Build.VERSION.SDK_INT < 29) {
                sb.append(device.getSerialNumber());
                sb.append("#");
            }
            sb.append(device.getManufacturerName());
            sb.append("#");
            sb.append(device.getConfigurationCount());
            sb.append("#");
            if (Build.VERSION.SDK_INT >= 23) {
                sb.append(device.getVersion());
                sb.append("#");
            }
        }
        return sb.toString();
    }

    private static String getString(UsbDeviceConnection connection, int id2, int languageCount, byte[] languages) {
        byte[] work = new byte[256];
        String result = null;
        for (int i = 1; i <= languageCount; ++i) {
            int ret = connection.controlTransfer(128, 6, 0x300 | id2, (int)languages[i], work, 256, 0);
            if (ret <= 2 || work[0] != ret || work[1] != 3) continue;
            try {
                result = new String(work, 2, ret - 2, "UTF-16LE");
                if (!"\u0409".equals(result)) break;
                result = null;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public UsbDeviceInfo getDeviceInfo(UsbDevice device) {
        return USBMonitor.updateDeviceInfo(this.mUsbManager, device, null);
    }

    public static UsbDeviceInfo getDeviceInfo(Context context, UsbDevice device) {
        return USBMonitor.updateDeviceInfo((UsbManager)context.getSystemService("usb"), device, new UsbDeviceInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbDeviceInfo updateDeviceInfo(UsbManager manager, UsbDevice device, UsbDeviceInfo _info) {
        UsbDeviceInfo info = _info != null ? _info : new UsbDeviceInfo();
        info.clear();
        if (device != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                info.manufacturer = device.getManufacturerName();
                info.product = device.getProductName();
                if (Build.VERSION.SDK_INT < 29 || manager != null && manager.hasPermission(device)) {
                    info.serial = device.getSerialNumber();
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                info.usb_version = device.getVersion();
            }
            if (manager != null && manager.hasPermission(device)) {
                UsbDeviceConnection connection = null;
                try {
                    connection = manager.openDevice(device);
                    if (connection != null) {
                        byte[] desc = connection.getRawDescriptors();
                        if (TextUtils.isEmpty((CharSequence)info.usb_version) && desc != null) {
                            info.usb_version = String.format("%x.%02x", desc[3] & 0xFF, desc[2] & 0xFF);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.version) && desc != null) {
                            info.version = String.format("%x.%02x", desc[13] & 0xFF, desc[12] & 0xFF);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.serial)) {
                            info.serial = connection.getSerial();
                        }
                        byte[] languages = new byte[256];
                        int languageCount = 0;
                        int result = connection.controlTransfer(128, 6, 768, 0, languages, 256, 0);
                        if (result > 0) {
                            languageCount = (result - 2) / 2;
                        }
                        if (languageCount > 0 && desc != null) {
                            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                                info.manufacturer = USBMonitor.getString(connection, desc[14], languageCount, languages);
                            }
                            if (TextUtils.isEmpty((CharSequence)info.product)) {
                                info.product = USBMonitor.getString(connection, desc[15], languageCount, languages);
                            }
                            if (TextUtils.isEmpty((CharSequence)info.serial)) {
                                info.serial = USBMonitor.getString(connection, desc[16], languageCount, languages);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = USBVendorId.vendorName(device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = String.format("%04x", device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.product)) {
                info.product = String.format("%04x", device.getProductId());
            }
        }
        return info;
    }

    public static class USBException
    extends Exception {
        private int code;

        public USBException(int code, String message) {
            super(message);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class UsbControlBlock
    implements Cloneable {
        private final WeakReference<USBMonitor> mWeakMonitor;
        private final WeakReference<UsbDevice> mWeakDevice;
        protected UsbDeviceConnection mConnection;
        protected UsbDeviceInfo mInfo;
        private int mBusNum;
        private int mDevNum;
        private final SparseArray<SparseArray<UsbInterface>> mInterfaces = new SparseArray();

        private UsbControlBlock(USBMonitor monitor, UsbDevice device) {
            if (DEBUG) {
                Log.i((String)TAG, (String)"UsbControlBlock:constructor");
            }
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
        }

        public synchronized void open() throws Exception {
            if (DEBUG) {
                Log.i((String)TAG, (String)"UsbControlBlock#open:");
            }
            USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            this.mConnection = monitor.mUsbManager.openDevice(device);
            this.mInfo = USBMonitor.updateDeviceInfo(monitor.mUsbManager, device, null);
            String name = device.getDeviceName();
            String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
            int busnum = 0;
            int devnum = 0;
            if (v != null) {
                busnum = Integer.parseInt(v[v.length - 2]);
                devnum = Integer.parseInt(v[v.length - 1]);
            }
            this.mBusNum = busnum;
            this.mDevNum = devnum;
            if (this.mConnection != null) {
                if (DEBUG) {
                    int desc = this.mConnection.getFileDescriptor();
                    Log.i((String)TAG, (String)String.format(Locale.US, "name=%s,desc=%d,busnum=%d,devnum=%d", name, desc, busnum, devnum));
                }
            } else {
                Log.e((String)TAG, (String)("could not connect to device " + name));
                throw new USBException(USB_OPEN_ERROR_UNKNOWN, "failed to open usb device");
            }
        }

        public synchronized void close() {
            this.close(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close(boolean isSilent) {
            if (DEBUG) {
                Log.i((String)TAG, (String)"UsbControlBlock#close:");
            }
            if (this.mConnection != null) {
                int n = this.mInterfaces.size();
                for (int i = 0; i < n; ++i) {
                    SparseArray intfs = (SparseArray)this.mInterfaces.valueAt(i);
                    if (intfs == null) continue;
                    int m = intfs.size();
                    for (int j = 0; j < m; ++j) {
                        UsbInterface intf = (UsbInterface)intfs.valueAt(j);
                        this.mConnection.releaseInterface(intf);
                    }
                    intfs.clear();
                }
                this.mInterfaces.clear();
                this.mConnection.close();
                this.mConnection = null;
                USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
                if (monitor != null) {
                    if (!isSilent && monitor.mOnDeviceConnectListener != null) {
                        monitor.mListenerHandler.post(() -> monitor.mOnDeviceConnectListener.onDeviceClose((UsbDevice)this.mWeakDevice.get(), this));
                    }
                    HashMap hashMap = monitor.mOpenedCtrlBlocks;
                    synchronized (hashMap) {
                        monitor.mOpenedCtrlBlocks.remove(this.getDevice());
                    }
                }
            }
        }

        public UsbControlBlock clone() throws CloneNotSupportedException {
            UsbControlBlock ctrlblock;
            try {
                ctrlblock = new UsbControlBlock((USBMonitor)this.mWeakMonitor.get(), (UsbDevice)this.mWeakDevice.get());
            }
            catch (IllegalStateException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            return ctrlblock;
        }

        public USBMonitor getUSBMonitor() {
            return (USBMonitor)this.mWeakMonitor.get();
        }

        public final UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public int getDeviceId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceId() : 0;
        }

        public synchronized UsbDeviceConnection getConnection() {
            return this.mConnection;
        }

        public synchronized int getFileDescriptor() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getFileDescriptor();
        }

        public synchronized byte[] getRawDescriptors() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getRawDescriptors();
        }

        public int getVendorId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        public String getUsbVersion() {
            return this.mInfo.usb_version;
        }

        public String getManufacture() {
            return this.mInfo.manufacturer;
        }

        public String getProductName() {
            return this.mInfo.product;
        }

        public String getVersion() {
            return this.mInfo.version;
        }

        public String getSerial() {
            return this.mInfo.serial;
        }

        public int getBusNum() {
            return this.mBusNum;
        }

        public int getDevNum() {
            return this.mDevNum;
        }

        public synchronized UsbInterface getInterface(int interface_id) throws IllegalStateException {
            return this.getInterface(interface_id, 0);
        }

        public synchronized UsbInterface getInterface(int interface_id, int altsetting) throws IllegalStateException {
            UsbInterface intf;
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(interface_id);
            if (intfs == null) {
                intfs = new SparseArray();
                this.mInterfaces.put(interface_id, (Object)intfs);
            }
            if ((intf = (UsbInterface)intfs.get(altsetting)) == null) {
                UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                int n = device.getInterfaceCount();
                for (int i = 0; i < n; ++i) {
                    UsbInterface temp = device.getInterface(i);
                    if (temp.getId() != interface_id || temp.getAlternateSetting() != altsetting) continue;
                    intf = temp;
                    break;
                }
                if (intf != null) {
                    intfs.append(altsetting, (Object)intf);
                }
            }
            return intf;
        }

        public synchronized void claimInterface(UsbInterface intf) {
            this.claimInterface(intf, true);
        }

        public synchronized void claimInterface(UsbInterface intf, boolean force) {
            this.checkConnection();
            this.mConnection.claimInterface(intf, force);
        }

        public synchronized void releaseInterface(UsbInterface intf) throws IllegalStateException {
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(intf.getId());
            if (intfs != null) {
                int index = intfs.indexOfValue((Object)intf);
                intfs.removeAt(index);
                if (intfs.size() == 0) {
                    this.mInterfaces.remove(intf.getId());
                }
            }
            this.mConnection.releaseInterface(intf);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof UsbControlBlock) {
                UsbDevice device = ((UsbControlBlock)o).getDevice();
                return device == null ? this.mWeakDevice.get() == null : device.equals(this.mWeakDevice.get());
            }
            if (o instanceof UsbDevice) {
                return o.equals(this.mWeakDevice.get());
            }
            return super.equals(o);
        }

        private synchronized void checkConnection() throws IllegalStateException {
            if (this.mConnection == null) {
                throw new IllegalStateException("already closed");
            }
        }
    }

    public static class UsbDeviceInfo {
        public String usb_version;
        public String manufacturer;
        public String product;
        public String version;
        public String serial;

        private void clear() {
            this.serial = null;
            this.version = null;
            this.product = null;
            this.manufacturer = null;
            this.usb_version = null;
        }

        public String toString() {
            return String.format("UsbDevice:usb_version=%s,manufacturer=%s,product=%s,version=%s,serial=%s", this.usb_version != null ? this.usb_version : "", this.manufacturer != null ? this.manufacturer : "", this.product != null ? this.product : "", this.version != null ? this.version : "", this.serial != null ? this.serial : "");
        }
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(UsbDevice var1);

        public void onDetach(UsbDevice var1);

        public void onDeviceOpen(UsbDevice var1, UsbControlBlock var2, boolean var3);

        public void onDeviceClose(UsbDevice var1, UsbControlBlock var2);

        public void onCancel(UsbDevice var1);

        default public void onError(UsbDevice device, USBException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }
}

