/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.herohan.uvcapp.ICameraRendererHolder;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.herohan.uvcapp.utils.VideoUtil;
import com.serenegiant.usb.Size;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class VideoCapture {
    private static final String TAG = VideoCapture.class.getSimpleName();
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_ENCODER = 1;
    public static final int ERROR_MUXER = 2;
    public static final int ERROR_RECORDING_IN_PROGRESS = 3;
    public static final int ERROR_FILE_IO = 4;
    public static final int ERROR_INVALID_CAMERA = 5;
    public static final int ERROR_RECORDING_TOO_SHORT = 6;
    private static final int DEQUE_TIMEOUT_USEC = 10000;
    private static final String VIDEO_MIME_TYPE = "video/avc";
    private static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    private final MediaCodec.BufferInfo mVideoBufferInfo = new MediaCodec.BufferInfo();
    private final MediaCodec.BufferInfo mAudioBufferInfo = new MediaCodec.BufferInfo();
    private final Object mMuxerLock = new Object();
    private final AtomicBoolean mEndOfVideoStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioVideoSignal = new AtomicBoolean(true);
    @VisibleForTesting
    public final AtomicBoolean mIsFirstVideoKeyFrameWrite = new AtomicBoolean(false);
    @VisibleForTesting
    public final AtomicBoolean mIsFirstAudioSampleWrite = new AtomicBoolean(false);
    private HandlerThread mVideoHandlerThread;
    private Handler mVideoHandler;
    private HandlerThread mAudioHandlerThread;
    private Handler mAudioHandler;
    MediaCodec mVideoEncoder;
    private MediaCodec mAudioEncoder;
    private FutureTask<String> mRecordingFuture = null;
    private final AtomicBoolean mRecordingWaitRelease = new AtomicBoolean(false);
    @GuardedBy(value="mMuxerLock")
    private MediaMuxer mMuxer;
    private final AtomicBoolean mMuxerStarted = new AtomicBoolean(false);
    @GuardedBy(value="mMuxerLock")
    private int mVideoTrackIndex;
    @GuardedBy(value="mMuxerLock")
    private int mAudioTrackIndex;
    Surface mCameraSurface;
    volatile Uri mSavedVideoUri;
    private volatile ParcelFileDescriptor mParcelFileDescriptor;
    @Nullable
    private volatile AudioRecord mAudioRecorder;
    private volatile int mAudioBufferSize;
    private volatile boolean mIsRecording = false;
    private int mAudioChannelCount;
    private int mAudioSampleRate;
    private int mAudioBitRate;
    private final AtomicBoolean mIsAudioEnabled = new AtomicBoolean(true);
    private VideoEncoderInitStatus mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED;
    @Nullable
    private Throwable mVideoEncoderErrorMessage;
    private AudioEncoderInitStatus mAudioEncoderInitStatus = AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_UNINITIALIZED;
    @Nullable
    private Throwable mAudioEncoderErrorMessage;
    private WeakReference<ICameraRendererHolder> mRendererHolderWeak;
    private VideoCaptureConfig mConfig;
    private Size mResolution;
    private Handler mMainHandler;
    private ExecutorService mExecutor;

    VideoCapture(ICameraRendererHolder rendererHolder, VideoCaptureConfig config, Size resolution) {
        this.mRendererHolderWeak = new WeakReference<ICameraRendererHolder>(rendererHolder);
        this.mConfig = (VideoCaptureConfig)config.clone();
        this.mResolution = resolution;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
            private final AtomicInteger mId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, TAG + "video_capture" + this.mId.getAndIncrement());
            }
        });
        this.initVideoAudioHandler();
        this.initVideoAudioEncoder();
    }

    void setConfig(VideoCaptureConfig config) {
        this.mConfig = (VideoCaptureConfig)config.clone();
        this.initVideoAudioEncoder();
    }

    void setResolution(Size resolution) {
        this.mResolution = resolution;
        this.initVideoAudioEncoder();
    }

    private void initVideoAudioHandler() {
        this.mVideoHandlerThread = new HandlerThread(TAG + "video encoding thread");
        this.mAudioHandlerThread = new HandlerThread(TAG + "audio encoding thread");
        this.mVideoHandlerThread.start();
        this.mVideoHandler = new Handler(this.mVideoHandlerThread.getLooper());
        this.mAudioHandlerThread.start();
        this.mAudioHandler = new Handler(this.mAudioHandlerThread.getLooper());
    }

    private MediaFormat createVideoMediaFormat() {
        MediaFormat format = MediaFormat.createVideoFormat((String)VIDEO_MIME_TYPE, (int)this.mResolution.width, (int)this.mResolution.height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mConfig.hasBitRate() ? this.mConfig.getBitRate() : 8 * this.mResolution.width * this.mResolution.height);
        format.setInteger("frame-rate", this.mConfig.getVideoFrameRate());
        format.setInteger("i-frame-interval", this.mConfig.getIFrameInterval());
        return format;
    }

    private void initVideoAudioEncoder() {
        if (this.mCameraSurface != null) {
            if (this.mVideoEncoder != null) {
                this.mVideoEncoder.stop();
                this.mVideoEncoder.release();
            }
            if (this.mAudioEncoder != null) {
                this.mAudioEncoder.stop();
                this.mAudioEncoder.release();
            }
            this.releaseCameraSurface(false);
        }
        try {
            this.mVideoEncoder = MediaCodec.createEncoderByType((String)VIDEO_MIME_TYPE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create Video MediaCodec due to: " + e.getCause());
        }
        try {
            this.mAudioEncoder = MediaCodec.createEncoderByType((String)AUDIO_MIME_TYPE);
        }
        catch (Exception e) {
            this.mIsAudioEnabled.set(false);
            Log.e((String)TAG, (String)("Unable to create Audio MediaCodec, disable audio." + e.getMessage()), (Throwable)e);
        }
        this.setupEncoder();
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void startRecording(@NonNull OutputFileOptions outputFileOptions, @NonNull OnVideoCaptureCallback callback) {
        Log.i((String)TAG, (String)"startRecording");
        this.mIsFirstVideoKeyFrameWrite.set(false);
        this.mIsFirstAudioSampleWrite.set(false);
        VideoCaptureListenerWrapper postListener = new VideoCaptureListenerWrapper(callback);
        if (this.mRendererHolderWeak.get() == null) {
            postListener.onError(5, "Not bound to a Camera", null);
            return;
        }
        if (this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE || this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED || this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED) {
            postListener.onError(1, "Video encoder initialization failed before start recording ", this.mVideoEncoderErrorMessage);
            return;
        }
        if (this.mAudioEncoderInitStatus == AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE || this.mAudioEncoderInitStatus == AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_INITIALIZED_FAILED || this.mAudioEncoderInitStatus == AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED) {
            postListener.onError(1, "Audio encoder initialization failed before start recording ", this.mAudioEncoderErrorMessage);
            return;
        }
        if (!this.mEndOfAudioVideoSignal.get()) {
            postListener.onError(3, "It is still in video recording!", null);
            return;
        }
        if (this.mIsAudioEnabled.get()) {
            try {
                if (this.mAudioRecorder.getState() == 1) {
                    this.mAudioRecorder.startRecording();
                }
            }
            catch (IllegalStateException e) {
                Log.i((String)TAG, (String)("AudioRecorder cannot start recording, disable audio." + e.getMessage()));
                this.mIsAudioEnabled.set(false);
                this.releaseAudioInputResource();
            }
            if (this.mAudioRecorder.getRecordingState() != 3) {
                Log.i((String)TAG, (String)("AudioRecorder startRecording failed - incorrect state: " + this.mAudioRecorder.getRecordingState()));
                this.mIsAudioEnabled.set(false);
                this.releaseAudioInputResource();
            }
        }
        this.mRecordingFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (VideoCapture.this.mRendererHolderWeak.get() != null && VideoCapture.this.mCameraSurface != null) {
                    ((ICameraRendererHolder)VideoCapture.this.mRendererHolderWeak.get()).removeSlaveSurface(VideoCapture.this.mCameraSurface.hashCode());
                }
                if (VideoCapture.this.mRecordingWaitRelease.get()) {
                    VideoCapture.this.mRecordingWaitRelease.set(false);
                    VideoCapture.this.releaseResources();
                    VideoCapture.this.mIsRecording = false;
                    return "releaseResources";
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    VideoCapture.this.setupEncoder();
                } else {
                    VideoCapture.this.initVideoAudioEncoder();
                }
                return "startRecording";
            }
        });
        try {
            Log.i((String)TAG, (String)"videoEncoder start");
            this.mVideoEncoder.start();
            if (this.mIsAudioEnabled.get()) {
                Log.i((String)TAG, (String)"audioEncoder start");
                this.mAudioEncoder.start();
            }
        }
        catch (IllegalStateException e) {
            this.mExecutor.execute(this.mRecordingFuture);
            postListener.onError(1, "Audio/Video encoder start fail", e);
            return;
        }
        try {
            Object e = this.mMuxerLock;
            synchronized (e) {
                this.mMuxer = this.initMediaMuxer(outputFileOptions);
                if (this.mMuxer == null) {
                    throw new NullPointerException();
                }
            }
        }
        catch (IOException e) {
            this.mExecutor.execute(this.mRecordingFuture);
            postListener.onError(2, "MediaMuxer creation failed!", e);
            return;
        }
        this.mEndOfVideoStreamSignal.set(false);
        this.mEndOfAudioStreamSignal.set(false);
        this.mEndOfAudioVideoSignal.set(false);
        this.mIsRecording = true;
        postListener.onStart();
        ((ICameraRendererHolder)this.mRendererHolderWeak.get()).addSlaveSurface(this.mCameraSurface.hashCode(), this.mCameraSurface, true);
        if (this.mIsAudioEnabled.get()) {
            this.mAudioHandler.post(() -> this.audioEncode(postListener));
        }
        this.mVideoHandler.post(() -> {
            boolean errorOccurred = this.videoEncode(postListener, outputFileOptions);
            if (!errorOccurred) {
                this.scanMediaFile(this.mSavedVideoUri);
                postListener.onVideoSaved(new OutputFileResults(this.mSavedVideoUri));
                this.mSavedVideoUri = null;
            }
            this.mExecutor.execute(this.mRecordingFuture);
        });
    }

    public void stopRecording() {
        Log.i((String)TAG, (String)"stopRecording");
        if (this.mIsRecording) {
            if (this.mIsAudioEnabled.get()) {
                this.mEndOfAudioStreamSignal.set(true);
            } else {
                this.mEndOfVideoStreamSignal.set(true);
            }
        }
    }

    public void release() {
        this.stopRecording();
        if (this.mRecordingFuture != null) {
            this.mRecordingWaitRelease.set(true);
        } else {
            this.releaseResources();
        }
    }

    private void releaseResources() {
        this.mVideoHandlerThread.quitSafely();
        this.releaseAudioInputResource();
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(true);
        }
    }

    private void releaseAudioInputResource() {
        this.mAudioHandlerThread.quitSafely();
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.release();
            this.mAudioRecorder = null;
        }
    }

    @UiThread
    private void releaseCameraSurface(boolean releaseVideoEncoder) {
        if (releaseVideoEncoder && this.mVideoEncoder != null) {
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
        }
        if (this.mCameraSurface != null) {
            this.mCameraSurface.release();
            this.mCameraSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    void setupEncoder() {
        Surface cameraSurface;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mVideoEncoder.reset();
        }
        this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED;
        try {
            this.mVideoEncoder.configure(this.createVideoMediaFormat(), null, null, 1);
        }
        catch (Exception e) {
            this.handleVideoEncoderInitError(e);
            return;
        }
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(false);
        }
        this.mCameraSurface = cameraSurface = this.mVideoEncoder.createInputSurface();
        this.mIsAudioEnabled.set(this.mConfig.getAudioCaptureEnable());
        if (this.mIsAudioEnabled.get()) {
            this.setAudioParameters();
            if (Build.VERSION.SDK_INT >= 21) {
                this.mAudioEncoder.reset();
            }
            try {
                this.mAudioEncoder.configure(this.createAudioMediaFormat(), null, null, 1);
            }
            catch (Exception e) {
                this.handleAudioEncoderInitError(e);
                return;
            }
            if (this.mAudioRecorder != null) {
                this.mAudioRecorder.release();
            }
            this.mAudioRecorder = this.autoConfigAudioRecordSource();
            if (this.mAudioRecorder == null) {
                Log.e((String)TAG, (String)"AudioRecord object cannot initialized correctly!");
                this.mIsAudioEnabled.set(false);
            }
        }
        Object object = this.mMuxerLock;
        synchronized (object) {
            this.mVideoTrackIndex = -1;
            this.mAudioTrackIndex = -1;
        }
        this.mIsRecording = false;
    }

    private void handleVideoEncoderInitError(Exception e) {
        this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED;
        this.mVideoEncoderErrorMessage = e;
        if (Build.VERSION.SDK_INT >= 21 && e instanceof MediaCodec.CodecException) {
            MediaCodec.CodecException e1 = (MediaCodec.CodecException)e;
            int errorCode = 0;
            if (Build.VERSION.SDK_INT >= 23) {
                errorCode = Api23Impl.getCodecExceptionErrorCode(e1);
                Log.i((String)TAG, (String)("CodecException: code: " + errorCode + " diagnostic: " + e1.getDiagnosticInfo()));
                if (errorCode == 1100) {
                    this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE;
                } else if (errorCode == 1101) {
                    this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;
                }
            }
        }
    }

    private void handleAudioEncoderInitError(Exception e) {
        this.mAudioEncoderInitStatus = AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_INITIALIZED_FAILED;
        this.mAudioEncoderErrorMessage = e;
        if (Build.VERSION.SDK_INT >= 21 && e instanceof MediaCodec.CodecException) {
            MediaCodec.CodecException e1 = (MediaCodec.CodecException)e;
            int errorCode = 0;
            if (Build.VERSION.SDK_INT >= 23) {
                errorCode = Api23Impl.getCodecExceptionErrorCode(e1);
                Log.i((String)TAG, (String)("CodecException: code: " + errorCode + " diagnostic: " + e1.getDiagnosticInfo()));
                if (errorCode == 1100) {
                    this.mAudioEncoderInitStatus = AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE;
                } else if (errorCode == 1101) {
                    this.mAudioEncoderInitStatus = AudioEncoderInitStatus.AUDIO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeVideoEncodedBuffer(int bufferIndex) {
        if (bufferIndex < 0) {
            Log.e((String)TAG, (String)("Output buffer should not have negative index: " + bufferIndex));
            return false;
        }
        ByteBuffer outputBuffer = this.getOutputBuffer(this.mVideoEncoder, bufferIndex);
        if (outputBuffer == null) {
            Log.d((String)TAG, (String)"OutputBuffer was null.");
            return false;
        }
        if (this.mMuxerStarted.get()) {
            if (this.mVideoBufferInfo.size > 0) {
                outputBuffer.position(this.mVideoBufferInfo.offset);
                outputBuffer.limit(this.mVideoBufferInfo.offset + this.mVideoBufferInfo.size);
                this.mVideoBufferInfo.presentationTimeUs = System.nanoTime() / 1000L;
                Object object = this.mMuxerLock;
                synchronized (object) {
                    if (Build.VERSION.SDK_INT >= 21 && !this.mIsFirstVideoKeyFrameWrite.get()) {
                        boolean isKeyFrame;
                        boolean bl = isKeyFrame = (this.mVideoBufferInfo.flags & 1) != 0;
                        if (isKeyFrame) {
                            Log.i((String)TAG, (String)"First video key frame written.");
                            this.mIsFirstVideoKeyFrameWrite.set(true);
                        } else {
                            Bundle syncFrame = new Bundle();
                            syncFrame.putInt("request-sync", 0);
                            this.mVideoEncoder.setParameters(syncFrame);
                        }
                    }
                    this.mMuxer.writeSampleData(this.mVideoTrackIndex, outputBuffer, this.mVideoBufferInfo);
                }
            } else {
                Log.i((String)TAG, (String)("mVideoBufferInfo.size <= 0, index " + bufferIndex));
            }
        }
        this.mVideoEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mVideoBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeAudioEncodedBuffer(int bufferIndex) {
        block8: {
            ByteBuffer buffer = this.getOutputBuffer(this.mAudioEncoder, bufferIndex);
            buffer.position(this.mAudioBufferInfo.offset);
            if (this.mMuxerStarted.get()) {
                try {
                    if (this.mAudioBufferInfo.size > 0 && this.mAudioBufferInfo.presentationTimeUs > 0L) {
                        Object object = this.mMuxerLock;
                        synchronized (object) {
                            if (!this.mIsFirstAudioSampleWrite.get()) {
                                Log.i((String)TAG, (String)"First audio sample written.");
                                this.mIsFirstAudioSampleWrite.set(true);
                            }
                            this.mMuxer.writeSampleData(this.mAudioTrackIndex, buffer, this.mAudioBufferInfo);
                            break block8;
                        }
                    }
                    Log.i((String)TAG, (String)("mAudioBufferInfo size: " + this.mAudioBufferInfo.size + " presentationTimeUs: " + this.mAudioBufferInfo.presentationTimeUs));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("audio error:size=" + this.mAudioBufferInfo.size + "/offset=" + this.mAudioBufferInfo.offset + "/timeUs=" + this.mAudioBufferInfo.presentationTimeUs));
                    e.printStackTrace();
                }
            }
        }
        this.mAudioEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mAudioBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean videoEncode(@NonNull OnVideoCaptureCallback videoSavedCallback, @NonNull OutputFileOptions outputFileOptions) {
        boolean errorOccurred = false;
        boolean videoEos = false;
        try {
            while (!videoEos && !errorOccurred) {
                if (this.mEndOfVideoStreamSignal.get()) {
                    this.mVideoEncoder.signalEndOfInputStream();
                    this.mEndOfVideoStreamSignal.set(false);
                }
                int outputBufferId = this.mVideoEncoder.dequeueOutputBuffer(this.mVideoBufferInfo, 10000L);
                switch (outputBufferId) {
                    case -2: {
                        if (this.mMuxerStarted.get()) {
                            videoSavedCallback.onError(1, "Unexpected change in video encoding format.", null);
                            errorOccurred = true;
                        }
                        Object object = this.mMuxerLock;
                        synchronized (object) {
                            this.mVideoTrackIndex = this.mMuxer.addTrack(this.mVideoEncoder.getOutputFormat());
                            if (this.mIsAudioEnabled.get() && this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0 || !this.mIsAudioEnabled.get() && this.mVideoTrackIndex >= 0) {
                                Log.i((String)TAG, (String)("MediaMuxer started on video encode thread and audio enabled: " + this.mIsAudioEnabled));
                                this.mMuxer.start();
                                this.mMuxerStarted.set(true);
                            }
                            break;
                        }
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        videoEos = this.writeVideoEncodedBuffer(outputBufferId);
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Video encoder encode failed!", e);
            errorOccurred = true;
        }
        try {
            Log.i((String)TAG, (String)"videoEncoder stop");
            this.mVideoEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Video encoder stop failed!", e);
            errorOccurred = true;
        }
        try {
            Object e = this.mMuxerLock;
            synchronized (e) {
                if (this.mMuxer != null) {
                    if (this.mMuxerStarted.get()) {
                        Log.i((String)TAG, (String)"Muxer already started");
                        this.mMuxer.stop();
                    }
                    this.mMuxer.release();
                    this.mMuxer = null;
                }
            }
            boolean checkResult = this.removeRecordingResultIfNoVideoKeyFrameArrived(outputFileOptions);
            if (!checkResult) {
                videoSavedCallback.onError(6, "The file has no video key frame.", null);
                errorOccurred = true;
            }
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)("muxer stop IllegalStateException: " + System.currentTimeMillis()));
            Log.i((String)TAG, (String)("muxer stop exception, mIsFirstVideoKeyFrameWrite: " + this.mIsFirstVideoKeyFrameWrite.get()));
            if (this.mIsFirstVideoKeyFrameWrite.get()) {
                videoSavedCallback.onError(2, "Muxer stop failed!", e);
            } else {
                videoSavedCallback.onError(6, "The file has no video key frame.", null);
            }
            errorOccurred = true;
        }
        if (this.mParcelFileDescriptor != null) {
            try {
                this.mParcelFileDescriptor.close();
                this.mParcelFileDescriptor = null;
            }
            catch (IOException e) {
                videoSavedCallback.onError(2, "File descriptor close failed!", e);
                errorOccurred = true;
            }
        }
        this.mMuxerStarted.set(false);
        this.mEndOfAudioVideoSignal.set(true);
        this.mIsFirstVideoKeyFrameWrite.set(false);
        Log.i((String)TAG, (String)"Video encode thread end.");
        return errorOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean audioEncode(OnVideoCaptureCallback videoSavedCallback) {
        boolean audioEos = false;
        long lastAudioTimestamp = 0L;
        while (!audioEos && this.mIsRecording) {
            int outIndex;
            if (this.mEndOfAudioStreamSignal.get()) {
                this.mEndOfAudioStreamSignal.set(false);
                this.mIsRecording = false;
            }
            if (this.mAudioEncoder == null || this.mAudioRecorder == null) continue;
            try {
                int index = this.mAudioEncoder.dequeueInputBuffer(-1L);
                if (index >= 0) {
                    ByteBuffer buffer = this.getInputBuffer(this.mAudioEncoder, index);
                    buffer.clear();
                    int length = this.mAudioRecorder.read(buffer, this.mAudioBufferSize);
                    if (length > 0) {
                        this.mAudioEncoder.queueInputBuffer(index, 0, length, System.nanoTime() / 1000L, this.mIsRecording ? 0 : 4);
                    }
                }
            }
            catch (Exception e) {
                if (Build.VERSION.SDK_INT >= 21 && e instanceof MediaCodec.CodecException) {
                    Log.i((String)TAG, (String)("audio dequeueInputBuffer CodecException " + e.getMessage()));
                }
                if (e instanceof IllegalStateException) {
                    Log.i((String)TAG, (String)("audio dequeueInputBuffer IllegalStateException " + e.getMessage()));
                }
                throw e;
            }
            do {
                outIndex = this.mAudioEncoder.dequeueOutputBuffer(this.mAudioBufferInfo, 0L);
                switch (outIndex) {
                    case -2: {
                        Object e = this.mMuxerLock;
                        synchronized (e) {
                            this.mAudioTrackIndex = this.mMuxer.addTrack(this.mAudioEncoder.getOutputFormat());
                            if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0) {
                                Log.i((String)TAG, (String)"MediaMuxer start on audio encoder thread.");
                                this.mMuxer.start();
                                this.mMuxerStarted.set(true);
                            }
                            break;
                        }
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        if (this.mAudioBufferInfo.presentationTimeUs > lastAudioTimestamp) {
                            audioEos = this.writeAudioEncodedBuffer(outIndex);
                            lastAudioTimestamp = this.mAudioBufferInfo.presentationTimeUs;
                            break;
                        }
                        Log.w((String)TAG, (String)("Drops frame, current frame's timestamp " + this.mAudioBufferInfo.presentationTimeUs + " is earlier that last frame " + lastAudioTimestamp));
                        this.mAudioEncoder.releaseOutputBuffer(outIndex, false);
                    }
                }
            } while (outIndex >= 0 && !audioEos);
        }
        try {
            Log.i((String)TAG, (String)"audioRecorder stop");
            this.mAudioRecorder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio recorder stop failed!", e);
        }
        try {
            this.mAudioEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio encoder stop failed!", e);
        }
        Log.i((String)TAG, (String)"Audio encode thread end");
        this.mEndOfVideoStreamSignal.set(true);
        return false;
    }

    private ByteBuffer getInputBuffer(MediaCodec codec, int index) {
        return Build.VERSION.SDK_INT < 21 ? codec.getInputBuffers()[index] : codec.getInputBuffer(index);
    }

    private ByteBuffer getOutputBuffer(MediaCodec codec, int index) {
        return Build.VERSION.SDK_INT < 21 ? codec.getOutputBuffers()[index] : codec.getOutputBuffer(index);
    }

    private MediaFormat createAudioMediaFormat() {
        MediaFormat format = MediaFormat.createAudioFormat((String)AUDIO_MIME_TYPE, (int)this.mAudioSampleRate, (int)this.mAudioChannelCount);
        format.setInteger("aac-profile", 2);
        format.setInteger("bitrate", this.mAudioBitRate);
        return format;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    private AudioRecord autoConfigAudioRecordSource() {
        int channelConfig = this.mAudioChannelCount == 1 ? 16 : 12;
        try {
            AudioRecord recorder;
            int bufferSize = AudioRecord.getMinBufferSize((int)this.mAudioSampleRate, (int)channelConfig, (int)2);
            if (bufferSize <= 0) {
                bufferSize = this.mConfig.getAudioMinBufferSize();
            }
            if ((recorder = new AudioRecord(5, this.mAudioSampleRate, channelConfig, 2, bufferSize * 2)).getState() == 1) {
                this.mAudioBufferSize = bufferSize;
                Log.i((String)TAG, (String)("source: 5 audioSampleRate: " + this.mAudioSampleRate + " channelConfig: " + channelConfig + " audioFormat: " + 2 + " bufferSize: " + bufferSize));
                return recorder;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception, keep trying.", (Throwable)e);
        }
        return null;
    }

    private void setAudioParameters() {
        this.mAudioChannelCount = this.mConfig.getAudioChannelCount();
        this.mAudioSampleRate = this.mConfig.getAudioSampleRate();
        this.mAudioBitRate = this.mConfig.getAudioBitRate();
    }

    private boolean removeRecordingResultIfNoVideoKeyFrameArrived(@NonNull OutputFileOptions outputFileOptions) {
        boolean checkKeyFrame;
        Log.i((String)TAG, (String)("check Recording Result First Video Key Frame Write: " + this.mIsFirstVideoKeyFrameWrite.get()));
        if (!this.mIsFirstVideoKeyFrameWrite.get()) {
            Log.i((String)TAG, (String)"The recording result has no key frame.");
            checkKeyFrame = false;
        } else {
            checkKeyFrame = true;
        }
        if (outputFileOptions.isSavingToFile()) {
            File outputFile = outputFileOptions.getFile();
            if (!checkKeyFrame) {
                Log.i((String)TAG, (String)"Delete file.");
                outputFile.delete();
            }
        } else if (outputFileOptions.isSavingToMediaStore() && !checkKeyFrame) {
            Log.i((String)TAG, (String)"Delete file.");
            if (this.mSavedVideoUri != null) {
                ContentResolver contentResolver = outputFileOptions.getContentResolver();
                contentResolver.delete(this.mSavedVideoUri, null, null);
            }
        }
        return checkKeyFrame;
    }

    @NonNull
    private MediaMuxer initMediaMuxer(@NonNull OutputFileOptions outputFileOptions) throws IOException {
        MediaMuxer mediaMuxer;
        if (outputFileOptions.isSavingToFile()) {
            File savedVideoFile = outputFileOptions.getFile();
            this.mSavedVideoUri = Uri.fromFile((File)outputFileOptions.getFile());
            mediaMuxer = new MediaMuxer(savedVideoFile.getAbsolutePath(), 0);
        } else if (outputFileOptions.isSavingToFileDescriptor()) {
            if (Build.VERSION.SDK_INT < 26) {
                throw new IllegalArgumentException("Using a FileDescriptor to record a video is only supported for Android 8.0 or above.");
            }
            mediaMuxer = Api26Impl.createMediaMuxer(outputFileOptions.getFileDescriptor(), 0);
        } else if (outputFileOptions.isSavingToMediaStore()) {
            ContentValues values = outputFileOptions.getContentValues() != null ? new ContentValues(outputFileOptions.getContentValues()) : new ContentValues();
            this.mSavedVideoUri = outputFileOptions.getContentResolver().insert(outputFileOptions.getSaveCollection(), values);
            if (this.mSavedVideoUri == null) {
                throw new IOException("Invalid Uri!");
            }
            try {
                if (Build.VERSION.SDK_INT < 26) {
                    String savedLocationPath = VideoUtil.getAbsolutePathFromUri(outputFileOptions.getContentResolver(), this.mSavedVideoUri);
                    Log.i((String)TAG, (String)("Saved Location Path: " + savedLocationPath));
                    mediaMuxer = new MediaMuxer(savedLocationPath, 0);
                }
                this.mParcelFileDescriptor = outputFileOptions.getContentResolver().openFileDescriptor(this.mSavedVideoUri, "rw");
                mediaMuxer = Api26Impl.createMediaMuxer(this.mParcelFileDescriptor.getFileDescriptor(), 0);
            }
            catch (IOException e) {
                this.mSavedVideoUri = null;
                throw e;
            }
        } else {
            throw new IllegalArgumentException("The OutputFileOptions should assign before recording");
        }
        return mediaMuxer;
    }

    private void scanMediaFile(Uri uri) {
        if (uri == null) {
            return;
        }
        Application context = UVCUtils.getApplication();
        String path = UriHelper.getPath((Context)context, uri);
        try {
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"MediaScannerConnection:", (Throwable)e);
        }
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static int getCodecExceptionErrorCode(MediaCodec.CodecException e) {
            return e.getErrorCode();
        }
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        @NonNull
        static MediaMuxer createMediaMuxer(@NonNull FileDescriptor fileDescriptor, int format) throws IOException {
            return new MediaMuxer(fileDescriptor, format);
        }
    }

    public static final class OutputFileOptions {
        @Nullable
        private final File mFile;
        @Nullable
        private final FileDescriptor mFileDescriptor;
        @Nullable
        private final ContentResolver mContentResolver;
        @Nullable
        private final Uri mSaveCollection;
        @Nullable
        private final ContentValues mContentValues;

        OutputFileOptions(@Nullable File file, @Nullable FileDescriptor fileDescriptor, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues) {
            this.mFile = file;
            this.mFileDescriptor = fileDescriptor;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
        }

        @Nullable
        File getFile() {
            return this.mFile;
        }

        @Nullable
        FileDescriptor getFileDescriptor() {
            return this.mFileDescriptor;
        }

        @Nullable
        ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        ContentValues getContentValues() {
            return this.mContentValues;
        }

        boolean isSavingToMediaStore() {
            return this.getSaveCollection() != null && this.getContentResolver() != null && this.getContentValues() != null;
        }

        boolean isSavingToFile() {
            return this.getFile() != null;
        }

        boolean isSavingToFileDescriptor() {
            return this.getFileDescriptor() != null;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private FileDescriptor mFileDescriptor;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull FileDescriptor fileDescriptor) {
                if (Build.VERSION.SDK_INT < 26) {
                    throw new IllegalArgumentException("Using a FileDescriptor to record a video is only supported for Android 8.0 or above.");
                }
                this.mFileDescriptor = fileDescriptor;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            @NonNull
            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mFileDescriptor, this.mContentResolver, this.mSaveCollection, this.mContentValues);
            }
        }
    }

    public static class OutputFileResults {
        @Nullable
        private Uri mSavedUri;

        OutputFileResults(@Nullable Uri savedUri) {
            this.mSavedUri = savedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    private final class VideoCaptureListenerWrapper
    implements OnVideoCaptureCallback {
        @NonNull
        OnVideoCaptureCallback mOnVideoCaptureCallback;

        VideoCaptureListenerWrapper(OnVideoCaptureCallback onVideoCaptureCallback) {
            this.mOnVideoCaptureCallback = onVideoCaptureCallback;
        }

        @Override
        public void onStart() {
            VideoCapture.this.mMainHandler.post(() -> this.mOnVideoCaptureCallback.onStart());
        }

        @Override
        public void onVideoSaved(@NonNull OutputFileResults outputFileResults) {
            VideoCapture.this.mMainHandler.post(() -> this.mOnVideoCaptureCallback.onVideoSaved(outputFileResults));
        }

        @Override
        public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
            VideoCapture.this.mMainHandler.post(() -> this.mOnVideoCaptureCallback.onError(videoCaptureError, message, cause));
        }
    }

    public static interface OnVideoCaptureCallback {
        public void onStart();

        public void onVideoSaved(@NonNull OutputFileResults var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    static enum AudioEncoderInitStatus {
        AUDIO_ENCODER_INIT_STATUS_UNINITIALIZED,
        AUDIO_ENCODER_INIT_STATUS_INITIALIZED_FAILED,
        AUDIO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE,
        AUDIO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;

    }

    static enum VideoEncoderInitStatus {
        VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED,
        VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED,
        VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE,
        VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoCaptureError {
    }
}

