/*
 * Decompiled with CFR 0.152.
 */
package com.wizapply.libspap;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.macroyau.blue2serial.BluetoothDeviceListDialog;
import com.macroyau.blue2serial.BluetoothSerial;
import com.macroyau.blue2serial.BluetoothSerialListener;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BluetoothSPAP
implements BluetoothSerialListener,
BluetoothDeviceListDialog.OnDeviceSelectedListener {
    private Context unity_context;
    private BluetoothSerial bluetoothSerial = null;
    private ProgressDialog progressDialog = null;
    private static final int BUFSIZ = 0x200000;
    private final ByteBuffer mReadBuffer = ByteBuffer.allocate(0x200000);
    private BluetoothDevice bluetoothDevice = null;
    private boolean connectingProcess;

    public BluetoothSPAP(Context context) {
        this.unity_context = context;
        this.bluetoothSerial = null;
        this.bluetoothDevice = null;
    }

    public void FindSPP(String address, int skip) {
        if (this.bluetoothSerial == null) {
            this.bluetoothSerial = new BluetoothSerial(this.unity_context, this);
            this.bluetoothSerial.setup();
        }
        if (this.bluetoothSerial.checkBluetooth() && this.bluetoothSerial.isBluetoothEnabled()) {
            this.connectingProcess = false;
            if (!this.bluetoothSerial.isConnected()) {
                this.bluetoothSerial.start();
            }
            if (this.bluetoothSerial.getState() == 0) {
                int pos = skip;
                for (BluetoothDevice dev : this.bluetoothSerial.getPairedDevices()) {
                    if (!dev.getName().equals(address) && !address.isEmpty()) continue;
                    if (pos <= 0) {
                        this.bluetoothDevice = dev;
                        break;
                    }
                    --pos;
                }
            }
        } else {
            this.close();
        }
    }

    public String[] ListSPP() {
        ArrayList<String> devicesName = new ArrayList<String>();
        if (this.bluetoothSerial == null) {
            this.bluetoothSerial = new BluetoothSerial(this.unity_context, this);
            this.bluetoothSerial.setup();
        }
        if (this.bluetoothSerial.checkBluetooth() && this.bluetoothSerial.isBluetoothEnabled()) {
            for (BluetoothDevice dev : this.bluetoothSerial.getPairedDevices()) {
                devicesName.add(dev.getName());
            }
        } else {
            this.close();
        }
        return devicesName.toArray(new String[devicesName.size()]);
    }

    public void OpenSPPConnect() {
        if (this.bluetoothSerial == null) {
            return;
        }
        if (this.bluetoothDevice == null) {
            return;
        }
        this.bluetoothSerial.connect(this.bluetoothDevice);
    }

    public void OpenSPPServer() {
        if (this.bluetoothSerial == null) {
            this.bluetoothSerial = new BluetoothSerial(this.unity_context, this);
            this.bluetoothSerial.setup();
        }
        if (this.bluetoothSerial.checkBluetooth() && this.bluetoothSerial.isBluetoothEnabled()) {
            this.connectingProcess = false;
            if (!this.bluetoothSerial.isConnected()) {
                this.bluetoothSerial.start();
            }
            if (this.bluetoothSerial.getState() == 0) {
                this.bluetoothSerial.connectServer();
                this.bluetoothDevice = null;
            }
        } else {
            this.close();
        }
    }

    public boolean isOpened() {
        if (this.bluetoothSerial == null) {
            return false;
        }
        return this.bluetoothSerial.getState() != 0;
    }

    public boolean isFindDevice() {
        return this.bluetoothDevice != null;
    }

    public String getDeviceName() {
        if (this.bluetoothSerial == null) {
            return "ERROR_BT";
        }
        if (this.bluetoothDevice == null) {
            return "ERROR_BT";
        }
        return this.bluetoothDevice.getAddress() + "_BT";
    }

    public void close() {
        if (this.bluetoothSerial != null) {
            this.bluetoothSerial.stop();
            this.bluetoothSerial = null;
        }
        this.bluetoothDevice = null;
    }

    public void writeAsync(byte[] data) {
        if (!this.isOpened()) {
            return;
        }
        this.bluetoothSerial.write(data);
    }

    public void writeAsync(byte[] data, int data_size) {
        if (!this.isOpened()) {
            return;
        }
        this.bluetoothSerial.write(data, 0, data_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] data, int data_size, boolean discard_null) {
        if (!this.isOpened()) {
            return 0;
        }
        int get_size = 0;
        ByteBuffer byteBuffer = this.mReadBuffer;
        synchronized (byteBuffer) {
            int i = 0;
            this.mReadBuffer.flip();
            try {
                for (i = 0; i < data_size && this.mReadBuffer.hasRemaining(); ++i) {
                    byte d = this.mReadBuffer.get();
                    if (discard_null && d == 0) continue;
                    data[get_size] = d;
                    ++get_size;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            this.mReadBuffer.compact();
        }
        return get_size;
    }

    public int readDataAvailable() {
        return this.mReadBuffer.position();
    }

    private void showDeviceListDialog() {
        BluetoothDeviceListDialog dialog = new BluetoothDeviceListDialog(this.unity_context);
        dialog.setOnDeviceSelectedListener(this);
        dialog.setTitle("Selected Open Device");
        dialog.setDevices(this.bluetoothSerial.getPairedDevices());
        dialog.showAddress(true);
        dialog.show();
    }

    @Override
    public void onBluetoothNotSupported() {
        new AlertDialog.Builder(this.unity_context).setMessage((CharSequence)"This device does not support Bluetooth!").setPositiveButton((CharSequence)"Quit", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setCancelable(false).show();
    }

    @Override
    public void onBluetoothDisabled() {
        if (this.progressDialog != null) {
            Toast.makeText((Context)this.unity_context, (CharSequence)"Bluetooth is Disabled.", (int)0).show();
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }

    @Override
    public void onBluetoothDeviceDisconnected() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
        this.connectingProcess = false;
    }

    @Override
    public void onConnectingBluetoothDevice() {
        if (this.progressDialog == null && this.bluetoothDevice != null) {
            this.connectingProcess = true;
            this.progressDialog = new ProgressDialog(this.unity_context);
            this.progressDialog.setIndeterminate(true);
            this.progressDialog.setMessage((CharSequence)"Connecting...");
            this.progressDialog.setCancelable(false);
            this.progressDialog.show();
        }
    }

    @Override
    public void onBluetoothDeviceConnected(String name, String address) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
            this.connectingProcess = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBluetoothSerialRead(byte[] message) {
        int len = 0;
        len = message.length;
        if (len > 0) {
            ByteBuffer byteBuffer = this.mReadBuffer;
            synchronized (byteBuffer) {
                this.mReadBuffer.put(message, 0, len);
            }
        }
    }

    @Override
    public void onBluetoothSerialWrite(String message) {
    }

    @Override
    public void onBluetoothDeviceSelected(BluetoothDevice device) {
        this.bluetoothSerial.connect(device);
    }
}

