/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.Window;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.permission.ActivityCompat;
import com.hpplay.sdk.source.permission.ContextCompat;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.utils.Feature;

@TargetApi(value=21)
public class PermissionBridgeActivity
extends Activity {
    private static final String TAG = "PermissionBridgeActivity";
    public static final String KEY_PERMISSION_TYPE = "permission_type";
    public static final String KEY_HAS_SYSTEM_WINDOW_PERMISS = "key_has_window_permiss";
    public static final String KEY_URL = "url";
    public static final String KEY_MIME_TYPE = "mime_type";
    public static final String KEY_SERVICE_INFO = "service_info";
    public static final String KEY_PLAYER_INFO = "player_info";
    public static final String KEY_IS_EXPAND = "is_expand";
    private static final int REQUEST_RECORD_AUDIO_PERMISSION = 10;
    private static final int REQUEST_MIRROR_PERMISSION = 1;
    private static final int OVERLAY_PERMISSION_REQ_CODE = 1234;
    public static final int VALUE_SDCARD_READ = 2;
    public static final int VALUE_AUDIO = 3;
    private boolean isNewCreate = true;
    private boolean isCheck = false;
    private boolean hasSystemWindowPermission = false;
    private boolean isRequestSystemWindow = false;
    private int mPermissionType = 0;
    private long start;
    private LelinkPlayerInfo mPlayerInfo;
    private static boolean isExpandMirror = false;
    private static Handler handler;
    private String mCastUrl = null;
    private int mCastMimeType = -1;
    private LelinkServiceInfo mServiceInfo;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        handler = new Handler(this.getMainLooper());
        this.setStyle();
        this.start = System.currentTimeMillis();
        Bundle bundle2 = this.getIntent().getExtras();
        this.mPermissionType = bundle2.getInt(KEY_PERMISSION_TYPE, 0);
        isExpandMirror = bundle2.getBoolean(KEY_IS_EXPAND, false);
        if (this.mPermissionType == 2) {
            this.mCastUrl = bundle2.getString(KEY_URL);
            this.mCastMimeType = bundle2.getInt(KEY_MIME_TYPE, -1);
        }
        try {
            this.mServiceInfo = (LelinkServiceInfo)bundle2.getParcelable(KEY_SERVICE_INFO);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        try {
            this.mPlayerInfo = (LelinkPlayerInfo)bundle2.getParcelable(KEY_PLAYER_INFO);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceLog.i(TAG, "PermissionBridgeActivity  onCreate " + this.mPermissionType);
    }

    private void setStyle() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.setStatusBarColor(0);
            window.setNavigationBarColor(0);
            window.addFlags(Integer.MIN_VALUE);
            window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() | 0x2000);
            this.setTitle(null);
            SourceLog.i(TAG, "change status bar style to trans");
        }
    }

    @TargetApi(value=23)
    protected void onResume() {
        super.onResume();
        try {
            if (this.mPermissionType != 3 && this.isCheck) {
                if (this.mPermissionType == 2) {
                    SourceLog.i(TAG, "send local media");
                    LelinkSdkManager.getInstance().startPlayMedia(this.mServiceInfo, this.mPlayerInfo, this.mCastUrl, this.mCastMimeType, true);
                }
                this.finishBridgeAct("onResume again");
                return;
            }
            if (this.mPermissionType == 2) {
                this.showPermission();
                return;
            }
            if (this.isNewCreate && !this.isRequestSystemWindow) {
                if (!this.isCheck && this.mPlayerInfo.getMirrorAudioType() != 0 && ContextCompat.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO") == -1) {
                    SourceLog.i(TAG, "not audio permission ");
                    this.showPermission();
                    return;
                }
                if (Build.VERSION.SDK_INT >= 23) {
                    this.hasSystemWindowPermission = Preference.getInstance().get(KEY_HAS_SYSTEM_WINDOW_PERMISS, false);
                    if (!this.hasSystemWindowPermission && !Feature.isMirrorCustomMode() && Preference.getInstance().get("key_request_window_permiss", true)) {
                        this.isRequestSystemWindow = true;
                        SourceLog.i(TAG, " -------------- > " + this.isRequestSystemWindow);
                        if (!Settings.canDrawOverlays((Context)this)) {
                            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getPackageName())));
                            this.startActivityForResult(intent, 1234);
                            return;
                        }
                        Preference.getInstance().put(KEY_HAS_SYSTEM_WINDOW_PERMISS, true);
                    }
                }
                this.registerMediaProjectionPermission(2);
            }
            this.isNewCreate = false;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            this.finishBridgeAct("onResume error");
        }
    }

    private void showPermission() {
        this.isCheck = true;
        if (this.mPermissionType == 2) {
            SourceLog.i(TAG, "start get sdcard permission");
            ActivityCompat.requestPermissions(this, new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return;
        }
        SourceLog.i(TAG, "start get audio permission");
        ActivityCompat.requestPermissions(this, new String[]{"android.permission.RECORD_AUDIO"}, 10);
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        SourceLog.i(TAG, "onActivityResult requestCode:" + n2 + " resultCode:" + n3);
        if (n2 == 1) {
            if (-1 == n3) {
                LelinkSdkManager.getInstance().startMirror(intent, this.mPlayerInfo, isExpandMirror);
            } else if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211002);
            }
        } else if (n2 == 1234) {
            handler.removeCallbacksAndMessages(null);
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PermissionBridgeActivity.this.registerMediaProjectionPermission(1);
                }
            }, 100L);
            return;
        }
        this.finishBridgeAct("onActivityResult");
    }

    public void registerMediaProjectionPermission(int n2) {
        block2: {
            try {
                MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
                SourceLog.i(TAG, "registerMediaProjectionPermission " + n2);
                Intent intent = mediaProjectionManager.createScreenCaptureIntent();
                this.startActivityForResult(intent, 1);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                if (BusinessEntity.getInstance().getListenerDispatcher() == null) break block2;
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211001);
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.finishBridgeAct("dispatchTouchEvent");
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    protected void onStop() {
        super.onStop();
        if (this.mPlayerInfo != null && this.mPlayerInfo.getType() != 2 && !this.isRequestSystemWindow) {
            this.finishBridgeAct("onStop");
        }
    }

    public void finishBridgeAct(String string) {
        SourceLog.i(TAG, "finish bridge act:" + string);
        SourceLog.i("ptime", System.currentTimeMillis() - this.start + "  s");
        this.finish();
    }
}

