/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.sdk.source.mdns.CacheMonitors;
import com.hpplay.sdk.source.mdns.Cacher;
import com.hpplay.sdk.source.mdns.Constants;
import com.hpplay.sdk.source.mdns.ListenerWrapper;
import com.hpplay.sdk.source.mdns.MessageInfos;
import com.hpplay.sdk.source.mdns.MulticastDNSCache;
import com.hpplay.sdk.source.mdns.MulticastDNSResponder;
import com.hpplay.sdk.source.mdns.Querier;
import com.hpplay.sdk.source.mdns.ReceiveMessageThread;
import com.hpplay.sdk.source.mdns.net.DatagramProcessor;
import com.hpplay.sdk.source.mdns.net.Packet;
import com.hpplay.sdk.source.mdns.net.PacketListener;
import com.hpplay.sdk.source.mdns.utils.Wait;
import com.hpplay.sdk.source.mdns.xbill.dns.Cache;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.OPTRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Opcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import com.hpplay.sdk.source.mdns.xbill.dns.SetResponse;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@SuppressLint(value={"LongLogTag"})
public class MulticastDNSMulticastOnlyQuerier
implements Querier,
PacketListener {
    public static final String TAG = "MulticastDNSMulticastOnlyQuerier";
    public CacheMonitors cacheMonitor;
    private static final boolean USE_ONLY_IPV4_ADDR = true;
    private static final boolean USE_ONLY_IPV6_ADDR = false;
    public static final int DEFAULT_EDNS_PAYLOADSIZE = 1280;
    protected boolean mdnsVerbose = false;
    protected boolean cacheVerbose = false;
    protected CopyOnWriteArrayList<ResolverListener> mResolverListener = new CopyOnWriteArrayList();
    protected MulticastDNSCache cache;
    protected Cacher cacher;
    protected InetAddress multicastAddress;
    protected int port = 5353;
    protected OPTRecord queryOPT;
    protected TSIG tsig;
    protected boolean ignoreTruncation = false;
    protected long timeoutValue = 6000L;
    protected long responseWaitTime = 500L;
    protected CopyOnWriteArrayList<DatagramProcessor> multicastProcessors = new CopyOnWriteArrayList();
    private ReceiveMessageThread mReceiveMessageThread;

    public MulticastDNSMulticastOnlyQuerier(boolean bl) {
        this(null, InetAddress.getByName(bl ? "FF02::FB" : "224.0.0.251"));
    }

    public MulticastDNSMulticastOnlyQuerier(InetAddress inetAddress, InetAddress inetAddress2) {
        if (this.mReceiveMessageThread == null) {
            this.mReceiveMessageThread = new ReceiveMessageThread();
            this.mReceiveMessageThread.start();
        }
        this.cacheMonitor = new CacheMonitors(this);
        this.mdnsVerbose = Options.check("mdns_verbose") || Options.check("verbose");
        this.cacheVerbose = Options.check("mdns_cache_verbose") || Options.check("cache_verbose");
        this.cache = MulticastDNSCache.getInstance();
        if (this.cache.getCacheMonitor() == null) {
            this.cache.setCacheMonitor(this.cacheMonitor);
        }
        this.setAddress(inetAddress2);
        if (inetAddress != null) {
            this.multicastProcessors.add(new DatagramProcessor(inetAddress, inetAddress2, this.port, this));
        } else {
            try {
                int n2 = this.getHostCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = this.getIpStr(i2);
                    if (TextUtils.isEmpty((CharSequence)string)) continue;
                    InetAddress inetAddress3 = InetAddress.getByName(string);
                    this.startMDNS(inetAddress3, inetAddress2);
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (Throwable)exception);
                InetAddress inetAddress4 = this.getDeviceIpAddress((Context)MulticastDNSMulticastOnlyQuerier.getApplication());
                this.startMDNS(inetAddress4, inetAddress2);
            }
        }
        this.cacher = new Cacher(this);
        this.registerListener(this.cacher);
        for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
            datagramProcessor.start();
        }
        MulticastDNSResponder multicastDNSResponder = new MulticastDNSResponder(this.mdnsVerbose, this);
        this.registerListener(multicastDNSResponder);
    }

    private void startMDNS(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress.getAddress().length == inetAddress2.getAddress().length) {
            DatagramProcessor datagramProcessor = new DatagramProcessor(inetAddress, inetAddress2, this.port, this);
            this.multicastProcessors.add(datagramProcessor);
        }
    }

    public InetAddress getDeviceIpAddress(Context context) {
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        InetAddress inetAddress = null;
        try {
            WifiManager wifiManager = (WifiManager)context2.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int n2 = wifiInfo.getIpAddress();
            byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return inetAddress;
    }

    public static Application getApplication() {
        Application application = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            Method method = clazz.getMethod("currentActivityThread", new Class[0]);
            Object object = method.invoke(null, (Object[])null);
            Method method2 = clazz.getMethod("getApplication", new Class[0]);
            application = (Application)method2.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return application;
    }

    public int getHostCount() {
        int n2 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!this.isUsableAddress(inetAddress)) continue;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return n2;
    }

    private boolean isUsableAddress(InetAddress inetAddress) {
        return !(inetAddress instanceof Inet6Address);
    }

    private String getIpStr(int n2) {
        int n3 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!this.isUsableAddress(inetAddress)) continue;
                    if (n3 < n2) {
                        ++n3;
                        continue;
                    }
                    String string = inetAddress.getHostAddress();
                    return string;
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return "";
    }

    @Override
    public void broadcast(Message message, boolean bl) {
        boolean bl2;
        Header header = message.getHeader();
        boolean bl3 = bl2 = header.getOpcode() == 5;
        if (bl2) {
            this.updateCache(MulticastDNSUtils.extractRecords(message, 0, 1, 2, 3), 4);
            this.writeMessageToWire(this.convertUpdateToQueryResponse(message));
        } else if (bl) {
            Message message2 = this.cache.queryCache(message, 1);
            for (Integer n2 : new Integer[]{1, 3, 2}) {
                Record[] recordArray = message2.getSectionArray(n2);
                if (recordArray == null || recordArray.length <= 0) continue;
                for (Record record : recordArray) {
                    if (message.findRecord(record)) continue;
                    message.addRecord(record, n2);
                }
            }
            this.writeMessageToWire(message);
        } else {
            this.writeMessageToWire(message);
        }
    }

    @Override
    public void close() {
        Log.i((String)TAG, (String)" mnds mQuerier release ");
        if (this.mReceiveMessageThread != null) {
            this.mReceiveMessageThread.release();
        }
        try {
            if (this.cache != null) {
                this.cache.close();
            }
            this.cache = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.multicastProcessors != null) {
            Log.i((String)TAG, (String)"...... multicastProcessors != null .......");
            for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
                try {
                    datagramProcessor.close();
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
            try {
                if (this.multicastProcessors != null) {
                    this.multicastProcessors.clear();
                    this.multicastProcessors = null;
                }
            }
            catch (Exception exception) {
                Log.w((String)"release", (Throwable)exception);
            }
        }
        try {
            if (this.mResolverListener != null) {
                this.mResolverListener.clear();
                this.mResolverListener = null;
            }
        }
        catch (Exception exception) {
            Log.w((String)"release", (Throwable)exception);
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Name[] getMulticastDomains() {
        boolean bl = this.isIPv4();
        boolean bl2 = this.isIPv6();
        if (bl && bl2) {
            return Constants.ALL_MULTICAST_DNS_DOMAINS;
        }
        if (bl) {
            return Constants.IPv4_MULTICAST_DOMAINS;
        }
        if (bl2) {
            return Constants.IPv6_MULTICAST_DOMAINS;
        }
        return new Name[0];
    }

    @Override
    public boolean isIPv4() {
        for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
            if (!datagramProcessor.isIPv4()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIPv6() {
        for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
            if (!datagramProcessor.isIPv6()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOperational() {
        for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
            if (datagramProcessor.isOperational()) continue;
            return false;
        }
        return this.cacheMonitor.isOperational();
    }

    @Override
    public void packetReceived(Packet packet) {
        byte[] byArray;
        if (this.mdnsVerbose) {
            Log.i((String)TAG, (String)"packetReceived mDNS Datagram Received!");
        }
        if ((byArray = packet.getData()).length > 0) {
            if (byArray.length < 12) {
                if (this.mdnsVerbose) {
                    Log.i((String)TAG, (String)"packetReceived Error parsing mDNS Response - Invalid DNS header - too short");
                }
                return;
            }
            try {
                Message message = this.parseMessage(byArray);
                if (this.mResolverListener != null) {
                    for (ResolverListener resolverListener : this.mResolverListener) {
                        resolverListener.receiveMessage(message.getHeader().getID(), message);
                    }
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (Throwable)exception);
            }
        }
    }

    @Override
    public ResolverListener registerListener(ResolverListener resolverListener) {
        this.mResolverListener.add(resolverListener);
        return resolverListener;
    }

    @Override
    public Message send(Message message) {
        if (message == null) {
            throw new IOException("Query is null");
        }
        Message message2 = (Message)message.clone();
        int n2 = message2.getHeader().getOpcode();
        switch (n2) {
            case 0: 
            case 1: {
                Message message3 = this.cache.queryCache(message2, 1);
                if (MulticastDNSUtils.answersAll(message2, message3)) {
                    return message3;
                }
                final ArrayList arrayList = new ArrayList();
                final ArrayList arrayList2 = new ArrayList();
                this.sendAsync(message2, new ResolverListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleException(Object object, Exception exception) {
                        List list = arrayList;
                        synchronized (list) {
                            arrayList2.add(exception);
                            arrayList.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void receiveMessage(Object object, Message message) {
                        List list = arrayList;
                        synchronized (list) {
                            arrayList.add(message);
                            arrayList.notifyAll();
                        }
                    }
                });
                Wait.forResponse(arrayList);
                if (arrayList2.size() <= 0) break;
                Exception exception = (Exception)arrayList2.get(0);
                IOException iOException = new IOException(exception.getMessage());
                iOException.setStackTrace(exception.getStackTrace());
                throw iOException;
            }
            case 5: {
                this.broadcast(message2, false);
                break;
            }
            default: {
                throw new IOException("Don't know what to do with Opcode: " + Opcode.string(n2) + " queries.");
            }
        }
        return this.cache.queryCache(message2, 1);
    }

    @Override
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Message message2 = (Message)message.clone();
        Integer n2 = message2.getHeader().getID();
        int n3 = message2.getHeader().getOpcode();
        ListenerWrapper listenerWrapper = new ListenerWrapper(n2, message2, resolverListener, this);
        this.registerListener(listenerWrapper);
        switch (n3) {
            case 0: 
            case 1: {
                try {
                    Message message3 = this.cache.queryCache(message2, 1);
                    if (message3 != null && message3.getRcode() == 0 && MulticastDNSUtils.answersAll(message2, message3)) {
                        MessageInfos messageInfos = new MessageInfos();
                        messageInfos.setIds(n2);
                        messageInfos.setListener(resolverListener);
                        messageInfos.setMessage(message3);
                        this.mReceiveMessageThread.updateReceiveData(messageInfos);
                    }
                    try {
                        this.broadcast(message2, false);
                    }
                    catch (IOException iOException) {
                        this.unregisterListener(listenerWrapper);
                        resolverListener.handleException(n2, iOException);
                    }
                    int n4 = Options.intValue("mdns_resolve_wait");
                    long l2 = System.currentTimeMillis() + (long)(n4 > 0 ? n4 : 500);
                    l2 = 3000L;
                    this.unregisterListener(listenerWrapper);
                }
                catch (Exception exception) {
                    resolverListener.handleException(n2, exception);
                }
                break;
            }
            case 5: {
                try {
                    this.broadcast(message2, false);
                }
                catch (Exception exception) {
                    resolverListener.handleException(n2, exception);
                    this.unregisterListener(listenerWrapper);
                }
                break;
            }
            default: {
                resolverListener.handleException(n2, new IOException("Don't know what to do with Opcode: " + Opcode.string(n3) + " queries."));
                this.unregisterListener(listenerWrapper);
            }
        }
        return n2;
    }

    public void setAddress(InetAddress inetAddress) {
        this.multicastAddress = inetAddress;
    }

    public void setCache(Cache cache) {
        if (cache instanceof MulticastDNSCache) {
            this.cache = (MulticastDNSCache)cache;
            if (this.cache.getCacheMonitor() == null) {
                this.cache.setCacheMonitor(this.cacheMonitor);
            }
        } else {
            try {
                this.cache = new MulticastDNSCache(cache);
                if (this.cache.getCacheMonitor() == null) {
                    this.cache.setCacheMonitor(this.cacheMonitor);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not set Cache - " + exception.getMessage());
            }
        }
    }

    @Override
    public void setEDNS(int n2) {
        this.setEDNS(n2, 0, 0, null);
    }

    @Override
    public void setEDNS(int n2, int n3, int n4, List list) {
        if (n2 != 0 && n2 != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (n3 == 0) {
            n3 = 1280;
        }
        this.queryOPT = new OPTRecord(n3, 0, n2, n4, list);
    }

    @Override
    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    @Override
    public void setPort(int n2) {
        this.port = n2;
    }

    @Override
    public void setRetryWaitTime(int n2) {
        this.setRetryWaitTime(n2, 0);
    }

    @Override
    public void setRetryWaitTime(int n2, int n3) {
        this.responseWaitTime = (long)n2 * 1000L + (long)n3;
    }

    @Override
    public void setTCP(boolean bl) {
    }

    @Override
    public void setTimeout(int n2) {
        this.setTimeout(n2, 0);
    }

    @Override
    public void setTimeout(int n2, int n3) {
        this.timeoutValue = (long)n2 * 1000L + (long)n3;
    }

    @Override
    public void setTSIGKey(TSIG tSIG) {
        this.tsig = tSIG;
    }

    @Override
    public synchronized boolean unregisterListener(ResolverListener resolverListener) {
        try {
            if (this.mResolverListener == null) {
                return false;
            }
            return this.mResolverListener.remove(resolverListener);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean initNetWorkState() {
        return false;
    }

    protected void applyEDNS(Message message) {
        if (this.queryOPT == null || message.getOPT() != null) {
            return;
        }
        message.addRecord(this.queryOPT, 3);
    }

    protected Message convertUpdateToQueryResponse(Message message) {
        int n2;
        Message message2 = new Message();
        Header header = message2.getHeader();
        header.setOpcode(0);
        header.setFlag(5);
        header.setFlag(0);
        Record[] recordArray = message.getSectionArray(2);
        for (n2 = 0; n2 < recordArray.length; ++n2) {
            message2.addRecord(recordArray[n2], 1);
        }
        recordArray = message.getSectionArray(3);
        for (n2 = 0; n2 < recordArray.length; ++n2) {
            message2.addRecord(recordArray[n2], 3);
        }
        return message2;
    }

    protected Message parseMessage(byte[] byArray) {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            if (this.mdnsVerbose) {
                iOException.printStackTrace(System.err);
            }
            Exception exception = new Exception("Error parsing message - " + iOException.getMessage());
            exception.setStackTrace(iOException.getStackTrace());
            throw exception;
        }
    }

    protected int verifyTSIG(Message message, Message message2, byte[] byArray, TSIG tSIG) {
        if (tSIG == null) {
            return 0;
        }
        int n2 = tSIG.verify(message2, byArray, message.getTSIG());
        return n2;
    }

    protected void writeMessageToWire(Message message) {
        Header header = message.getHeader();
        header.setID(0);
        this.applyEDNS(message);
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        byte[] byArray = message.toWire(65535);
        for (DatagramProcessor datagramProcessor : this.multicastProcessors) {
            OPTRecord oPTRecord = message.getOPT();
            int n2 = oPTRecord != null ? oPTRecord.getPayloadSize() : datagramProcessor.getMaxPayloadSize();
            if (byArray.length > n2) {
                if (header.getFlag(0)) {
                    throw new IOException("DNS Message too large! - " + byArray.length + " bytes in size.");
                }
                Message[] messageArray = MulticastDNSUtils.splitMessage(message);
                for (int i2 = 0; i2 < messageArray.length; ++i2) {
                    this.writeMessageToWire(messageArray[i2]);
                }
                return;
            }
            try {
                datagramProcessor.send(byArray);
            }
            catch (Exception exception) {
                for (ResolverListener resolverListener : this.mResolverListener) {
                    resolverListener.handleException(TAG, exception);
                }
            }
        }
    }

    protected void writeResponse(Message message) {
        Header header = message.getHeader();
        header.setFlag(5);
        header.setFlag(0);
        header.setRcode(0);
        this.writeMessageToWire(message);
    }

    protected void updateCache(Record[] recordArray, int n2) {
        if (recordArray != null && recordArray.length > 0) {
            for (int i2 = 0; i2 < recordArray.length; ++i2) {
                Record record = recordArray[i2];
                try {
                    Record record2 = MulticastDNSUtils.clone(record);
                    MulticastDNSUtils.setDClassForRecord(record2, record2.getDClass() & Short.MAX_VALUE);
                    if (record2.getTTL() > 0L) {
                        SetResponse setResponse = this.cache.lookupRecords(record2.getName(), record2.getType(), 1);
                        RRset[] rRsetArray = setResponse.answers();
                        if (rRsetArray != null && rRsetArray.length > 0) {
                            Record[] recordArray2 = MulticastDNSUtils.extractRecords(rRsetArray);
                            if (recordArray2 == null || recordArray2.length <= 0) continue;
                            this.cache.updateRRset(record2, n2);
                            continue;
                        }
                        this.cache.addRecord(record2, n2, null);
                        continue;
                    }
                    this.cache.removeElementCopy(record2.getName(), record2.getType());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

