/*
 * Decompiled with CFR 0.152.
 */
package android_serialport_api;

import android.util.Log;
import android_serialport_api.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public class ComPort {
    private static final String TAG = "ComPort";
    private SerialPort mSerialPort;
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private ReadThread mReadThread;
    public String mComname;
    private int boardRate = 115200;
    private boolean isOpen = false;
    private DataHandler dataHandler;

    public void setHandler(DataHandler handler) {
        this.dataHandler = handler;
    }

    public boolean open(String comName, int boardRate, DataHandler handler) {
        if (this.isOpen) {
            Log.e((String)TAG, (String)"Comport already open. Please close it before reopening.");
            return false;
        }
        this.dataHandler = handler;
        this.mComname = comName;
        this.boardRate = boardRate;
        try {
            if (this.mSerialPort == null) {
                this.mSerialPort = new SerialPort();
                if (!this.mSerialPort.openPort(new File(this.mComname), boardRate, 0)) {
                    Log.e((String)TAG, (String)("Failed to open serial port: " + comName));
                    return false;
                }
            }
            if (this.mOutputStream == null) {
                this.mOutputStream = this.mSerialPort.getOutputStream();
            }
            if (this.mInputStream == null) {
                this.mInputStream = this.mSerialPort.getInputStream();
            }
            if (this.mReadThread == null) {
                this.mReadThread = new ReadThread();
                this.mReadThread.start();
            }
            this.isOpen = true;
        }
        catch (SecurityException | InvalidParameterException e) {
            Log.e((String)TAG, (String)"Error while opening serial port", (Throwable)e);
            return false;
        }
        return true;
    }

    public void close() {
        this.isOpen = false;
        try {
            this.closeStream(this.mOutputStream);
            this.closeStream(this.mInputStream);
            this.closeThread(this.mReadThread);
            if (this.mSerialPort != null) {
                this.mSerialPort.close();
                this.mSerialPort = null;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error closing resources", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(byte[] buffer, int size) {
        if (this.mOutputStream != null) {
            try {
                ComPort comPort = this;
                synchronized (comPort) {
                    this.mOutputStream.write(buffer, 0, size);
                    this.mOutputStream.flush();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error sending data", (Throwable)e);
            }
        } else {
            Log.w((String)TAG, (String)"Output stream is not available");
        }
    }

    private void closeStream(OutputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    private void closeStream(InputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    private void closeThread(Thread thread) {
        if (thread != null) {
            thread.interrupt();
            this.mReadThread = null;
        }
    }

    private void onDataReceived(byte[] buffer, int size) {
        if (this.dataHandler != null) {
            this.dataHandler.onDataReceived(this.mComname, buffer, size);
        }
    }

    public static interface DataHandler {
        public void onDataReceived(String var1, byte[] var2, int var3);
    }

    private class ReadThread
    extends Thread {
        private byte[] buffer = new byte[128];

        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    if (ComPort.this.mInputStream == null) {
                        return;
                    }
                    int size = ComPort.this.mInputStream.read(this.buffer);
                    if (size <= 0) continue;
                    ComPort.this.onDataReceived(this.buffer, size);
                }
                catch (IOException e) {
                    Log.e((String)ComPort.TAG, (String)"Error while reading from serial port", (Throwable)e);
                    return;
                }
            }
            Log.i((String)ComPort.TAG, (String)"Com read thread exited.");
        }
    }
}

