/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.content.ContentValues;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.herohan.uvcapp.IImageCapture;
import com.herohan.uvcapp.ImageSaver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageSaver2
implements Runnable {
    private static final String TAG = ImageSaver.class.getSimpleName();
    private static final int PENDING = 1;
    private static final int NOT_PENDING = 0;
    private final Bitmap mImage;
    private final int mWidth;
    private final int mHeight;
    private final int mJpegQuality;
    @NonNull
    private final IImageCapture.OutputFileOptions mOutputFileOptions;
    @NonNull
    private final OnImageSavedCallback mCallback;

    public ImageSaver2(Bitmap image, int width, int height, @IntRange(from=1L, to=100L) int jpegQuality, @NonNull IImageCapture.OutputFileOptions outputFileOptions, @NonNull OnImageSavedCallback callback) {
        this.mImage = image;
        this.mWidth = width;
        this.mHeight = height;
        this.mJpegQuality = jpegQuality;
        this.mOutputFileOptions = outputFileOptions;
        this.mCallback = callback;
    }

    @Override
    public void run() {
        SaveError saveError = null;
        String errorMessage = null;
        IOException exception = null;
        Uri outputUri = null;
        try {
            byte[] data = this.imageToJpegByteArray(this.mImage, this.mJpegQuality);
            if (data == null) {
                saveError = SaveError.ENCODE_FAILED;
                errorMessage = "Failed to encode mImage";
            } else if (this.isSaveToMediaStore()) {
                ContentValues values = this.mOutputFileOptions.getContentValues() != null ? new ContentValues(this.mOutputFileOptions.getContentValues()) : new ContentValues();
                this.setContentValuePending(values, 1);
                outputUri = this.mOutputFileOptions.getContentResolver().insert(this.mOutputFileOptions.getSaveCollection(), values);
                if (outputUri == null) {
                    saveError = SaveError.FILE_IO_FAILED;
                    errorMessage = "Failed to insert URI.";
                } else {
                    if (!this.copyByteArrayToUri(data, outputUri)) {
                        saveError = SaveError.FILE_IO_FAILED;
                        errorMessage = "Failed to save to URI.";
                    }
                    this.setUriNotPending(outputUri);
                }
            } else if (this.isSaveToOutputStream()) {
                this.mOutputFileOptions.getOutputStream().write(data);
            } else if (this.isSaveToFile()) {
                File targetFile = this.mOutputFileOptions.getFile();
                this.copyByteArrayToFile(data, targetFile);
                outputUri = Uri.fromFile((File)targetFile);
            }
        }
        catch (IOException e) {
            saveError = SaveError.FILE_IO_FAILED;
            errorMessage = "Failed to write destination file.";
            exception = e;
        }
        if (saveError != null) {
            this.mCallback.onError(saveError, errorMessage, exception);
        } else {
            this.mCallback.onImageSaved(new IImageCapture.OutputFileResults(outputUri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] imageToJpegByteArray(Bitmap image, int jpegQuality) {
        block12: {
            Bitmap bmp = null;
            try {
                byte[] byArray;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    bmp = Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
                    bmp.compress(Bitmap.CompressFormat.JPEG, jpegQuality, (OutputStream)out);
                    byArray = out.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"failed to save file", (Throwable)e);
                        break block12;
                    }
                }
                out.close();
                return byArray;
            }
            finally {
                if (bmp != null) {
                    bmp.recycle();
                }
                if (image != null) {
                    image.recycle();
                }
            }
        }
        return null;
    }

    private boolean isSaveToMediaStore() {
        return this.mOutputFileOptions.getSaveCollection() != null && this.mOutputFileOptions.getContentResolver() != null && this.mOutputFileOptions.getContentValues() != null;
    }

    private boolean isSaveToFile() {
        return this.mOutputFileOptions.getFile() != null;
    }

    private boolean isSaveToOutputStream() {
        return this.mOutputFileOptions.getOutputStream() != null;
    }

    private void setContentValuePending(@NonNull ContentValues values, int isPending) {
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("is_pending", Integer.valueOf(isPending));
        }
    }

    private void setUriNotPending(@NonNull Uri outputUri) {
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues values = new ContentValues();
            this.setContentValuePending(values, 0);
            this.mOutputFileOptions.getContentResolver().update(outputUri, values, null, null);
        }
    }

    private boolean copyByteArrayToUri(@NonNull byte[] data, @NonNull Uri uri) throws IOException {
        try (OutputStream outputStream = this.mOutputFileOptions.getContentResolver().openOutputStream(uri);){
            if (outputStream == null) {
                boolean bl = false;
                return bl;
            }
            outputStream.write(data);
        }
        return true;
    }

    private boolean copyByteArrayToFile(@NonNull byte[] data, @NonNull File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(data);
        }
        return true;
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(@NonNull IImageCapture.OutputFileResults var1);

        public void onError(@NonNull SaveError var1, @NonNull String var2, @Nullable Throwable var3);
    }

    public static enum SaveError {
        FILE_IO_FAILED,
        ENCODE_FAILED,
        UNKNOWN;

    }
}

