/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.hpplay.glide.load.DecodeFormat;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.engine.cache.MemoryCache;
import com.hpplay.glide.load.engine.prefill.BitmapPreFillRunner;
import com.hpplay.glide.load.engine.prefill.PreFillQueue;
import com.hpplay.glide.load.engine.prefill.PreFillType;
import com.hpplay.glide.util.Util;
import java.util.HashMap;

public final class BitmapPreFiller {
    private final MemoryCache memoryCache;
    private final BitmapPool bitmapPool;
    private final DecodeFormat defaultFormat;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private BitmapPreFillRunner current;

    public BitmapPreFiller(MemoryCache memoryCache, BitmapPool bitmapPool, DecodeFormat decodeFormat) {
        this.memoryCache = memoryCache;
        this.bitmapPool = bitmapPool;
        this.defaultFormat = decodeFormat;
    }

    public void preFill(PreFillType.Builder ... builderArray) {
        if (this.current != null) {
            this.current.cancel();
        }
        PreFillType[] preFillTypeArray = new PreFillType[builderArray.length];
        for (int i2 = 0; i2 < builderArray.length; ++i2) {
            PreFillType.Builder builder = builderArray[i2];
            if (builder.getConfig() == null) {
                builder.setConfig(this.defaultFormat == DecodeFormat.ALWAYS_ARGB_8888 || this.defaultFormat == DecodeFormat.PREFER_ARGB_8888 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565);
            }
            preFillTypeArray[i2] = builder.build();
        }
        PreFillQueue preFillQueue = this.generateAllocationOrder(preFillTypeArray);
        this.current = new BitmapPreFillRunner(this.bitmapPool, this.memoryCache, preFillQueue);
        this.handler.post((Runnable)this.current);
    }

    PreFillQueue generateAllocationOrder(PreFillType[] preFillTypeArray) {
        int n2 = this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize() + this.bitmapPool.getMaxSize();
        int n3 = 0;
        for (PreFillType preFillType : preFillTypeArray) {
            n3 += preFillType.getWeight();
        }
        float f2 = (float)n2 / (float)n3;
        HashMap<PreFillType, Integer> hashMap = new HashMap<PreFillType, Integer>();
        for (PreFillType preFillType : preFillTypeArray) {
            int n4 = Math.round(f2 * (float)preFillType.getWeight());
            int n5 = BitmapPreFiller.getSizeInBytes(preFillType);
            int n6 = n4 / n5;
            hashMap.put(preFillType, n6);
        }
        return new PreFillQueue(hashMap);
    }

    private static int getSizeInBytes(PreFillType preFillType) {
        return Util.getBitmapByteSize(preFillType.getWidth(), preFillType.getHeight(), preFillType.getConfig());
    }
}

