/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.hpplay.common.log.LeLog;

public class ScreenUtil {
    private static final String TAG = "ScreenUtil";

    private ScreenUtil() {
    }

    public static int getScreenWidth(Context context) {
        if (null == context) {
            LeLog.i(TAG, "getScreenWidth fail  context is:" + context);
            return -1;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        if (null == context) {
            LeLog.i(TAG, "getScreenWidth fail  context is:" + context);
            return -1;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public static int[] getRelScreenSize(Context context) {
        int[] nArray = new int[2];
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n2 = displayMetrics.widthPixels;
        int n3 = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                n2 = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                n3 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point point = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, point);
                n2 = point.x;
                n3 = point.y;
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
        LeLog.i("ScreenUtils", " widthPixels  " + n2 + " heightPixels " + n3);
        return nArray;
    }
}

