/*
 * Decompiled with CFR 0.152.
 */
package com.wizapply.libspap;

import android.serialport.SerialPort;
import android.serialport.SerialPortFinder;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PCIUART
implements Runnable {
    private static final String TAG = PCIUART.class.getSimpleName();
    private static final int READ_WAIT_MILLIS = 10;
    private static final int BUFSIZ = 0x400000;
    private SerialPort mSerialPort;
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private final ByteBuffer mReadBuffer;
    private boolean notfound;
    public State mState;

    public PCIUART(String filename, int baudrate, int parity, int stopBits, int dataBits) {
        block9: {
            this.mSerialPort = null;
            this.mOutputStream = null;
            this.mInputStream = null;
            this.mReadBuffer = ByteBuffer.allocate(0x400000);
            this.notfound = false;
            this.mState = State.NONE;
            SerialPortFinder serialPortFinder = new SerialPortFinder();
            String[] devices = serialPortFinder.getAllDevicesPath();
            if (!Arrays.asList(devices).contains(filename)) {
                this.mState = State.NONE;
                return;
            }
            this.mState = State.STOPPED;
            try {
                File device = new File(filename);
                this.mSerialPort = SerialPort.newBuilder(device, baudrate).parity(parity).dataBits(dataBits).stopBits(stopBits).build();
                this.mOutputStream = this.mSerialPort.getOutputStream();
                this.mInputStream = this.mSerialPort.getInputStream();
            }
            catch (Throwable tr) {
                this.mState = State.NONE;
                if (this.mOutputStream != null) {
                    try {
                        this.mOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mInputStream != null) {
                    try {
                        this.mInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mSerialPort == null) break block9;
                this.mSerialPort.close();
            }
        }
    }

    public void writeAsync(byte[] data) {
        if (this.mOutputStream == null) {
            return;
        }
        try {
            this.mOutputStream.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeAsync(byte[] data, int data_size) {
        if (this.mOutputStream == null) {
            return;
        }
        try {
            this.mOutputStream.write(data, 0, data_size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] data, int data_size, boolean discard_null) {
        int get_size = 0;
        ByteBuffer byteBuffer = this.mReadBuffer;
        synchronized (byteBuffer) {
            int i = 0;
            this.mReadBuffer.flip();
            try {
                for (i = 0; i < data_size && this.mReadBuffer.hasRemaining(); ++i) {
                    byte d = this.mReadBuffer.get();
                    if (discard_null && d == 0) continue;
                    data[get_size] = d;
                    ++get_size;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            this.mReadBuffer.compact();
        }
        return get_size;
    }

    public int readDataAvailable() {
        return this.mReadBuffer.position();
    }

    public void stop() {
        if (this.getState() == State.RUNNING) {
            Log.i((String)TAG, (String)"Stop requested");
            this.mState = State.STOPPING;
        }
    }

    public State getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PCIUART pCIUART = this;
        synchronized (pCIUART) {
            if (this.getState() == State.RUNNING || this.getState() == State.STOPPING) {
                throw new IllegalStateException("Already running.");
            }
            this.mState = State.RUNNING;
        }
        try {
            while (true) {
                if (this.getState() != State.RUNNING) {
                    Log.i((String)TAG, (String)("Stopping mState=" + (Object)((Object)this.getState())));
                }
                this.step();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Run ending due to exception: " + e.getMessage()), (Throwable)e);
        }
        finally {
            PCIUART pCIUART2 = this;
            synchronized (pCIUART2) {
                if (this.mOutputStream != null) {
                    try {
                        this.mOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mInputStream != null) {
                    try {
                        this.mInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mSerialPort != null) {
                    this.mSerialPort.close();
                }
                this.mState = State.STOPPED;
                Log.i((String)TAG, (String)"Stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step() throws IOException {
        int len = 0;
        byte[] readbuffers = new byte[4096];
        len = this.mInputStream.read(readbuffers);
        if (len > 0) {
            ByteBuffer byteBuffer = this.mReadBuffer;
            synchronized (byteBuffer) {
                this.mReadBuffer.put(readbuffers, 0, len);
            }
        }
    }

    public static enum State {
        NONE,
        STOPPED,
        RUNNING,
        STOPPING;

    }
}

