/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import com.hpplay.sdk.source.mdns.ServiceName;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.SRVRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.TXTRecord;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceInstance
implements Serializable {
    private static final long serialVersionUID = 201210181454L;
    private final List pointers = new ArrayList();
    private final ServiceName name;
    private Name host;
    private List addresses = new ArrayList();
    private int priority;
    private int weight;
    private int port;
    private final Map textAttributes = new LinkedHashMap();
    private String niceText;
    private String[] text;

    public ServiceInstance(ServiceName serviceName, int n2, int n3, int n4, Name name, String ... stringArray) {
        this(serviceName, n2, n3, n4, name, new InetAddress[]{InetAddress.getLocalHost()}, stringArray);
    }

    public ServiceInstance(ServiceName serviceName, int n2, int n3, int n4, Name name, InetAddress[] inetAddressArray, Collection collection) {
        this(serviceName, n2, n3, n4, name, inetAddressArray, ServiceInstance.parseTextRecords(collection));
    }

    public ServiceInstance(ServiceName serviceName, int n2, int n3, int n4, Name name, InetAddress[] inetAddressArray, Map map) {
        this.name = serviceName;
        this.host = name;
        this.priority = n2;
        this.weight = n3;
        this.port = n4;
        if (inetAddressArray != null) {
            this.addresses = new ArrayList<InetAddress>(Arrays.asList(inetAddressArray));
        }
        if (map != null) {
            this.textAttributes.putAll(map);
            this.text = new String[map.size()];
            Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[map.size()]);
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                this.text[i2] = entryArray[i2].getKey() + "=" + entryArray[i2].getValue();
            }
        }
    }

    public ServiceInstance(ServiceName serviceName, int n2, int n3, int n4, Name name, InetAddress[] inetAddressArray, String ... stringArray) {
        this(serviceName, n2, n3, n4, name, inetAddressArray, ServiceInstance.parseTextRecords(stringArray));
    }

    public ServiceInstance(ServiceName serviceName, int n2, int n3, int n4, Name name, InetAddress[] inetAddressArray, TXTRecord ... tXTRecordArray) {
        this(serviceName, n2, n3, n4, name, inetAddressArray, ServiceInstance.parseTextRecords(tXTRecordArray));
    }

    public ServiceInstance(SRVRecord sRVRecord) {
        this(new ServiceName(sRVRecord.getName()), sRVRecord.getPriority(), sRVRecord.getWeight(), sRVRecord.getPort(), sRVRecord.getTarget(), null, (Map)null);
    }

    public void addAddress(InetAddress inetAddress) {
        if (!this.addresses.contains(inetAddress)) {
            this.addresses.add(inetAddress);
        }
    }

    public void addPointer(Name name) {
        if (!this.pointers.contains(name)) {
            this.pointers.add(name);
        }
    }

    public void addText(Map map) {
        if (map != null) {
            this.textAttributes.putAll(map);
        }
    }

    public void addText(String string, String string2) {
        this.textAttributes.put(string, string2);
    }

    public void addTextRecords(TXTRecord ... tXTRecordArray) {
        Map map = ServiceInstance.parseTextRecords(tXTRecordArray);
        if (map != null) {
            this.textAttributes.putAll(map);
        }
    }

    public InetAddress[] getAddresses() {
        return this.addresses == null || this.addresses.size() == 0 ? null : this.addresses.toArray(new InetAddress[this.addresses.size()]);
    }

    public Name getHost() {
        return this.host;
    }

    public ServiceName getName() {
        return this.name;
    }

    public String getNiceText() {
        return this.niceText;
    }

    public Name[] getPointers() {
        return this.pointers == null || this.pointers.size() == 0 ? null : this.pointers.toArray(new Name[this.pointers.size()]);
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public String[] getText() {
        return this.text;
    }

    public Map getTextAttributes() {
        return this.textAttributes;
    }

    public int getWeight() {
        return this.weight;
    }

    public void removeAddress(InetAddress inetAddress) {
        this.addresses.remove(inetAddress);
    }

    public void removePointer(Name name) {
        this.pointers.remove(name);
    }

    public void removeTextRecords(TXTRecord ... tXTRecordArray) {
        Map map = ServiceInstance.parseTextRecords(tXTRecordArray);
        if (map != null) {
            for (Object k2 : map.keySet()) {
                this.textAttributes.remove(k2);
            }
        }
    }

    public void setAddresses(List list) {
        if (list != null) {
            this.addresses.clear();
            this.addresses.addAll(list);
        }
    }

    public void setHost(Name name) {
        this.host = name;
    }

    public void setNiceText(String string) {
        this.niceText = string;
    }

    public void setPointers(List list) {
        if (list != null) {
            this.pointers.clear();
            this.pointers.addAll(list);
        }
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public void setWeight(int n2) {
        this.weight = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Service (\"").append(this.name).append("\"");
        if (this.host != null) {
            stringBuilder.append(" can be reached at \"").append(this.host).append("\" ").append(Arrays.toString(this.getAddresses()));
        }
        if (this.port > 0) {
            stringBuilder.append(" on port ").append(this.getPort());
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (this.textAttributes != null && this.textAttributes.size() > 0) {
            Iterator iterator = this.textAttributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                if (stringBuilder2.length() == 0) {
                    stringBuilder.append("\n\tTXT: ");
                }
                stringBuilder2.append(entry2.getKey());
                Object v2 = entry2.getValue();
                if (v2 != null) {
                    stringBuilder2.append("=\"").append(v2.toString()).append("\"");
                }
                stringBuilder2.append(", ");
                if (stringBuilder2.length() <= 100) continue;
                stringBuilder2.setLength(stringBuilder.length() - 2);
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2.setLength(0);
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.setLength(stringBuilder.length() - 2);
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2.setLength(0);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected static Map parseTextRecords(Object object) {
        String[] stringArray;
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object.getClass().isArray()) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Object[] objectArray = (Object[])object;
            if (objectArray != null && objectArray.length > 0) {
                linkedHashMap = new LinkedHashMap();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Map map = ServiceInstance.parseTextRecords(objectArray[i2]);
                    if (map == null || map.size() <= 0) continue;
                    linkedHashMap.putAll(map);
                }
            }
            return linkedHashMap;
        }
        if (object instanceof Collection) {
            return ServiceInstance.parseTextRecords(((Collection)object).toArray());
        }
        if (object instanceof TXTRecord) {
            return ServiceInstance.parseTextRecords(((TXTRecord)object).getStrings().toArray());
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : stringArray = ServiceInstance.split(object.toString())) {
            if (string == null || string.length() <= 0) continue;
            String string2 = "";
            String string3 = "";
            int n2 = string.indexOf(61);
            if (n2 >= 0) {
                string2 = string.substring(0, n2);
                if (++n2 <= string.length()) {
                    string3 = string.substring(n2);
                }
            } else {
                string2 = string;
            }
            linkedHashMap.put(string2, string3);
        }
        return linkedHashMap;
    }

    private static String[] split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = (string + '\n').toCharArray();
        block4: for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!Character.isWhitespace(cArray[i2])) {
                switch (cArray[i2]) {
                    case '\\': {
                        bl2 = true;
                        break;
                    }
                    case '\"': {
                        if (!bl2) {
                            bl = !bl;
                            break;
                        }
                        stringBuilder.append(cArray[i2]);
                        break;
                    }
                    default: {
                        stringBuilder.append(cArray[i2]);
                        if (!bl2) continue block4;
                        bl2 = false;
                        break;
                    }
                }
                continue;
            }
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

