/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.util.Base64;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.utils.Encode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONObject;

public class HttpEncrypt {
    private static final String TAG = "HttpEncrypt";
    private static final String KEY = "23046885";
    private static final String X_LB_EN = "x-lb-en";
    private static final String X_LB_EN_RAND = "x-lb-en-rand";
    private static final String X_LB_EN_VALUE = "2";
    private static final String ENCRYPT_DATA = "encryptedData";
    private String randomKey = this.getRandomKey();

    public Map<String, String> buildHeader() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(X_LB_EN, X_LB_EN_VALUE);
        hashMap.put(X_LB_EN_RAND, this.randomKey);
        return hashMap;
    }

    public String encode(String string) {
        LeLog.i(TAG, "encode, randomKey: " + this.randomKey + " , " + string);
        JSONObject jSONObject = new JSONObject();
        try {
            byte[] byArray = Encode.encodeToByte(string, this.randomKey + KEY);
            string = Base64.encodeToString((byte[])byArray, (int)2);
            jSONObject.put(ENCRYPT_DATA, (Object)string);
        }
        catch (Exception exception) {
            LeLog.w(TAG, "encode: " + exception);
        }
        LeLog.i(TAG, "encode, " + jSONObject.toString());
        return jSONObject.toString();
    }

    public String decode(AsyncHttpParameter.Out out) {
        String string = out.result;
        Map<String, List<String>> map = out.headers;
        LeLog.i(TAG, "decode, headers = " + map);
        if (map == null) {
            return string;
        }
        List<String> list = map.get(X_LB_EN);
        if (list == null || list.size() < 1 || !X_LB_EN_VALUE.equals(list.get(0))) {
            return string;
        }
        List<String> list2 = map.get(X_LB_EN_RAND);
        if (list2 == null || list2.size() < 1) {
            return string;
        }
        return this.decode(string, list2.get(0));
    }

    private String decode(String string, String string2) {
        LeLog.w(TAG, "decode, randomKey: " + string2);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string3 = jSONObject.optString(ENCRYPT_DATA);
            byte[] byArray = Base64.decode((String)string3, (int)2);
            string = Encode.decodeByteToString(byArray, string2 + KEY);
        }
        catch (Exception exception) {
            LeLog.w(TAG, "decode: " + exception);
        }
        LeLog.w(TAG, "decode, result: " + string);
        return string;
    }

    private String getRandomKey() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        for (int i2 = 0; i2 < 8; ++i2) {
            if (random.nextInt(2) % 2 == 0) {
                if (random.nextInt(2) % 2 == 0) {
                    stringBuilder.append((char)(random.nextInt(27) + 65));
                    continue;
                }
                stringBuilder.append((char)(random.nextInt(27) + 97));
                continue;
            }
            stringBuilder.append(random.nextInt(10));
        }
        return stringBuilder.toString();
    }
}

