/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.xml;

import com.hpplay.cybergarage.xml.Attribute;
import com.hpplay.cybergarage.xml.AttributeList;
import com.hpplay.cybergarage.xml.NodeList;
import com.hpplay.cybergarage.xml.XML;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class Node {
    private Node parentNode = null;
    private String name = new String();
    private String value = new String();
    private AttributeList attrList = new AttributeList();
    private NodeList nodeList = new NodeList();
    private Object userData = null;

    public Node() {
        this.setUserData(null);
        this.setParentNode(null);
    }

    public Node(String string) {
        this();
        this.setName(string);
    }

    public Node(String string, String string2) {
        this();
        this.setName(string, string2);
    }

    public Node(Node node) {
        this();
        this.set(node);
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getRootNode() {
        Node node = null;
        Node node2 = this.getParentNode();
        while (node2 != null) {
            node = node2;
            node2 = node.getParentNode();
        }
        return node;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setName(String string, String string2) {
        this.name = string + ":" + string2;
    }

    public String getName() {
        return this.name;
    }

    public boolean isName(String string) {
        return this.name.equals(string);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setValue(int n2) {
        this.setValue(Integer.toString(n2));
    }

    public void addValue(String string) {
        if (this.value == null) {
            this.value = string;
            return;
        }
        if (string != null) {
            this.value = this.value + string;
        }
    }

    public String getValue() {
        return this.value;
    }

    public int getNAttributes() {
        return this.attrList.size();
    }

    public Attribute getAttribute(int n2) {
        return this.attrList.getAttribute(n2);
    }

    public Attribute getAttribute(String string) {
        return this.attrList.getAttribute(string);
    }

    public void addAttribute(Attribute attribute) {
        this.attrList.add(attribute);
    }

    public void insertAttributeAt(Attribute attribute, int n2) {
        this.attrList.insertElementAt(attribute, n2);
    }

    public void addAttribute(String string, String string2) {
        Attribute attribute = new Attribute(string, string2);
        this.addAttribute(attribute);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attrList.remove(attribute);
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(this.getAttribute(string));
    }

    public void removeAllAttributes() {
        this.attrList.clear();
    }

    public boolean hasAttributes() {
        return 0 < this.getNAttributes();
    }

    public void setAttribute(String string, String string2) {
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            attribute.setValue(string2);
            return;
        }
        attribute = new Attribute(string, string2);
        this.addAttribute(attribute);
    }

    public void setAttribute(String string, int n2) {
        this.setAttribute(string, Integer.toString(n2));
    }

    public String getAttributeValue(String string) {
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public int getAttributeIntegerValue(String string) {
        String string2 = this.getAttributeValue(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setNameSpace(String string, String string2) {
        this.setAttribute("xmlns:" + string, string2);
    }

    public boolean set(Node node) {
        Object object;
        int n2;
        if (node == null) {
            return false;
        }
        this.setName(node.getName());
        this.setValue(node.getValue());
        this.removeAllAttributes();
        int n3 = node.getNAttributes();
        for (n2 = 0; n2 < n3; ++n2) {
            Attribute attribute = node.getAttribute(n2);
            object = new Attribute(attribute);
            this.addAttribute((Attribute)object);
        }
        this.removeAllNodes();
        n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = node.getNode(i2);
            Node node2 = new Node();
            node2.set((Node)object);
            this.addNode(node2);
        }
        return true;
    }

    public boolean equals(Node node) {
        if (node == null) {
            return false;
        }
        String string = this.toString();
        String string2 = node.toString();
        return string.equals(string2);
    }

    public int getNNodes() {
        return this.nodeList.size();
    }

    public Node getNode(int n2) {
        return this.nodeList.getNode(n2);
    }

    public Node getNode(String string) {
        return this.nodeList.getNode(string);
    }

    public Node getNodeEndsWith(String string) {
        return this.nodeList.getEndsWith(string);
    }

    public void addNode(Node node) {
        node.setParentNode(this);
        this.nodeList.add(node);
    }

    public void insertNode(Node node, int n2) {
        node.setParentNode(this);
        this.nodeList.insertElementAt(node, n2);
    }

    public int getIndex(String string) {
        int n2 = -1;
        Iterator iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            ++n2;
            Node node = (Node)iterator.next();
            if (!node.getName().equals(string)) continue;
            return n2;
        }
        return n2;
    }

    public boolean removeNode(Node node) {
        node.setParentNode(null);
        return this.nodeList.remove(node);
    }

    public boolean removeNode(String string) {
        return this.nodeList.remove(this.getNode(string));
    }

    public void removeAllNodes() {
        this.nodeList.clear();
    }

    public boolean hasNodes() {
        return 0 < this.getNNodes();
    }

    public boolean hasNode(String string) {
        Node node = this.getNode(string);
        return node != null;
    }

    public void setNode(String string) {
        if (this.hasNode(string)) {
            return;
        }
        Node node = new Node(string);
        this.addNode(node);
    }

    public void setNode(String string, String string2) {
        Node node = this.getNode(string);
        if (node == null) {
            node = new Node(string);
            this.addNode(node);
        }
        node.setValue(string2);
    }

    public String getNodeValue(String string) {
        Node node = this.getNode(string);
        if (node != null) {
            return node.getValue();
        }
        return "";
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public String getIndentLevelString(int n2) {
        return this.getIndentLevelString(n2, "   ");
    }

    public String getIndentLevelString(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(n2 * string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void outputAttributes(PrintWriter printWriter) {
        int n2 = this.getNAttributes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = this.getAttribute(i2);
            printWriter.print(" " + attribute.getName() + "=\"" + XML.escapeXMLChars(attribute.getValue()) + "\"");
        }
    }

    public void output(PrintWriter printWriter, int n2, boolean bl) {
        String string = this.getIndentLevelString(n2);
        String string2 = this.getName();
        String string3 = this.getValue();
        if (!this.hasNodes() || !bl) {
            printWriter.print(string + "<" + string2);
            this.outputAttributes(printWriter);
            if (string3 == null || string3.length() == 0) {
                printWriter.println("></" + string2 + ">");
            } else {
                printWriter.println(">" + XML.escapeXMLChars(string3) + "</" + string2 + ">");
            }
            return;
        }
        printWriter.print(string + "<" + string2);
        this.outputAttributes(printWriter);
        printWriter.println(">");
        int n3 = this.getNNodes();
        for (int i2 = 0; i2 < n3; ++i2) {
            Node node = this.getNode(i2);
            node.output(printWriter, n2 + 1, true);
        }
        printWriter.println(string + "</" + string2 + ">");
    }

    public String toString(String string, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        this.output(printWriter, 0, bl);
        printWriter.flush();
        try {
            if (string != null && 0 < string.length()) {
                return byteArrayOutputStream.toString(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byteArrayOutputStream.toString();
    }

    public String toString() {
        return this.toString("utf-8", true);
    }

    public String toXMLString(boolean bl) {
        String string = this.toString();
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public String toXMLString() {
        return this.toXMLString(true);
    }

    public void print(boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.output(printWriter, 0, bl);
        printWriter.flush();
    }

    public void print() {
        this.print(true);
    }
}

