/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.EmptyRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRSIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.TTL;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import com.hpplay.sdk.source.mdns.xbill.dns.UNKRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base16;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;

public abstract class Record
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 2694906050116005466L;
    protected Name name;
    protected int type;
    protected int dclass;
    protected long ttl;
    private static final DecimalFormat byteFormat = new DecimalFormat();

    protected Record() {
    }

    Record(Name name, int n2, int n3, long l2) {
        if (!name.isAbsolute()) {
            Log.e((String)"Record", (String)"name.isAbsolute ");
        } else {
            Type.check(n2);
            DClass.check(n3);
            TTL.check(l2);
            this.name = name;
            this.type = n2;
            this.dclass = n3;
            this.ttl = l2;
        }
    }

    abstract Record getObject();

    private static final Record getEmptyRecord(Name name, int n2, int n3, long l2, boolean bl) {
        Record record;
        Record record2 = bl ? ((record = Type.getProto(n2)) != null ? record.getObject() : new UNKRecord()) : new EmptyRecord();
        ((Record)record2).name = name;
        ((Record)record2).type = n2;
        ((Record)record2).dclass = n3;
        ((Record)record2).ttl = l2;
        return record2;
    }

    abstract void rrFromWire(DNSInput var1);

    private static Record newRecord(Name name, int n2, int n3, long l2, int n4, DNSInput dNSInput) {
        Record record = Record.getEmptyRecord(name, n2, n3, l2, dNSInput != null);
        if (dNSInput != null) {
            if (dNSInput.remaining() < n4) {
                throw new Exception("truncated record");
            }
            dNSInput.setActive(n4);
            record.rrFromWire(dNSInput);
            if (dNSInput.remaining() > 0) {
                throw new Exception("invalid record length");
            }
            dNSInput.clearActive();
        }
        return record;
    }

    public static Record newRecord(Name name, int n2, int n3, long l2, int n4, byte[] byArray) {
        if (name.isAbsolute()) {
            Type.check(n2);
            DClass.check(n3);
            TTL.check(l2);
            DNSInput dNSInput = byArray != null ? new DNSInput(byArray) : null;
            try {
                return Record.newRecord(name, n2, n3, l2, n4, dNSInput);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static Record newRecord(Name name, int n2, int n3, long l2) {
        if (name.isAbsolute()) {
            Type.check(n2);
            DClass.check(n3);
            TTL.check(l2);
            return Record.getEmptyRecord(name, n2, n3, l2, false);
        }
        return null;
    }

    public static Record newRecord(Name name, int n2, int n3) {
        return Record.newRecord(name, n2, n3, 0L);
    }

    static Record fromWire(DNSInput dNSInput, int n2, boolean bl) {
        Name name = new Name(dNSInput);
        int n3 = dNSInput.readU16();
        int n4 = dNSInput.readU16();
        if (n2 == 0) {
            return Record.newRecord(name, n3, n4);
        }
        long l2 = dNSInput.readU32();
        int n5 = dNSInput.readU16();
        if (n5 != 0 || !bl || n2 != 1 && n2 != 2) {
            Record record = Record.newRecord(name, n3, n4, l2, n5, dNSInput);
            return record;
        }
        return Record.newRecord(name, n3, n4, l2);
    }

    void toWire(DNSOutput dNSOutput, int n2, Compression compression) {
        this.name.toWire(dNSOutput, compression);
        dNSOutput.writeU16(this.type);
        dNSOutput.writeU16(this.dclass);
        if (n2 != 0) {
            dNSOutput.writeU32(this.ttl);
            int n3 = dNSOutput.current();
            dNSOutput.writeU16(0);
            this.rrToWire(dNSOutput, compression, false);
            int n4 = dNSOutput.current() - n3 - 2;
            dNSOutput.writeU16At(n4, n3);
        }
    }

    public byte[] toWire(int n2) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, n2, null);
        return dNSOutput.toByteArray();
    }

    private void toWireCanonical(DNSOutput dNSOutput, boolean bl) {
        this.name.toWireCanonical(dNSOutput);
        dNSOutput.writeU16(this.type);
        dNSOutput.writeU16(this.dclass);
        if (bl) {
            dNSOutput.writeU32(0L);
        } else {
            dNSOutput.writeU32(this.ttl);
        }
        int n2 = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.rrToWire(dNSOutput, null, true);
        int n3 = dNSOutput.current() - n2 - 2;
        dNSOutput.writeU16At(n3, n2);
    }

    private byte[] toWireCanonical(boolean bl) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWireCanonical(dNSOutput, bl);
        return dNSOutput.toByteArray();
    }

    public byte[] toWireCanonical() {
        return this.toWireCanonical(false);
    }

    public byte[] rdataToWireCanonical() {
        DNSOutput dNSOutput = new DNSOutput();
        this.rrToWire(dNSOutput, null, true);
        return dNSOutput.toByteArray();
    }

    abstract String rrToString();

    public String rdataToString() {
        return this.rrToString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        if (stringBuffer.length() < 8) {
            stringBuffer.append("\t");
        }
        if (stringBuffer.length() < 16) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("\t");
        if (Options.check("BINDTTL")) {
            stringBuffer.append(TTL.format(this.ttl));
        } else {
            stringBuffer.append(this.ttl);
        }
        stringBuffer.append("\t");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            stringBuffer.append(DClass.string(this.dclass));
            stringBuffer.append("\t");
        }
        stringBuffer.append(Type.string(this.type));
        String string = this.rrToString();
        if (!string.equals("")) {
            stringBuffer.append("\t");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    abstract void rdataFromString(Tokenizer var1, Name var2);

    protected static byte[] byteArrayFromString(String string) {
        byte[] byArray = string.getBytes();
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != 92) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (byArray.length > 255) {
                throw new Exception("text string too long");
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int n3 = 0;
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byte by = byArray[i3];
            if (!bl) {
                if (byArray[i3] == 92) {
                    bl = true;
                    n2 = 0;
                    n3 = 0;
                    continue;
                }
                byteArrayOutputStream.write(byArray[i3]);
                continue;
            }
            if (by >= 48 && by <= 57 && n2 < 3) {
                ++n2;
                n3 *= 10;
                if ((n3 += by - 48) > 255) {
                    throw new Exception("bad escape");
                }
                if (n2 < 3) continue;
                by = (byte)n3;
            } else if (n2 > 0 && n2 < 3) {
                throw new Exception("bad escape");
            }
            byteArrayOutputStream.write(by);
            bl = false;
        }
        if (n2 > 0 && n2 < 3) {
            throw new Exception("bad escape");
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 255) {
            throw new Exception("text string too long");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static String byteArrayToString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('\"');
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (n2 >= 32 && n2 < 127) {
                if (n2 != 34 && n2 != 92) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('\\');
            stringBuffer.append(byteFormat.format(n2));
        }
        if (bl) {
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    protected static String unknownToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\# ");
        stringBuffer.append(byArray.length);
        stringBuffer.append(" ");
        stringBuffer.append(base16.toString(byArray));
        return stringBuffer.toString();
    }

    public static Record fromString(Name name, int n2, int n3, long l2, Tokenizer tokenizer, Name name2) {
        if (!name.isAbsolute()) {
            throw new Exception("fromString name.isAbsolute");
        }
        Type.check(n2);
        DClass.check(n3);
        TTL.check(l2);
        Tokenizer.Token token = tokenizer.get();
        if (token.type == 3 && token.value.equals("\\#")) {
            int n4 = tokenizer.getUInt16();
            byte[] byArray = tokenizer.getHex();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if (n4 != byArray.length) {
                throw tokenizer.exception("invalid unknown RR encoding: length mismatch");
            }
            DNSInput dNSInput = new DNSInput(byArray);
            return Record.newRecord(name, n2, n3, l2, n4, dNSInput);
        }
        tokenizer.unget();
        Record record = Record.getEmptyRecord(name, n2, n3, l2, true);
        record.rdataFromString(tokenizer, name2);
        token = tokenizer.get();
        if (token.type != 1 && token.type != 0) {
            throw tokenizer.exception("unexpected tokens at end of record");
        }
        return record;
    }

    public static Record fromString(Name name, int n2, int n3, long l2, String string, Name name2) {
        return Record.fromString(name, n2, n3, l2, new Tokenizer(string), name2);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getRRsetType() {
        if (this.type == 46) {
            RRSIGRecord rRSIGRecord = (RRSIGRecord)this;
            return rRSIGRecord.getTypeCovered();
        }
        return this.type;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    abstract void rrToWire(DNSOutput var1, Compression var2, boolean var3);

    public boolean sameRRset(Record record) {
        return this.getRRsetType() == record.getRRsetType() && this.dclass == record.dclass && this.name.equals(record.name);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Record) {
            Record record = (Record)object;
            if (this.type == record.type && this.dclass == record.dclass && this.name.equals(record.name)) {
                byte[] byArray = this.rdataToWireCanonical();
                byte[] byArray2 = record.rdataToWireCanonical();
                return Arrays.equals(byArray, byArray2);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.toWireCanonical(true);
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 += (n2 << 3) + (byArray[i2] & 0xFF);
        }
        return n2;
    }

    Record cloneRecord() {
        try {
            return (Record)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    void setTTL(long l2) {
        this.ttl = l2;
    }

    public int compareTo(Object object) {
        Record record = (Record)object;
        if (this == record) {
            return 0;
        }
        int n2 = this.name.compareTo(record.name);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.dclass - record.dclass;
        if (n2 != 0) {
            return n2;
        }
        n2 = this.type - record.type;
        if (n2 != 0) {
            return n2;
        }
        byte[] byArray = this.rdataToWireCanonical();
        byte[] byArray2 = record.rdataToWireCanonical();
        for (int i2 = 0; i2 < byArray.length && i2 < byArray2.length; ++i2) {
            n2 = (byArray[i2] & 0xFF) - (byArray2[i2] & 0xFF);
            if (n2 == 0) continue;
            return n2;
        }
        return byArray.length - byArray2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static int checkU8(String string, int n2) {
        if (n2 >= 0 && n2 <= 255) {
            return n2;
        }
        throw new IllegalArgumentException("\"" + string + "\" " + n2 + " must be an unsigned 8 bit value");
    }

    static int checkU16(String string, int n2) {
        if (n2 >= 0 && n2 <= 65535) {
            return n2;
        }
        throw new IllegalArgumentException("\"" + string + "\" " + n2 + " must be an unsigned 16 bit value");
    }

    static long checkU32(String string, long l2) {
        if (l2 >= 0L && l2 <= 0xFFFFFFFFL) {
            return l2;
        }
        throw new IllegalArgumentException("\"" + string + "\" " + l2 + " must be an unsigned 32 bit value");
    }

    static Name checkName(String string, Name name) {
        if (name.isAbsolute()) {
            return name;
        }
        return null;
    }

    static byte[] checkByteArrayLength(String string, byte[] byArray, int n2) {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("\"" + string + "\" array must have no more than " + n2 + " elements");
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static {
        byteFormat.setMinimumIntegerDigits(3);
    }
}

