/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_256_CHARS = new char[64];
    private static final char[] SHA_1_CHARS = new char[40];

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha256BytesToHex(byte[] byArray) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(byArray, SHA_256_CHARS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha1BytesToHex(byte[] byArray) {
        char[] cArray = SHA_1_CHARS;
        synchronized (SHA_1_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(byArray, SHA_1_CHARS);
        }
    }

    private static String bytesToHex(byte[] byArray, char[] cArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = HEX_CHAR_ARRAY[n2 >>> 4];
            cArray[i2 * 2 + 1] = HEX_CHAR_ARRAY[n2 & 0xF];
        }
        return new String(cArray);
    }

    @Deprecated
    public static int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @TargetApi(value=19)
    public static int getBitmapByteSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bitmap.getHeight() * bitmap.getRowBytes();
    }

    public static int getBitmapByteSize(int n2, int n3, Bitmap.Config config) {
        return n2 * n3 * Util.getBytesPerPixel(config);
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        int n2;
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        switch (config) {
            case ALPHA_8: {
                n2 = 1;
                break;
            }
            case RGB_565: 
            case ARGB_4444: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        return n2;
    }

    public static boolean isValidDimensions(int n2, int n3) {
        return Util.isValidDimension(n2) && Util.isValidDimension(n3);
    }

    private static boolean isValidDimension(int n2) {
        return n2 > 0 || n2 == Integer.MIN_VALUE;
    }

    public static void assertMainThread() {
        if (!Util.isOnMainThread()) {
            throw new IllegalArgumentException("You must call this method on the main thread");
        }
    }

    public static void assertBackgroundThread() {
        if (!Util.isOnBackgroundThread()) {
            throw new IllegalArgumentException("YOu must call this method on a background thread");
        }
    }

    public static boolean isOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isOnBackgroundThread() {
        return !Util.isOnMainThread();
    }

    public static <T> Queue<T> createQueue(int n2) {
        return new ArrayDeque(n2);
    }

    public static <T> List<T> getSnapshot(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        for (T t2 : collection) {
            arrayList.add(t2);
        }
        return arrayList;
    }
}

