/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.os.Bundle;
import androidx.annotation.NonNull;

public class VideoCaptureConfig
implements Cloneable {
    private static final String OPTION_VIDEO_FRAME_RATE = "imageCapture.recordingFrameRate";
    private static final String OPTION_BIT_RATE = "imageCapture.bitRate";
    private static final String OPTION_INTRA_FRAME_INTERVAL = "imageCapture.intraFrameInterval";
    private static final String OPTION_AUDIO_CAPTURE_ENABLE = "imageCapture.audioCaptureEnable";
    private static final String OPTION_AUDIO_BIT_RATE = "imageCapture.audioBitRate";
    private static final String OPTION_AUDIO_SAMPLE_RATE = "imageCapture.audioSampleRate";
    private static final String OPTION_AUDIO_CHANNEL_COUNT = "imageCapture.audioChannelCount";
    private static final String OPTION_AUDIO_MIN_BUFFER_SIZE = "imageCapture.audioMinBufferSize";
    private static final int DEFAULT_VIDEO_FRAME_RATE = 30;
    private static final int DEFAULT_BIT_RATE = 0x800000;
    private static final int DEFAULT_INTRA_FRAME_INTERVAL = 1;
    private static final boolean DEFAULT_AUDIO_CAPTURE_ENABLE = true;
    private static final int DEFAULT_AUDIO_BIT_RATE = 64000;
    private static final int DEFAULT_AUDIO_SAMPLE_RATE = 8000;
    private static final int DEFAULT_AUDIO_CHANNEL_COUNT = 1;
    private static final int DEFAULT_AUDIO_MIN_BUFFER_SIZE = 1024;
    private Bundle mMutableConfig = new Bundle();

    VideoCaptureConfig() {
    }

    Bundle getMutableConfig() {
        return this.mMutableConfig;
    }

    @NonNull
    public VideoCaptureConfig setVideoFrameRate(int videoFrameRate) {
        this.getMutableConfig().putInt(OPTION_VIDEO_FRAME_RATE, videoFrameRate);
        return this;
    }

    public int getVideoFrameRate() {
        return this.getMutableConfig().getInt(OPTION_VIDEO_FRAME_RATE, 30);
    }

    @NonNull
    public VideoCaptureConfig setBitRate(int bitRate) {
        this.getMutableConfig().putInt(OPTION_BIT_RATE, bitRate);
        return this;
    }

    public boolean hasBitRate() {
        return this.getMutableConfig().containsKey(OPTION_BIT_RATE);
    }

    public int getBitRate() {
        return this.getMutableConfig().getInt(OPTION_BIT_RATE, 0x800000);
    }

    @NonNull
    public VideoCaptureConfig setIFrameInterval(int interval) {
        this.getMutableConfig().putInt(OPTION_INTRA_FRAME_INTERVAL, interval);
        return this;
    }

    public int getIFrameInterval() {
        return this.getMutableConfig().getInt(OPTION_INTRA_FRAME_INTERVAL, 1);
    }

    @NonNull
    public VideoCaptureConfig setAudioCaptureEnable(boolean enable) {
        this.getMutableConfig().putBoolean(OPTION_AUDIO_CAPTURE_ENABLE, enable);
        return this;
    }

    public boolean getAudioCaptureEnable() {
        return this.getMutableConfig().getBoolean(OPTION_AUDIO_CAPTURE_ENABLE, true);
    }

    @NonNull
    public VideoCaptureConfig setAudioBitRate(int bitRate) {
        this.getMutableConfig().putInt(OPTION_AUDIO_BIT_RATE, bitRate);
        return this;
    }

    public int getAudioBitRate() {
        return this.getMutableConfig().getInt(OPTION_AUDIO_BIT_RATE, 64000);
    }

    @NonNull
    public VideoCaptureConfig setAudioSampleRate(int sampleRate) {
        this.getMutableConfig().putInt(OPTION_AUDIO_SAMPLE_RATE, sampleRate);
        return this;
    }

    public int getAudioSampleRate() {
        return this.getMutableConfig().getInt(OPTION_AUDIO_SAMPLE_RATE, 8000);
    }

    @NonNull
    public VideoCaptureConfig setAudioChannelCount(int channelCount) {
        this.getMutableConfig().putInt(OPTION_AUDIO_CHANNEL_COUNT, channelCount);
        return this;
    }

    public int getAudioChannelCount() {
        return this.getMutableConfig().getInt(OPTION_AUDIO_CHANNEL_COUNT, 1);
    }

    @NonNull
    public VideoCaptureConfig setAudioMinBufferSize(int minBufferSize) {
        this.getMutableConfig().putInt(OPTION_AUDIO_MIN_BUFFER_SIZE, minBufferSize);
        return this;
    }

    public int getAudioMinBufferSize() {
        return this.getMutableConfig().getInt(OPTION_AUDIO_MIN_BUFFER_SIZE, 1024);
    }

    @NonNull
    protected Object clone() {
        VideoCaptureConfig obj = null;
        try {
            obj = (VideoCaptureConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (obj == null) {
            obj = new VideoCaptureConfig();
        }
        obj.mMutableConfig = (Bundle)this.mMutableConfig.clone();
        return obj;
    }
}

